/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.benchmarks;

import java.io.IOException;
import java.util.Arrays;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.benchmarks.BenchmarkFiles;
import org.apache.parquet.benchmarks.BenchmarkUtils;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.example.data.simple.SimpleGroupFactory;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.hadoop.example.GroupWriteSupport;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.MessageTypeParser;

public class DataGenerator {
    public void generateAll() {
        try {
            this.generateData(BenchmarkFiles.file_1M, BenchmarkFiles.configuration, ParquetProperties.WriterVersion.PARQUET_2_0, 0x8000000, 0x100000, 1024, CompressionCodecName.UNCOMPRESSED, 1000000);
            this.generateData(BenchmarkFiles.file_1M_BS256M_PS4M, BenchmarkFiles.configuration, ParquetProperties.WriterVersion.PARQUET_2_0, 0x10000000, 0x400000, 1024, CompressionCodecName.UNCOMPRESSED, 1000000);
            this.generateData(BenchmarkFiles.file_1M_BS256M_PS8M, BenchmarkFiles.configuration, ParquetProperties.WriterVersion.PARQUET_2_0, 0x10000000, 0x800000, 1024, CompressionCodecName.UNCOMPRESSED, 1000000);
            this.generateData(BenchmarkFiles.file_1M_BS512M_PS4M, BenchmarkFiles.configuration, ParquetProperties.WriterVersion.PARQUET_2_0, 0x20000000, 0x400000, 1024, CompressionCodecName.UNCOMPRESSED, 1000000);
            this.generateData(BenchmarkFiles.file_1M_BS512M_PS8M, BenchmarkFiles.configuration, ParquetProperties.WriterVersion.PARQUET_2_0, 0x20000000, 0x800000, 1024, CompressionCodecName.UNCOMPRESSED, 1000000);
            this.generateData(BenchmarkFiles.file_1M_SNAPPY, BenchmarkFiles.configuration, ParquetProperties.WriterVersion.PARQUET_2_0, 0x8000000, 0x100000, 1024, CompressionCodecName.SNAPPY, 1000000);
            this.generateData(BenchmarkFiles.file_1M_GZIP, BenchmarkFiles.configuration, ParquetProperties.WriterVersion.PARQUET_2_0, 0x8000000, 0x100000, 1024, CompressionCodecName.GZIP, 1000000);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void generateData(Path outFile, Configuration configuration, ParquetProperties.WriterVersion version, int blockSize, int pageSize, int fixedLenByteArraySize, CompressionCodecName codec, int nRows) throws IOException {
        if (BenchmarkUtils.exists(configuration, outFile)) {
            System.out.println("File already exists " + outFile);
            return;
        }
        System.out.println("Generating data @ " + outFile);
        MessageType schema = MessageTypeParser.parseMessageType((String)("message test { required binary binary_field; required int32 int32_field; required int64 int64_field; required boolean boolean_field; required float float_field; required double double_field; required fixed_len_byte_array(" + fixedLenByteArraySize + ") flba_field; " + "required int96 int96_field; " + "} "));
        GroupWriteSupport.setSchema((MessageType)schema, (Configuration)configuration);
        SimpleGroupFactory f = new SimpleGroupFactory(schema);
        ParquetWriter writer = new ParquetWriter(outFile, (WriteSupport)new GroupWriteSupport(), codec, blockSize, pageSize, 512, true, false, version, configuration);
        char[] chars = new char[fixedLenByteArraySize];
        Arrays.fill(chars, '*');
        for (int i = 0; i < nRows; ++i) {
            writer.write((Object)f.newGroup().append("binary_field", UUID.randomUUID().toString()).append("int32_field", i).append("int64_field", 64L).append("boolean_field", true).append("float_field", 1.0f).append("double_field", 2.0).append("flba_field", new String(chars)).append("int96_field", Binary.fromConstantByteArray((byte[])new byte[12])));
        }
        writer.close();
    }

    public void cleanup() {
        BenchmarkUtils.deleteIfExists(BenchmarkFiles.configuration, BenchmarkFiles.file_1M);
        BenchmarkUtils.deleteIfExists(BenchmarkFiles.configuration, BenchmarkFiles.file_1M_BS256M_PS4M);
        BenchmarkUtils.deleteIfExists(BenchmarkFiles.configuration, BenchmarkFiles.file_1M_BS256M_PS8M);
        BenchmarkUtils.deleteIfExists(BenchmarkFiles.configuration, BenchmarkFiles.file_1M_BS512M_PS4M);
        BenchmarkUtils.deleteIfExists(BenchmarkFiles.configuration, BenchmarkFiles.file_1M_BS512M_PS8M);
        BenchmarkUtils.deleteIfExists(BenchmarkFiles.configuration, BenchmarkFiles.file_1M_SNAPPY);
        BenchmarkUtils.deleteIfExists(BenchmarkFiles.configuration, BenchmarkFiles.file_1M_GZIP);
    }

    public static void main(String[] args) {
        String command;
        DataGenerator generator = new DataGenerator();
        if (args.length < 1) {
            System.err.println("Please specify a command (generate|cleanup).");
            System.exit(1);
        }
        if ((command = args[0]).equalsIgnoreCase("generate")) {
            generator.generateAll();
        } else if (command.equalsIgnoreCase("cleanup")) {
            generator.cleanup();
        } else {
            throw new IllegalArgumentException("invalid command " + command);
        }
    }
}

