/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.benchmarks;

import java.io.IOException;
import org.apache.parquet.benchmarks.BenchmarkFiles;
import org.apache.parquet.benchmarks.PageChecksumDataGenerator;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;

@State(value=Scope.Thread)
public class PageChecksumWriteBenchmarks {
    private PageChecksumDataGenerator pageChecksumDataGenerator = new PageChecksumDataGenerator();

    @Setup(value=Level.Iteration)
    public void setup() {
        this.pageChecksumDataGenerator.cleanup();
    }

    @Benchmark
    @BenchmarkMode(value={Mode.SingleShotTime})
    public void write100KRowsUncompressedWithoutChecksums() throws IOException {
        this.pageChecksumDataGenerator.generateData(BenchmarkFiles.file_100K_NOCHECKSUMS_UNCOMPRESSED, 100000, false, CompressionCodecName.UNCOMPRESSED);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.SingleShotTime})
    public void write100KRowsUncompressedWithChecksums() throws IOException {
        this.pageChecksumDataGenerator.generateData(BenchmarkFiles.file_100K_CHECKSUMS_UNCOMPRESSED, 100000, true, CompressionCodecName.UNCOMPRESSED);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.SingleShotTime})
    public void write100KRowsGzipWithoutChecksums() throws IOException {
        this.pageChecksumDataGenerator.generateData(BenchmarkFiles.file_100K_NOCHECKSUMS_GZIP, 100000, false, CompressionCodecName.GZIP);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.SingleShotTime})
    public void write100KRowsGzipWithChecksums() throws IOException {
        this.pageChecksumDataGenerator.generateData(BenchmarkFiles.file_100K_CHECKSUMS_GZIP, 100000, true, CompressionCodecName.GZIP);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.SingleShotTime})
    public void write100KRowsSnappyWithoutChecksums() throws IOException {
        this.pageChecksumDataGenerator.generateData(BenchmarkFiles.file_100K_NOCHECKSUMS_SNAPPY, 100000, false, CompressionCodecName.SNAPPY);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.SingleShotTime})
    public void write100KRowsSnappyWithChecksums() throws IOException {
        this.pageChecksumDataGenerator.generateData(BenchmarkFiles.file_100K_CHECKSUMS_SNAPPY, 100000, true, CompressionCodecName.SNAPPY);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.SingleShotTime})
    public void write1MRowsUncompressedWithoutChecksums() throws IOException {
        this.pageChecksumDataGenerator.generateData(BenchmarkFiles.file_1M_NOCHECKSUMS_UNCOMPRESSED, 1000000, false, CompressionCodecName.UNCOMPRESSED);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.SingleShotTime})
    public void write1MRowsUncompressedWithChecksums() throws IOException {
        this.pageChecksumDataGenerator.generateData(BenchmarkFiles.file_1M_CHECKSUMS_UNCOMPRESSED, 1000000, true, CompressionCodecName.UNCOMPRESSED);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.SingleShotTime})
    public void write1MRowsGzipWithoutChecksums() throws IOException {
        this.pageChecksumDataGenerator.generateData(BenchmarkFiles.file_1M_NOCHECKSUMS_GZIP, 1000000, false, CompressionCodecName.GZIP);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.SingleShotTime})
    public void write1MRowsGzipWithChecksums() throws IOException {
        this.pageChecksumDataGenerator.generateData(BenchmarkFiles.file_1M_CHECKSUMS_GZIP, 1000000, true, CompressionCodecName.GZIP);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.SingleShotTime})
    public void write1MRowsSnappyWithoutChecksums() throws IOException {
        this.pageChecksumDataGenerator.generateData(BenchmarkFiles.file_1M_NOCHECKSUMS_SNAPPY, 1000000, false, CompressionCodecName.SNAPPY);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.SingleShotTime})
    public void write1MRowsSnappyWithChecksums() throws IOException {
        this.pageChecksumDataGenerator.generateData(BenchmarkFiles.file_1M_CHECKSUMS_SNAPPY, 1000000, true, CompressionCodecName.SNAPPY);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.SingleShotTime})
    public void write10MRowsUncompressedWithoutChecksums() throws IOException {
        this.pageChecksumDataGenerator.generateData(BenchmarkFiles.file_10M_NOCHECKSUMS_UNCOMPRESSED, 10000000, false, CompressionCodecName.UNCOMPRESSED);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.SingleShotTime})
    public void write10MRowsUncompressedWithChecksums() throws IOException {
        this.pageChecksumDataGenerator.generateData(BenchmarkFiles.file_10M_CHECKSUMS_UNCOMPRESSED, 10000000, true, CompressionCodecName.UNCOMPRESSED);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.SingleShotTime})
    public void write10MRowsGzipWithoutChecksums() throws IOException {
        this.pageChecksumDataGenerator.generateData(BenchmarkFiles.file_10M_NOCHECKSUMS_GZIP, 10000000, false, CompressionCodecName.GZIP);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.SingleShotTime})
    public void write10MRowsGzipWithChecksums() throws IOException {
        this.pageChecksumDataGenerator.generateData(BenchmarkFiles.file_10M_CHECKSUMS_GZIP, 10000000, true, CompressionCodecName.GZIP);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.SingleShotTime})
    public void write10MRowsSnappyWithoutChecksums() throws IOException {
        this.pageChecksumDataGenerator.generateData(BenchmarkFiles.file_10M_NOCHECKSUMS_SNAPPY, 10000000, false, CompressionCodecName.SNAPPY);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.SingleShotTime})
    public void write10MRowsSnappyWithChecksums() throws IOException {
        this.pageChecksumDataGenerator.generateData(BenchmarkFiles.file_10M_CHECKSUMS_SNAPPY, 10000000, true, CompressionCodecName.SNAPPY);
    }
}

