/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.benchmarks;

import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.benchmarks.BenchmarkFiles;
import org.apache.parquet.benchmarks.DataGenerator;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.hadoop.ParquetReader;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.example.GroupReadSupport;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.infra.Blackhole;

@State(value=Scope.Benchmark)
public class ReadBenchmarks {
    private void read(Path parquetFile, int nRows, Blackhole blackhole) throws IOException {
        ParquetReader reader = ParquetReader.builder((ReadSupport)new GroupReadSupport(), (Path)parquetFile).withConf(BenchmarkFiles.configuration).build();
        for (int i = 0; i < nRows; ++i) {
            Group group = (Group)reader.read();
            blackhole.consume((Object)group.getBinary("binary_field", 0));
            blackhole.consume(group.getInteger("int32_field", 0));
            blackhole.consume(group.getLong("int64_field", 0));
            blackhole.consume(group.getBoolean("boolean_field", 0));
            blackhole.consume(group.getFloat("float_field", 0));
            blackhole.consume(group.getDouble("double_field", 0));
            blackhole.consume((Object)group.getBinary("flba_field", 0));
            blackhole.consume((Object)group.getInt96("int96_field", 0));
        }
        reader.close();
    }

    @Setup(value=Level.Trial)
    public void generateFilesForRead() {
        new DataGenerator().generateAll();
    }

    @Benchmark
    @BenchmarkMode(value={Mode.SingleShotTime})
    public void read1MRowsDefaultBlockAndPageSizeUncompressed(Blackhole blackhole) throws IOException {
        this.read(BenchmarkFiles.file_1M, 1000000, blackhole);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.SingleShotTime})
    public void read1MRowsBS256MPS4MUncompressed(Blackhole blackhole) throws IOException {
        this.read(BenchmarkFiles.file_1M_BS256M_PS4M, 1000000, blackhole);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.SingleShotTime})
    public void read1MRowsBS256MPS8MUncompressed(Blackhole blackhole) throws IOException {
        this.read(BenchmarkFiles.file_1M_BS256M_PS8M, 1000000, blackhole);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.SingleShotTime})
    public void read1MRowsBS512MPS4MUncompressed(Blackhole blackhole) throws IOException {
        this.read(BenchmarkFiles.file_1M_BS512M_PS4M, 1000000, blackhole);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.SingleShotTime})
    public void read1MRowsBS512MPS8MUncompressed(Blackhole blackhole) throws IOException {
        this.read(BenchmarkFiles.file_1M_BS512M_PS8M, 1000000, blackhole);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.SingleShotTime})
    public void read1MRowsDefaultBlockAndPageSizeSNAPPY(Blackhole blackhole) throws IOException {
        this.read(BenchmarkFiles.file_1M_SNAPPY, 1000000, blackhole);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.SingleShotTime})
    public void read1MRowsDefaultBlockAndPageSizeGZIP(Blackhole blackhole) throws IOException {
        this.read(BenchmarkFiles.file_1M_GZIP, 1000000, blackhole);
    }
}

