/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.benchmarks;

import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.benchmarks.BenchmarkFiles;
import org.apache.parquet.benchmarks.PageChecksumDataGenerator;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.hadoop.ParquetReader;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.example.GroupReadSupport;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.infra.Blackhole;

@State(value=Scope.Thread)
public class PageChecksumReadBenchmarks {
    private PageChecksumDataGenerator pageChecksumDataGenerator = new PageChecksumDataGenerator();

    @Setup(value=Level.Trial)
    public void setup() {
        this.pageChecksumDataGenerator.generateAll();
    }

    private void readFile(Path file, int nRows, boolean verifyChecksums, Blackhole blackhole) throws IOException {
        try (ParquetReader reader = ParquetReader.builder((ReadSupport)new GroupReadSupport(), (Path)file).withConf(BenchmarkFiles.configuration).usePageChecksumVerification(verifyChecksums).build();){
            for (int i = 0; i < nRows; ++i) {
                Group group = (Group)reader.read();
                blackhole.consume(group.getLong("long_field", 0));
                blackhole.consume((Object)group.getBinary("binary_field", 0));
                Group subgroup = group.getGroup("group", 0);
                blackhole.consume(subgroup.getInteger("int_field", 0));
                blackhole.consume(subgroup.getInteger("int_field", 1));
                blackhole.consume(subgroup.getInteger("int_field", 2));
                blackhole.consume(subgroup.getInteger("int_field", 3));
            }
        }
    }

    @Benchmark
    @BenchmarkMode(value={Mode.SingleShotTime})
    public void read100KRowsUncompressedWithoutVerification(Blackhole blackhole) throws IOException {
        this.readFile(BenchmarkFiles.file_100K_CHECKSUMS_UNCOMPRESSED, 100000, false, blackhole);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.SingleShotTime})
    public void read100KRowsUncompressedWithVerification(Blackhole blackhole) throws IOException {
        this.readFile(BenchmarkFiles.file_100K_CHECKSUMS_UNCOMPRESSED, 100000, true, blackhole);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.SingleShotTime})
    public void read100KRowsGzipWithoutVerification(Blackhole blackhole) throws IOException {
        this.readFile(BenchmarkFiles.file_100K_CHECKSUMS_GZIP, 100000, false, blackhole);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.SingleShotTime})
    public void read100KRowsGzipWithVerification(Blackhole blackhole) throws IOException {
        this.readFile(BenchmarkFiles.file_100K_CHECKSUMS_GZIP, 100000, true, blackhole);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.SingleShotTime})
    public void read100KRowsSnappyWithoutVerification(Blackhole blackhole) throws IOException {
        this.readFile(BenchmarkFiles.file_100K_CHECKSUMS_SNAPPY, 100000, false, blackhole);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.SingleShotTime})
    public void read100KRowsSnappyWithVerification(Blackhole blackhole) throws IOException {
        this.readFile(BenchmarkFiles.file_100K_CHECKSUMS_SNAPPY, 100000, true, blackhole);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.SingleShotTime})
    public void read1MRowsUncompressedWithoutVerification(Blackhole blackhole) throws IOException {
        this.readFile(BenchmarkFiles.file_1M_CHECKSUMS_UNCOMPRESSED, 1000000, false, blackhole);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.SingleShotTime})
    public void read1MRowsUncompressedWithVerification(Blackhole blackhole) throws IOException {
        this.readFile(BenchmarkFiles.file_1M_CHECKSUMS_UNCOMPRESSED, 1000000, true, blackhole);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.SingleShotTime})
    public void read1MRowsGzipWithoutVerification(Blackhole blackhole) throws IOException {
        this.readFile(BenchmarkFiles.file_1M_CHECKSUMS_GZIP, 1000000, false, blackhole);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.SingleShotTime})
    public void read1MRowsGzipWithVerification(Blackhole blackhole) throws IOException {
        this.readFile(BenchmarkFiles.file_1M_CHECKSUMS_GZIP, 1000000, true, blackhole);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.SingleShotTime})
    public void read1MRowsSnappyWithoutVerification(Blackhole blackhole) throws IOException {
        this.readFile(BenchmarkFiles.file_1M_CHECKSUMS_SNAPPY, 1000000, false, blackhole);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.SingleShotTime})
    public void read1MRowsSnappyWithVerification(Blackhole blackhole) throws IOException {
        this.readFile(BenchmarkFiles.file_1M_CHECKSUMS_SNAPPY, 1000000, true, blackhole);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.SingleShotTime})
    public void read10MRowsUncompressedWithoutVerification(Blackhole blackhole) throws IOException {
        this.readFile(BenchmarkFiles.file_10M_CHECKSUMS_UNCOMPRESSED, 10000000, false, blackhole);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.SingleShotTime})
    public void read10MRowsUncompressedWithVerification(Blackhole blackhole) throws IOException {
        this.readFile(BenchmarkFiles.file_10M_CHECKSUMS_UNCOMPRESSED, 10000000, true, blackhole);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.SingleShotTime})
    public void read10MRowsGzipWithoutVerification(Blackhole blackhole) throws IOException {
        this.readFile(BenchmarkFiles.file_10M_CHECKSUMS_GZIP, 10000000, false, blackhole);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.SingleShotTime})
    public void read10MRowsGzipWithVerification(Blackhole blackhole) throws IOException {
        this.readFile(BenchmarkFiles.file_10M_CHECKSUMS_GZIP, 10000000, true, blackhole);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.SingleShotTime})
    public void read10MRowsSnappyWithoutVerification(Blackhole blackhole) throws IOException {
        this.readFile(BenchmarkFiles.file_10M_CHECKSUMS_SNAPPY, 10000000, false, blackhole);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.SingleShotTime})
    public void read10MRowsSnappyWithVerification(Blackhole blackhole) throws IOException {
        this.readFile(BenchmarkFiles.file_10M_CHECKSUMS_SNAPPY, 10000000, true, blackhole);
    }
}

