/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.benchmarks;

import java.io.IOException;
import java.util.Random;
import java.util.UUID;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.benchmarks.BenchmarkFiles;
import org.apache.parquet.benchmarks.BenchmarkUtils;
import org.apache.parquet.benchmarks.DataGenerator;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.example.data.simple.SimpleGroupFactory;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.example.ExampleParquetWriter;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.MessageTypeParser;

public class PageChecksumDataGenerator
extends DataGenerator {
    private final MessageType SCHEMA = MessageTypeParser.parseMessageType((String)"message m {  required int64 long_field;  required binary binary_field;  required group group {    repeated int32 int_field;  }}");

    public void generateData(Path outFile, int nRows, boolean writeChecksums, CompressionCodecName compression) throws IOException {
        if (BenchmarkUtils.exists(BenchmarkFiles.configuration, outFile)) {
            System.out.println("File already exists " + outFile);
            return;
        }
        ParquetWriter writer = ((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)ExampleParquetWriter.builder((Path)outFile).withConf(BenchmarkFiles.configuration)).withWriteMode(ParquetFileWriter.Mode.OVERWRITE)).withCompressionCodec(compression)).withDictionaryEncoding(true)).withType(this.SCHEMA).withPageWriteChecksumEnabled(writeChecksums)).build();
        SimpleGroupFactory groupFactory = new SimpleGroupFactory(this.SCHEMA);
        Random rand = new Random(42L);
        for (int i = 0; i < nRows; ++i) {
            Group group = groupFactory.newGroup();
            group.append("long_field", (long)i).append("binary_field", UUID.randomUUID().toString()).addGroup("group").append("int_field", rand.nextInt() % 100).append("int_field", rand.nextInt() % 100).append("int_field", rand.nextInt() % 100).append("int_field", rand.nextInt() % 100);
            writer.write((Object)group);
        }
        writer.close();
    }

    @Override
    public void generateAll() {
        try {
            this.generateData(BenchmarkFiles.file_100K_CHECKSUMS_UNCOMPRESSED, 100000, true, CompressionCodecName.UNCOMPRESSED);
            this.generateData(BenchmarkFiles.file_100K_CHECKSUMS_GZIP, 100000, true, CompressionCodecName.GZIP);
            this.generateData(BenchmarkFiles.file_100K_CHECKSUMS_SNAPPY, 100000, true, CompressionCodecName.SNAPPY);
            this.generateData(BenchmarkFiles.file_1M_CHECKSUMS_UNCOMPRESSED, 1000000, true, CompressionCodecName.UNCOMPRESSED);
            this.generateData(BenchmarkFiles.file_1M_CHECKSUMS_GZIP, 1000000, true, CompressionCodecName.GZIP);
            this.generateData(BenchmarkFiles.file_1M_CHECKSUMS_SNAPPY, 1000000, true, CompressionCodecName.SNAPPY);
            this.generateData(BenchmarkFiles.file_10M_CHECKSUMS_UNCOMPRESSED, 10000000, true, CompressionCodecName.UNCOMPRESSED);
            this.generateData(BenchmarkFiles.file_10M_CHECKSUMS_GZIP, 10000000, true, CompressionCodecName.GZIP);
            this.generateData(BenchmarkFiles.file_10M_CHECKSUMS_SNAPPY, 10000000, true, CompressionCodecName.SNAPPY);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

