/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.benchmarks;

import java.io.IOException;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.example.data.GroupFactory;
import org.apache.parquet.example.data.simple.SimpleGroupFactory;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.example.ExampleParquetWriter;
import org.apache.parquet.io.OutputFile;
import org.apache.parquet.io.PositionOutputStream;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;

@BenchmarkMode(value={Mode.SingleShotTime})
@Fork(value=1)
@Warmup(iterations=10, batchSize=1)
@Measurement(iterations=50, batchSize=1)
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@State(value=Scope.Benchmark)
public class NestedNullWritingBenchmarks {
    private static final MessageType SCHEMA = (MessageType)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildMessage().optionalList().optionalElement(PrimitiveType.PrimitiveTypeName.INT32).named("int_list")).optionalList().optionalListElement().optionalElement(PrimitiveType.PrimitiveTypeName.BINARY).named("dummy_list")).optionalMap().key(PrimitiveType.PrimitiveTypeName.BINARY).value(PrimitiveType.PrimitiveTypeName.BINARY, Type.Repetition.OPTIONAL).named("dummy_map")).optionalGroup().optional(PrimitiveType.PrimitiveTypeName.BINARY).named("dummy_group_value1")).optional(PrimitiveType.PrimitiveTypeName.BINARY).named("dummy_group_value2")).optional(PrimitiveType.PrimitiveTypeName.BINARY).named("dummy_group_value3")).named("dummy_group")).named("msg");
    private static final int RECORD_COUNT = 10000000;
    private static final double NULL_RATIO = 0.99;
    private static final OutputFile BLACK_HOLE = new OutputFile(){

        public boolean supportsBlockSize() {
            return false;
        }

        public long defaultBlockSize() {
            return -1L;
        }

        public PositionOutputStream createOrOverwrite(long blockSizeHint) {
            return this.create(blockSizeHint);
        }

        public PositionOutputStream create(long blockSizeHint) {
            return new PositionOutputStream(){
                private long pos;

                public long getPos() throws IOException {
                    return this.pos;
                }

                public void write(int b) throws IOException {
                    ++this.pos;
                }
            };
        }

        public String getPath() {
            throw new UnsupportedOperationException();
        }
    };

    @Benchmark
    public void benchmarkWriting() throws IOException {
        ValueGenerator generator = new ValueGenerator();
        try (ParquetWriter writer = ((ExampleParquetWriter.Builder)ExampleParquetWriter.builder((OutputFile)BLACK_HOLE).withWriteMode(ParquetFileWriter.Mode.OVERWRITE)).withType(SCHEMA).build();){
            for (int i = 0; i < 10000000; ++i) {
                writer.write((Object)generator.nextValue());
            }
        }
    }

    static /* synthetic */ MessageType access$000() {
        return SCHEMA;
    }

    private static class ValueGenerator {
        private static final GroupFactory FACTORY = new SimpleGroupFactory(NestedNullWritingBenchmarks.access$000());
        private static final Group NULL = FACTORY.newGroup();
        private final Random random = new Random(42L);

        private ValueGenerator() {
        }

        public Group nextValue() {
            if (this.random.nextDouble() > 0.99) {
                Group group = FACTORY.newGroup();
                group.addGroup("int_list").addGroup("list").append("element", this.random.nextInt());
                return group;
            }
            return NULL;
        }
    }
}

