/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.benchmarks;

import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.example.data.simple.SimpleGroup;
import org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.parquet.filter2.predicate.FilterApi;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.filter2.predicate.Operators;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.ParquetReader;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.example.ExampleParquetWriter;
import org.apache.parquet.hadoop.example.GroupReadSupport;
import org.apache.parquet.hadoop.util.HadoopInputFile;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Types;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BenchmarkMode(value={Mode.SingleShotTime})
@Fork(value=1)
@Warmup(iterations=10, batchSize=1)
@Measurement(iterations=50, batchSize=1)
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
public class FilteringBenchmarks {
    private static final int RECORD_COUNT = 2000000;
    private static final Logger LOGGER = LoggerFactory.getLogger(FilteringBenchmarks.class);

    @Benchmark
    public void benchmarkWithOrWithoutColumnIndex(Blackhole blackhole, WithOrWithoutColumnIndexContext context) throws Exception {
        this.benchmark(blackhole, context);
    }

    @Benchmark
    public void benchmarkPageSize(Blackhole blackhole, PageSizeContext context) throws Exception {
        this.benchmark(blackhole, context);
    }

    private void benchmark(Blackhole blackhole, BaseContext context) throws Exception {
        Operators.Eq filter = FilterApi.eq((Operators.Column)BaseContext.COLUMN, (Comparable)Long.valueOf(context.getRandom().nextLong()));
        try (ParquetReader reader = context.createReaderBuilder().withFilter(FilterCompat.get((FilterPredicate)filter)).build();){
            blackhole.consume(reader.read());
        }
    }

    @State(value=Scope.Benchmark)
    public static class PageSizeContext
    extends BaseContext {
        @Param
        private PageRowLimit pageRowLimit;

        @Override
        WriteConfigurator getWriteConfigurator() {
            return this.pageRowLimit;
        }

        @Override
        ReadConfigurator getReadConfigurator() {
            return ColumnIndexUsage.WITH_COLUMN_INDEX;
        }
    }

    @State(value=Scope.Benchmark)
    public static class WithOrWithoutColumnIndexContext
    extends BaseContext {
        @Param
        private ColumnIndexUsage columnIndexUsage;

        @Override
        ReadConfigurator getReadConfigurator() {
            return this.columnIndexUsage;
        }
    }

    @State(value=Scope.Benchmark)
    public static abstract class BaseContext {
        private static final MessageType SCHEMA = (MessageType)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.GroupBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.INT64).named("int64_col")).required(PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named("dummy1_col")).required(PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named("dummy2_col")).required(PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named("dummy3_col")).required(PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named("dummy4_col")).required(PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named("dummy5_col")).named("schema");
        public static final Operators.LongColumn COLUMN = FilterApi.longColumn((String)"int64_col");
        private Path file;
        private Random random;
        private StringGenerator dummyGenerator;
        @Param
        private ColumnCharacteristic characteristic;

        @Setup
        public void writeFile() throws IOException {
            WriteConfigurator writeConfigurator = this.getWriteConfigurator();
            this.file = new Path(Files.createTempFile("benchmark-filtering_" + (Object)((Object)this.characteristic) + '_' + writeConfigurator + '_', ".parquet", new FileAttribute[0]).toAbsolutePath().toString());
            long[] data = this.generateData();
            this.characteristic.arrangeData(data);
            try (ParquetWriter writer = writeConfigurator.configureBuilder(((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)ExampleParquetWriter.builder((Path)this.file).config("parquet.example.schema", SCHEMA.toString())).withRowGroupSize(Integer.MAX_VALUE)).withWriteMode(ParquetFileWriter.Mode.OVERWRITE)).build();){
                for (long value : data) {
                    SimpleGroup group = new SimpleGroup((GroupType)SCHEMA);
                    group.add(0, value);
                    group.add(1, Binary.fromString((String)this.dummyGenerator.nextString()));
                    group.add(2, Binary.fromString((String)this.dummyGenerator.nextString()));
                    group.add(3, Binary.fromString((String)this.dummyGenerator.nextString()));
                    group.add(4, Binary.fromString((String)this.dummyGenerator.nextString()));
                    group.add(5, Binary.fromString((String)this.dummyGenerator.nextString()));
                    writer.write((Object)group);
                }
            }
        }

        WriteConfigurator getWriteConfigurator() {
            return WriteConfigurator.DEFAULT;
        }

        ReadConfigurator getReadConfigurator() {
            return ReadConfigurator.DEFAULT;
        }

        private long[] generateData() {
            Random random = new Random(43L);
            long[] data = new long[2000000];
            int n = data.length;
            for (int i = 0; i < n; ++i) {
                data[i] = random.nextLong();
            }
            return data;
        }

        @Setup
        public void resetRandom() {
            this.random = new Random(42L);
            this.dummyGenerator = new StringGenerator();
        }

        @Setup(value=Level.Invocation)
        public void gc() {
            System.gc();
        }

        @TearDown
        public void deleteFile() throws IOException {
            LOGGER.info("Deleting file {} (size: {})", (Object)this.file, (Object)new FileSize(this.file));
            this.file.getFileSystem(new Configuration()).delete(this.file, false);
        }

        public ParquetReader.Builder<Group> createReaderBuilder() throws IOException {
            ReadConfigurator readConfigurator = this.getReadConfigurator();
            return readConfigurator.configureBuilder(new ParquetReader.Builder<Group>((InputFile)HadoopInputFile.fromPath((Path)this.file, (Configuration)new Configuration())){

                protected ReadSupport<Group> getReadSupport() {
                    return new GroupReadSupport();
                }
            }.set("parquet.example.schema", SCHEMA.toString()));
        }

        public Random getRandom() {
            return this.random;
        }
    }

    public static enum PageRowLimit implements WriteConfigurator
    {
        PAGE_ROW_COUNT_1K{

            @Override
            public <T> ParquetWriter.Builder<T, ?> configureBuilder(ParquetWriter.Builder<T, ?> builder) {
                return builder.withPageSize(Integer.MAX_VALUE).withPageRowCountLimit(1000);
            }
        }
        ,
        PAGE_ROW_COUNT_10K{

            @Override
            public <T> ParquetWriter.Builder<T, ?> configureBuilder(ParquetWriter.Builder<T, ?> builder) {
                return builder.withPageSize(Integer.MAX_VALUE).withPageRowCountLimit(10000);
            }
        }
        ,
        PAGE_ROW_COUNT_50K{

            @Override
            public <T> ParquetWriter.Builder<T, ?> configureBuilder(ParquetWriter.Builder<T, ?> builder) {
                return builder.withPageSize(Integer.MAX_VALUE).withPageRowCountLimit(50000);
            }
        }
        ,
        PAGE_ROW_COUNT_100K{

            @Override
            public <T> ParquetWriter.Builder<T, ?> configureBuilder(ParquetWriter.Builder<T, ?> builder) {
                return builder.withPageSize(Integer.MAX_VALUE).withPageRowCountLimit(100000);
            }
        };

    }

    public static enum ColumnCharacteristic {
        SORTED{

            @Override
            void arrangeData(long[] data) {
                Arrays.parallelSort(data);
            }
        }
        ,
        CLUSTERED_9{

            @Override
            void arrangeData(long[] data) {
                2.arrangeToBuckets(data, 9);
            }
        }
        ,
        CLUSTERED_5{

            @Override
            void arrangeData(long[] data) {
                3.arrangeToBuckets(data, 5);
            }
        }
        ,
        CLUSTERED_3{

            @Override
            void arrangeData(long[] data) {
                4.arrangeToBuckets(data, 3);
            }
        }
        ,
        RANDOM{

            @Override
            void arrangeData(long[] data) {
            }
        };


        abstract void arrangeData(long[] var1);

        public static void arrangeToBuckets(long[] data, int bucketCnt) {
            int i;
            long bucketSize = (long)(9.223372036854776E18 / ((double)bucketCnt / 2.0));
            long[] bucketBorders = new long[bucketCnt - 1];
            int n = bucketBorders.length;
            for (int i2 = 0; i2 < n; ++i2) {
                bucketBorders[i2] = Long.MIN_VALUE + (long)(i2 + 1) * bucketSize;
            }
            LongList[] buckets = new LongList[bucketCnt];
            for (i = 0; i < bucketCnt; ++i) {
                buckets[i] = new LongArrayList(data.length / bucketCnt);
            }
            int n2 = data.length;
            for (i = 0; i < n2; ++i) {
                long value = data[i];
                int bucket = Arrays.binarySearch(bucketBorders, value);
                if (bucket < 0) {
                    bucket = -(bucket + 1);
                }
                buckets[bucket].add(value);
            }
            int offset = 0;
            int mid = bucketCnt / 2;
            for (int i3 = 0; i3 < bucketCnt; ++i3) {
                int bucketIndex = i3 % 2 == 0 ? mid + i3 / 2 : mid - i3 / 2 - 1;
                LongList bucket = buckets[bucketIndex];
                bucket.getElements(0, data, offset, bucket.size());
                offset += bucket.size();
            }
        }
    }

    public static enum ColumnIndexUsage implements ReadConfigurator
    {
        WITHOUT_COLUMN_INDEX{

            @Override
            public <T> ParquetReader.Builder<T> configureBuilder(ParquetReader.Builder<T> builder) {
                return builder.useColumnIndexFilter(false);
            }
        }
        ,
        WITH_COLUMN_INDEX{

            @Override
            public <T> ParquetReader.Builder<T> configureBuilder(ParquetReader.Builder<T> builder) {
                return builder.useColumnIndexFilter(true);
            }
        };

    }

    static interface WriteConfigurator {
        public static final WriteConfigurator DEFAULT = new WriteConfigurator(){

            @Override
            public <T> ParquetWriter.Builder<T, ?> configureBuilder(ParquetWriter.Builder<T, ?> builder) {
                return builder;
            }

            public String toString() {
                return "DEFAULT";
            }
        };

        public <T> ParquetWriter.Builder<T, ?> configureBuilder(ParquetWriter.Builder<T, ?> var1);
    }

    static interface ReadConfigurator {
        public static final ReadConfigurator DEFAULT = new ReadConfigurator(){

            @Override
            public <T> ParquetReader.Builder<T> configureBuilder(ParquetReader.Builder<T> builder) {
                return builder;
            }

            public String toString() {
                return "DEFAULT";
            }
        };

        public <T> ParquetReader.Builder<T> configureBuilder(ParquetReader.Builder<T> var1);
    }

    private static class StringGenerator {
        private static final int MAX_LENGTH = 100;
        private static final int MIN_LENGTH = 50;
        private static final String ALPHABET = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ ";
        private final Random random = new Random(44L);

        private StringGenerator() {
        }

        String nextString() {
            char[] str = new char[50 + this.random.nextInt(50)];
            int n = str.length;
            for (int i = 0; i < n; ++i) {
                str[i] = ALPHABET.charAt(this.random.nextInt(ALPHABET.length()));
            }
            return new String(str);
        }
    }

    private static class FileSize {
        private static final String[] SUFFIXES = new String[]{"KiB", "MiB", "GiB", "TiB", "PiB", "EiB"};
        private final Path file;

        FileSize(Path file) {
            this.file = file;
        }

        public String toString() {
            try {
                FileSystem fs = this.file.getFileSystem(new Configuration());
                long bytes = fs.getFileStatus(this.file).getLen();
                int exp = (int)(Math.log(bytes) / Math.log(1024.0));
                if (exp == 0) {
                    return Long.toString(bytes);
                }
                String suffix = SUFFIXES[exp - 1];
                return String.format("%d [%.2f%s]", bytes, (double)bytes / Math.pow(1024.0, exp), suffix);
            }
            catch (IOException e) {
                return "N/A";
            }
        }
    }
}

