/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.benchmarks;

import java.io.IOException;
import org.apache.parquet.benchmarks.BenchmarkFiles;
import org.apache.parquet.benchmarks.DataGenerator;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;

@State(value=Scope.Thread)
public class WriteBenchmarks {
    private DataGenerator dataGenerator = new DataGenerator();

    @Setup(value=Level.Iteration)
    public void setup() {
        this.dataGenerator.cleanup();
    }

    @Benchmark
    @BenchmarkMode(value={Mode.SingleShotTime})
    public void write1MRowsDefaultBlockAndPageSizeUncompressed() throws IOException {
        this.dataGenerator.generateData(BenchmarkFiles.file_1M, BenchmarkFiles.configuration, ParquetProperties.WriterVersion.PARQUET_2_0, 0x8000000, 0x100000, 1024, CompressionCodecName.UNCOMPRESSED, 1000000);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.SingleShotTime})
    public void write1MRowsBS256MPS4MUncompressed() throws IOException {
        this.dataGenerator.generateData(BenchmarkFiles.file_1M_BS256M_PS4M, BenchmarkFiles.configuration, ParquetProperties.WriterVersion.PARQUET_2_0, 0x10000000, 0x400000, 1024, CompressionCodecName.UNCOMPRESSED, 1000000);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.SingleShotTime})
    public void write1MRowsBS256MPS8MUncompressed() throws IOException {
        this.dataGenerator.generateData(BenchmarkFiles.file_1M_BS256M_PS8M, BenchmarkFiles.configuration, ParquetProperties.WriterVersion.PARQUET_2_0, 0x10000000, 0x800000, 1024, CompressionCodecName.UNCOMPRESSED, 1000000);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.SingleShotTime})
    public void write1MRowsBS512MPS4MUncompressed() throws IOException {
        this.dataGenerator.generateData(BenchmarkFiles.file_1M_BS512M_PS4M, BenchmarkFiles.configuration, ParquetProperties.WriterVersion.PARQUET_2_0, 0x20000000, 0x400000, 1024, CompressionCodecName.UNCOMPRESSED, 1000000);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.SingleShotTime})
    public void write1MRowsBS512MPS8MUncompressed() throws IOException {
        this.dataGenerator.generateData(BenchmarkFiles.file_1M_BS512M_PS8M, BenchmarkFiles.configuration, ParquetProperties.WriterVersion.PARQUET_2_0, 0x20000000, 0x800000, 1024, CompressionCodecName.UNCOMPRESSED, 1000000);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.SingleShotTime})
    public void write1MRowsDefaultBlockAndPageSizeSNAPPY() throws IOException {
        this.dataGenerator.generateData(BenchmarkFiles.file_1M_SNAPPY, BenchmarkFiles.configuration, ParquetProperties.WriterVersion.PARQUET_2_0, 0x8000000, 0x100000, 1024, CompressionCodecName.SNAPPY, 1000000);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.SingleShotTime})
    public void write1MRowsDefaultBlockAndPageSizeGZIP() throws IOException {
        this.dataGenerator.generateData(BenchmarkFiles.file_1M_GZIP, BenchmarkFiles.configuration, ParquetProperties.WriterVersion.PARQUET_2_0, 0x8000000, 0x100000, 1024, CompressionCodecName.GZIP, 1000000);
    }
}

