/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.service.server;

import java.util.concurrent.CompletableFuture;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.serializer.InternalRowSerializer;
import org.apache.paimon.service.exceptions.UnknownPartitionBucketException;
import org.apache.paimon.service.messages.KvRequest;
import org.apache.paimon.service.messages.KvResponse;
import org.apache.paimon.service.network.AbstractServerHandler;
import org.apache.paimon.service.network.NetworkServer;
import org.apache.paimon.service.network.messages.MessageSerializer;
import org.apache.paimon.service.network.stats.ServiceRequestStats;
import org.apache.paimon.service.server.KvQueryServer;
import org.apache.paimon.shade.netty4.io.netty.channel.ChannelHandler;
import org.apache.paimon.table.query.TableQuery;
import org.apache.paimon.table.sink.ChannelComputer;
import org.apache.paimon.utils.ExceptionUtils;
import org.apache.paimon.utils.Preconditions;

@ChannelHandler.Sharable
public class KvServerHandler
extends AbstractServerHandler<KvRequest, KvResponse> {
    private final int serverId;
    private final int numServers;
    private final TableQuery lookup;
    private final InternalRowSerializer valueSerializer;

    public KvServerHandler(KvQueryServer server, int serverId, int numServers, TableQuery lookup, MessageSerializer<KvRequest, KvResponse> serializer, ServiceRequestStats stats) {
        super((NetworkServer)server, serializer, stats);
        this.serverId = serverId;
        this.numServers = numServers;
        this.lookup = (TableQuery)Preconditions.checkNotNull((Object)lookup);
        this.valueSerializer = lookup.createValueSerializer();
    }

    public CompletableFuture<KvResponse> handleRequest(long requestId, KvRequest request) {
        CompletableFuture<KvResponse> responseFuture = new CompletableFuture<KvResponse>();
        int selectServerId = ChannelComputer.select((BinaryRow)request.partition(), (int)request.bucket(), (int)this.numServers);
        if (selectServerId != this.serverId) {
            responseFuture.completeExceptionally((Throwable)new UnknownPartitionBucketException(this.getServerName()));
            return responseFuture;
        }
        try {
            BinaryRow[] keys = request.keys();
            BinaryRow[] values = new BinaryRow[keys.length];
            for (int i = 0; i < values.length; ++i) {
                InternalRow value = this.lookup.lookup(request.partition(), request.bucket(), (InternalRow)keys[i]);
                if (value == null) continue;
                values[i] = this.valueSerializer.toBinaryRow(value).copy();
            }
            responseFuture.complete(new KvResponse(values));
            return responseFuture;
        }
        catch (Throwable t) {
            String errMsg = "Error while processing request with ID " + requestId + ". Caused by: " + ExceptionUtils.stringifyException((Throwable)t);
            responseFuture.completeExceptionally(new RuntimeException(errMsg));
            return responseFuture;
        }
    }

    public CompletableFuture<Void> shutdown() {
        return CompletableFuture.completedFuture(null);
    }
}

