/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.fileindex.rangebitmap.dictionary.chunked;

import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.function.Function;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.Decimal;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.fileindex.rangebitmap.dictionary.chunked.Chunk;
import org.apache.paimon.fileindex.rangebitmap.dictionary.chunked.FixedLengthChunk;
import org.apache.paimon.fileindex.rangebitmap.dictionary.chunked.VariableLengthChunk;
import org.apache.paimon.fs.SeekableInputStream;
import org.apache.paimon.types.BigIntType;
import org.apache.paimon.types.BooleanType;
import org.apache.paimon.types.CharType;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeDefaultVisitor;
import org.apache.paimon.types.DataTypeVisitor;
import org.apache.paimon.types.DateType;
import org.apache.paimon.types.DecimalType;
import org.apache.paimon.types.DoubleType;
import org.apache.paimon.types.FloatType;
import org.apache.paimon.types.IntType;
import org.apache.paimon.types.LocalZonedTimestampType;
import org.apache.paimon.types.SmallIntType;
import org.apache.paimon.types.TimeType;
import org.apache.paimon.types.TimestampType;
import org.apache.paimon.types.TinyIntType;
import org.apache.paimon.types.VarCharType;
import org.apache.paimon.utils.Preconditions;

public interface KeyFactory {
    public static KeyFactory create(DataType type) {
        return (KeyFactory)type.accept((DataTypeVisitor)new DataTypeDefaultVisitor<KeyFactory>(){

            public KeyFactory visit(CharType charType) {
                return new StringKeyFactory();
            }

            public KeyFactory visit(VarCharType varCharType) {
                return new StringKeyFactory();
            }

            public KeyFactory visit(BooleanType booleanType) {
                return new BooleanKeyFactory();
            }

            public KeyFactory visit(DecimalType decimalType) {
                return new DecimalKeyFactory(decimalType.getPrecision());
            }

            public KeyFactory visit(TinyIntType tinyIntType) {
                return new TinyIntKeyFactory();
            }

            public KeyFactory visit(SmallIntType smallIntType) {
                return new SmallIntKeyFactory();
            }

            public KeyFactory visit(IntType intType) {
                return new IntKeyFactory();
            }

            public KeyFactory visit(BigIntType bigIntType) {
                return new BigIntKeyFactory();
            }

            public KeyFactory visit(FloatType floatType) {
                return new FloatKeyFactory();
            }

            public KeyFactory visit(DoubleType doubleType) {
                return new DoubleKeyFactory();
            }

            public KeyFactory visit(DateType dateType) {
                return new IntKeyFactory();
            }

            public KeyFactory visit(TimeType timeType) {
                return new IntKeyFactory();
            }

            public KeyFactory visit(TimestampType timestampType) {
                return new TimestampKeyFactory(timestampType.getPrecision());
            }

            public KeyFactory visit(LocalZonedTimestampType localZonedTimestampType) {
                return new TimestampKeyFactory(localZonedTimestampType.getPrecision());
            }

            protected KeyFactory defaultMethod(DataType dataType) {
                throw new UnsupportedOperationException("data type " + dataType + "is not supported.");
            }
        });
    }

    default public Function<Object, Object> createConverter() {
        return Function.identity();
    }

    default public String defaultChunkSize() {
        return "16kb";
    }

    public Comparator<Object> createComparator();

    public KeySerializer createSerializer();

    public KeyDeserializer createDeserializer();

    public Chunk createChunk(Object var1, int var2, int var3, int var4);

    public Chunk mmapChunk(ByteBuffer var1, int var2, SeekableInputStream var3);

    public static class StringKeyFactory
    extends VariableLengthKeyFactory {
        @Override
        public Function<Object, Object> createConverter() {
            return o -> o == null ? null : ((BinaryString)o).copy();
        }

        @Override
        public Comparator<Object> createComparator() {
            return Comparator.comparing(o -> (BinaryString)o);
        }

        @Override
        public KeySerializer createSerializer() {
            return new KeySerializer(){

                @Override
                public void serialize(ByteBuffer buffer, Object input) {
                    byte[] bytes = ((BinaryString)input).toBytes();
                    buffer.putInt(bytes.length);
                    buffer.put(bytes);
                }

                @Override
                public int serializedSizeInBytes(Object input) {
                    return 4 + ((BinaryString)input).getSizeInBytes();
                }
            };
        }

        @Override
        public KeyDeserializer createDeserializer() {
            return new KeyDeserializer(){

                @Override
                public Object deserialize(ByteBuffer buffer) {
                    int length = buffer.getInt();
                    byte[] bytes = new byte[length];
                    buffer.get(bytes);
                    return BinaryString.fromBytes(bytes);
                }
            };
        }
    }

    public static class TimestampKeyFactory
    extends BigIntKeyFactory {
        private final int precision;

        public TimestampKeyFactory(int precision) {
            Preconditions.checkArgument((precision <= 6 ? 1 : 0) != 0, (Object)String.format("The %s index only supports TIMESTAMP with a precision in [0, 6].", "range-bitmap"));
            this.precision = precision;
        }

        @Override
        public Function<Object, Object> createConverter() {
            return o -> {
                if (o == null) {
                    return null;
                }
                if (this.precision <= 3) {
                    return ((Timestamp)o).getMillisecond();
                }
                return ((Timestamp)o).toMicros();
            };
        }
    }

    public static class DecimalKeyFactory
    extends BigIntKeyFactory {
        public DecimalKeyFactory(int precision) {
            Preconditions.checkArgument((precision <= 18 ? 1 : 0) != 0, (Object)String.format("The %s index only supports DECIMAL with a precision in [0, 18].", "range-bitmap"));
        }

        @Override
        public Function<Object, Object> createConverter() {
            return o -> o == null ? null : Long.valueOf(((Decimal)o).toUnscaledLong());
        }
    }

    public static class DoubleKeyFactory
    extends FixedLengthKeyFactory {
        @Override
        public Comparator<Object> createComparator() {
            return Comparator.comparing(o -> (Double)o);
        }

        @Override
        public KeySerializer createSerializer() {
            return new KeySerializer(){

                @Override
                public void serialize(ByteBuffer buffer, Object key) {
                    buffer.putDouble((Double)key);
                }

                @Override
                public int serializedSizeInBytes(Object key) {
                    return 8;
                }
            };
        }

        @Override
        public KeyDeserializer createDeserializer() {
            return new KeyDeserializer(){

                @Override
                public Object deserialize(ByteBuffer buffer) {
                    return buffer.getDouble();
                }
            };
        }
    }

    public static class FloatKeyFactory
    extends FixedLengthKeyFactory {
        @Override
        public Comparator<Object> createComparator() {
            return Comparator.comparing(o -> (Float)o);
        }

        @Override
        public KeySerializer createSerializer() {
            return new KeySerializer(){

                @Override
                public void serialize(ByteBuffer buffer, Object key) {
                    buffer.putFloat(((Float)key).floatValue());
                }

                @Override
                public int serializedSizeInBytes(Object key) {
                    return 4;
                }
            };
        }

        @Override
        public KeyDeserializer createDeserializer() {
            return new KeyDeserializer(){

                @Override
                public Object deserialize(ByteBuffer buffer) {
                    return Float.valueOf(buffer.getFloat());
                }
            };
        }
    }

    public static class SmallIntKeyFactory
    extends FixedLengthKeyFactory {
        @Override
        public Comparator<Object> createComparator() {
            return Comparator.comparing(o -> (Short)o);
        }

        @Override
        public KeySerializer createSerializer() {
            return new KeySerializer(){

                @Override
                public void serialize(ByteBuffer buffer, Object key) {
                    buffer.putShort((Short)key);
                }

                @Override
                public int serializedSizeInBytes(Object key) {
                    return 2;
                }
            };
        }

        @Override
        public KeyDeserializer createDeserializer() {
            return new KeyDeserializer(){

                @Override
                public Object deserialize(ByteBuffer buffer) {
                    return buffer.getShort();
                }
            };
        }

        @Override
        public String defaultChunkSize() {
            return "0b";
        }
    }

    public static class TinyIntKeyFactory
    extends FixedLengthKeyFactory {
        @Override
        public Comparator<Object> createComparator() {
            return Comparator.comparing(o -> (Byte)o);
        }

        @Override
        public KeySerializer createSerializer() {
            return new KeySerializer(){

                @Override
                public void serialize(ByteBuffer buffer, Object key) {
                    buffer.put((Byte)key);
                }

                @Override
                public int serializedSizeInBytes(Object key) {
                    return 1;
                }
            };
        }

        @Override
        public KeyDeserializer createDeserializer() {
            return new KeyDeserializer(){

                @Override
                public Object deserialize(ByteBuffer buffer) {
                    return buffer.get();
                }
            };
        }

        @Override
        public String defaultChunkSize() {
            return "0b";
        }
    }

    public static class BooleanKeyFactory
    extends FixedLengthKeyFactory {
        @Override
        public Comparator<Object> createComparator() {
            return Comparator.comparing(o -> (Boolean)o);
        }

        @Override
        public KeySerializer createSerializer() {
            return new KeySerializer(){

                @Override
                public void serialize(ByteBuffer buffer, Object input) {
                    buffer.put(Boolean.TRUE.equals(input) ? (byte)1 : 0);
                }

                @Override
                public int serializedSizeInBytes(Object input) {
                    return 1;
                }
            };
        }

        @Override
        public KeyDeserializer createDeserializer() {
            return new KeyDeserializer(){

                @Override
                public Object deserialize(ByteBuffer buffer) {
                    return buffer.get() == 1;
                }
            };
        }

        @Override
        public String defaultChunkSize() {
            return "0b";
        }
    }

    public static class BigIntKeyFactory
    extends FixedLengthKeyFactory {
        @Override
        public Comparator<Object> createComparator() {
            return Comparator.comparing(o -> (Long)o);
        }

        @Override
        public KeySerializer createSerializer() {
            return new KeySerializer(){

                @Override
                public void serialize(ByteBuffer buffer, Object input) {
                    buffer.putLong((Long)input);
                }

                @Override
                public int serializedSizeInBytes(Object input) {
                    return 8;
                }
            };
        }

        @Override
        public KeyDeserializer createDeserializer() {
            return new KeyDeserializer(){

                @Override
                public Object deserialize(ByteBuffer buffer) {
                    return buffer.getLong();
                }
            };
        }
    }

    public static class IntKeyFactory
    extends FixedLengthKeyFactory {
        @Override
        public Comparator<Object> createComparator() {
            return Comparator.comparing(o -> (Integer)o);
        }

        @Override
        public KeySerializer createSerializer() {
            return new KeySerializer(){

                @Override
                public void serialize(ByteBuffer buffer, Object input) {
                    buffer.putInt((Integer)input);
                }

                @Override
                public int serializedSizeInBytes(Object input) {
                    return 4;
                }
            };
        }

        @Override
        public KeyDeserializer createDeserializer() {
            return new KeyDeserializer(){

                @Override
                public Object deserialize(ByteBuffer buffer) {
                    return buffer.getInt();
                }
            };
        }
    }

    public static abstract class VariableLengthKeyFactory
    implements KeyFactory {
        @Override
        public Chunk createChunk(Object key, int code, int offset, int limitedSerializedSizeInBytes) {
            return new VariableLengthChunk(key, code, offset, limitedSerializedSizeInBytes, this.createSerializer(), this.createComparator());
        }

        @Override
        public Chunk mmapChunk(ByteBuffer buffer, int offset, SeekableInputStream in) {
            return new VariableLengthChunk(buffer, offset, in, this.createDeserializer(), this.createComparator());
        }
    }

    public static abstract class FixedLengthKeyFactory
    implements KeyFactory {
        @Override
        public Chunk createChunk(Object key, int code, int offset, int limitedSerializedSizeInBytes) {
            return new FixedLengthChunk(key, code, offset, limitedSerializedSizeInBytes, this.createSerializer(), this.createComparator());
        }

        @Override
        public Chunk mmapChunk(ByteBuffer buffer, int offset, SeekableInputStream in) {
            return new FixedLengthChunk(buffer, offset, in, this.createDeserializer(), this.createComparator());
        }
    }

    public static interface KeyDeserializer {
        public Object deserialize(ByteBuffer var1);
    }

    public static interface KeySerializer {
        public void serialize(ByteBuffer var1, Object var2);

        public int serializedSizeInBytes(Object var1);
    }
}

