/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import org.apache.paimon.casting.CastExecutor;
import org.apache.paimon.casting.CastExecutors;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.types.VarCharType;
import org.apache.paimon.utils.InternalRowUtils;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.StringUtils;
import org.apache.paimon.utils.TypeUtils;

public class InternalRowPartitionComputer {
    protected final String defaultPartValue;
    protected final String[] partitionColumns;
    protected final InternalRow.FieldGetter[] partitionFieldGetters;
    protected final CastExecutor[] partitionCastExecutors;
    protected final List<DataType> types;
    protected final boolean legacyPartitionName;

    public InternalRowPartitionComputer(String defaultPartValue, RowType rowType, String[] partitionColumns, boolean legacyPartitionName) {
        this.defaultPartValue = defaultPartValue;
        this.partitionColumns = partitionColumns;
        this.types = rowType.getFieldTypes();
        this.legacyPartitionName = legacyPartitionName;
        List<String> columnList = rowType.getFieldNames();
        this.partitionFieldGetters = new InternalRow.FieldGetter[partitionColumns.length];
        this.partitionCastExecutors = new CastExecutor[partitionColumns.length];
        for (String partitionColumn : partitionColumns) {
            int i = columnList.indexOf(partitionColumn);
            DataType type = rowType.getTypeAt(i);
            this.partitionFieldGetters[i] = InternalRowUtils.createNullCheckingFieldGetter(type, i);
            this.partitionCastExecutors[i] = CastExecutors.resolve(type, VarCharType.STRING_TYPE);
        }
    }

    public LinkedHashMap<String, String> generatePartValues(InternalRow in) {
        LinkedHashMap<String, String> partSpec = new LinkedHashMap<String, String>();
        for (int i = 0; i < this.partitionFieldGetters.length; ++i) {
            Object field = this.partitionFieldGetters[i].getFieldOrNull(in);
            String partitionValue = null;
            if (field != null) {
                if (this.legacyPartitionName) {
                    partitionValue = field.toString();
                } else {
                    Object casted = this.partitionCastExecutors[i].cast(field);
                    if (casted != null) {
                        partitionValue = casted.toString();
                    }
                }
            }
            if (StringUtils.isNullOrWhitespaceOnly(partitionValue)) {
                partitionValue = this.defaultPartValue;
            }
            partSpec.put(this.partitionColumns[i], partitionValue);
        }
        return partSpec;
    }

    public static Map<String, Object> convertSpecToInternal(Map<String, String> spec, RowType partType, String defaultPartValue) {
        LinkedHashMap<String, Object> partValues = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, String> entry : spec.entrySet()) {
            partValues.put(entry.getKey(), defaultPartValue.equals(entry.getValue()) ? null : TypeUtils.castFromString(entry.getValue(), partType.getField(entry.getKey()).type()));
        }
        return partValues;
    }

    public static GenericRow convertSpecToInternalRow(Map<String, String> spec, RowType partType, String defaultPartValue) {
        Preconditions.checkArgument(spec.size() == partType.getFieldCount(), "Partition spec %s size not match partition type %s", spec, partType);
        GenericRow partRow = new GenericRow(spec.size());
        List<String> fieldNames = partType.getFieldNames();
        for (Map.Entry<String, String> entry : spec.entrySet()) {
            Object value = defaultPartValue != null && defaultPartValue.equals(entry.getValue()) ? null : TypeUtils.castFromString(entry.getValue(), partType.getField(entry.getKey()).type());
            partRow.setField(fieldNames.indexOf(entry.getKey()), value);
        }
        return partRow;
    }

    public static String partToSimpleString(RowType partitionType, BinaryRow partition, String delimiter, int maxLength) {
        InternalRow.FieldGetter[] getters = (InternalRow.FieldGetter[])IntStream.range(0, partitionType.getFieldCount()).mapToObj(i -> InternalRow.createFieldGetter(partitionType.getTypeAt(i), i)).toArray(InternalRow.FieldGetter[]::new);
        StringBuilder builder = new StringBuilder();
        for (int i2 = 0; i2 < getters.length; ++i2) {
            Object part = getters[i2].getFieldOrNull(partition);
            if (part != null) {
                builder.append(part);
            } else {
                builder.append("null");
            }
            if (i2 == getters.length - 1) continue;
            builder.append(delimiter);
        }
        String result = builder.toString();
        return result.substring(0, Math.min(result.length(), maxLength));
    }
}

