/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.types;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.paimon.annotation.Public;
import org.apache.paimon.schema.Schema;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.paimon.table.SpecialFields;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeRoot;
import org.apache.paimon.types.DataTypeVisitor;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.StringUtils;

@Public
public final class RowType
extends DataType {
    private static final long serialVersionUID = 1L;
    private static final String FIELD_FIELDS = "fields";
    public static final String FORMAT = "ROW<%s>";
    private final List<DataField> fields;
    private volatile transient Map<String, DataField> laziedNameToField;
    private volatile transient Map<String, Integer> laziedNameToIndex;
    private volatile transient Map<Integer, DataField> laziedFieldIdToField;
    private volatile transient Map<Integer, Integer> laziedFieldIdToIndex;

    public RowType(boolean isNullable, List<DataField> fields) {
        super(isNullable, DataTypeRoot.ROW);
        this.fields = Collections.unmodifiableList(new ArrayList(Preconditions.checkNotNull(fields, "Fields must not be null.")));
        RowType.validateFields(fields);
    }

    @JsonCreator
    public RowType(@JsonProperty(value="fields") List<DataField> fields) {
        this(true, fields);
    }

    public RowType copy(List<DataField> newFields) {
        return new RowType(this.isNullable(), newFields);
    }

    public List<DataField> getFields() {
        return this.fields;
    }

    public List<String> getFieldNames() {
        return this.fields.stream().map(DataField::name).collect(Collectors.toList());
    }

    public List<DataType> getFieldTypes() {
        return this.fields.stream().map(DataField::type).collect(Collectors.toList());
    }

    public DataType getTypeAt(int i) {
        return this.fields.get(i).type();
    }

    public int getFieldCount() {
        return this.fields.size();
    }

    public int getFieldIndex(String fieldName) {
        return this.nameToIndex().getOrDefault(fieldName, -1);
    }

    public int[] getFieldIndices(List<String> projectFields) {
        int[] projection = new int[projectFields.size()];
        for (int i = 0; i < projection.length; ++i) {
            projection[i] = this.getFieldIndex(projectFields.get(i));
        }
        return projection;
    }

    public boolean containsField(String fieldName) {
        return this.nameToField().containsKey(fieldName);
    }

    public boolean containsField(int fieldId) {
        return this.fieldIdToField().containsKey(fieldId);
    }

    public boolean notContainsField(String fieldName) {
        return !this.containsField(fieldName);
    }

    public DataField getField(String fieldName) {
        DataField field = this.nameToField().get(fieldName);
        if (field == null) {
            throw new RuntimeException("Cannot find field: " + fieldName);
        }
        return field;
    }

    public DataField getField(int fieldId) {
        DataField field = this.fieldIdToField().get(fieldId);
        if (field == null) {
            throw new RuntimeException("Cannot find field by field id: " + fieldId);
        }
        return field;
    }

    public int getFieldIndexByFieldId(int fieldId) {
        Integer index = this.fieldIdToIndex().get(fieldId);
        if (index == null) {
            throw new RuntimeException("Cannot find field index by FieldId " + fieldId);
        }
        return index;
    }

    @Override
    public int defaultSize() {
        return this.fields.stream().mapToInt(f -> f.type().defaultSize()).sum();
    }

    @Override
    public RowType copy(boolean isNullable) {
        return new RowType(isNullable, this.fields.stream().map(DataField::copy).collect(Collectors.toList()));
    }

    @Override
    public RowType notNull() {
        return this.copy(false);
    }

    @Override
    public String asSQLString() {
        return this.withNullability(FORMAT, this.fields.stream().map(DataField::asSQLString).collect(Collectors.joining(", ")));
    }

    @Override
    public void serializeJson(JsonGenerator generator) throws IOException {
        generator.writeStartObject();
        generator.writeStringField("type", this.isNullable() ? "ROW" : "ROW NOT NULL");
        generator.writeArrayFieldStart(FIELD_FIELDS);
        for (DataField field : this.getFields()) {
            field.serializeJson(generator);
        }
        generator.writeEndArray();
        generator.writeEndObject();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RowType rowType = (RowType)o;
        return this.fields.equals(rowType.fields);
    }

    @Override
    public boolean equalsIgnoreFieldId(DataType o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RowType other = (RowType)o;
        if (this.fields.size() != other.fields.size()) {
            return false;
        }
        for (int i = 0; i < this.fields.size(); ++i) {
            if (this.fields.get(i).equalsIgnoreFieldId(other.fields.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isPrunedFrom(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RowType rowType = (RowType)o;
        for (DataField field : this.fields) {
            if (field.isPrunedFrom(rowType.getField(field.id()))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.fields);
    }

    private static void validateFields(List<DataField> fields) {
        List<String> fieldNames = fields.stream().map(DataField::name).collect(Collectors.toList());
        if (fieldNames.stream().anyMatch(StringUtils::isNullOrWhitespaceOnly)) {
            throw new IllegalArgumentException("Field names must contain at least one non-whitespace character.");
        }
        Set<String> duplicates = Schema.duplicateFields(fieldNames);
        if (!duplicates.isEmpty()) {
            throw new IllegalArgumentException(String.format("Field names must be unique. Found duplicates: %s", duplicates));
        }
    }

    @Override
    public <R> R accept(DataTypeVisitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    public void collectFieldIds(Set<Integer> fieldIds) {
        for (DataField field : this.fields) {
            if (fieldIds.contains(field.id())) {
                throw new RuntimeException(String.format("Broken schema, field id %s is duplicated.", field.id()));
            }
            fieldIds.add(field.id());
            field.type().collectFieldIds(fieldIds);
        }
    }

    public RowType appendDataField(String name, DataType type) {
        ArrayList<DataField> newFields = new ArrayList<DataField>(this.fields);
        int newId = RowType.currentHighestFieldId(this.fields) + 1;
        newFields.add(new DataField(newId, name, type));
        return new RowType(newFields);
    }

    public RowType project(int[] mapping) {
        List<DataField> fields = this.getFields();
        return new RowType(Arrays.stream(mapping).mapToObj(fields::get).collect(Collectors.toList())).copy(this.isNullable());
    }

    public RowType project(List<String> names) {
        List<DataField> fields = this.getFields();
        List fieldNames = fields.stream().map(DataField::name).collect(Collectors.toList());
        return new RowType(names.stream().map(k -> (DataField)fields.get(fieldNames.indexOf(k))).collect(Collectors.toList())).copy(this.isNullable());
    }

    public int[] projectIndexes(List<String> names) {
        List fieldNames = this.fields.stream().map(DataField::name).collect(Collectors.toList());
        return names.stream().mapToInt(fieldNames::indexOf).toArray();
    }

    public RowType project(String ... names) {
        return this.project(Arrays.asList(names));
    }

    private Map<String, DataField> nameToField() {
        Map<String, DataField> nameToField = this.laziedNameToField;
        if (nameToField == null) {
            nameToField = new HashMap<String, DataField>();
            for (DataField field : this.fields) {
                nameToField.put(field.name(), field);
            }
            this.laziedNameToField = nameToField;
        }
        return nameToField;
    }

    private Map<String, Integer> nameToIndex() {
        Map<String, Integer> nameToIndex = this.laziedNameToIndex;
        if (nameToIndex == null) {
            nameToIndex = new HashMap<String, Integer>();
            for (int i = 0; i < this.fields.size(); ++i) {
                nameToIndex.put(this.fields.get(i).name(), i);
            }
            this.laziedNameToIndex = nameToIndex;
        }
        return nameToIndex;
    }

    private Map<Integer, DataField> fieldIdToField() {
        Map<Integer, DataField> fieldIdToField = this.laziedFieldIdToField;
        if (fieldIdToField == null) {
            fieldIdToField = new HashMap<Integer, DataField>();
            for (DataField field : this.fields) {
                fieldIdToField.put(field.id(), field);
            }
            this.laziedFieldIdToField = fieldIdToField;
        }
        return fieldIdToField;
    }

    private Map<Integer, Integer> fieldIdToIndex() {
        Map<Integer, Integer> fieldIdToIndex = this.laziedFieldIdToIndex;
        if (fieldIdToIndex == null) {
            fieldIdToIndex = new HashMap<Integer, Integer>();
            for (int i = 0; i < this.fields.size(); ++i) {
                fieldIdToIndex.put(this.fields.get(i).id(), i);
            }
            this.laziedFieldIdToIndex = fieldIdToIndex;
        }
        return fieldIdToIndex;
    }

    public static RowType of() {
        return new RowType(true, Collections.emptyList());
    }

    public static RowType of(DataField ... fields) {
        ArrayList<DataField> fs = new ArrayList<DataField>(Arrays.asList(fields));
        return new RowType(true, fs);
    }

    public static RowType of(DataType ... types) {
        ArrayList<DataField> fields = new ArrayList<DataField>();
        for (int i = 0; i < types.length; ++i) {
            fields.add(new DataField(i, "f" + i, types[i]));
        }
        return new RowType(true, fields);
    }

    public static RowType of(DataType[] types, String[] names) {
        ArrayList<DataField> fields = new ArrayList<DataField>();
        for (int i = 0; i < types.length; ++i) {
            fields.add(new DataField(i, names[i], types[i]));
        }
        return new RowType(true, fields);
    }

    public static int currentHighestFieldId(List<DataField> fields) {
        HashSet<Integer> fieldIds = new HashSet<Integer>();
        new RowType(fields).collectFieldIds(fieldIds);
        return fieldIds.stream().filter(i -> !SpecialFields.isSystemField(i)).max(Integer::compareTo).orElse(-1);
    }

    public static Builder builder() {
        return RowType.builder(new AtomicInteger(-1));
    }

    public static Builder builder(AtomicInteger fieldId) {
        return RowType.builder(true, fieldId);
    }

    public static Builder builder(boolean isNullable, AtomicInteger fieldId) {
        return new Builder(isNullable, fieldId);
    }

    public static class Builder {
        private final List<DataField> fields = new ArrayList<DataField>();
        private final boolean isNullable;
        private final AtomicInteger fieldId;

        private Builder(boolean isNullable, AtomicInteger fieldId) {
            this.isNullable = isNullable;
            this.fieldId = fieldId;
        }

        public Builder field(String name, DataType type) {
            this.fields.add(new DataField(this.fieldId.incrementAndGet(), name, type));
            return this;
        }

        public Builder field(String name, DataType type, @Nullable String description) {
            this.fields.add(new DataField(this.fieldId.incrementAndGet(), name, type, description));
            return this;
        }

        public Builder field(String name, DataType type, @Nullable String description, @Nullable String defaultValue) {
            this.fields.add(new DataField(this.fieldId.incrementAndGet(), name, type, description, defaultValue));
            return this;
        }

        public Builder fields(List<DataType> types) {
            for (int i = 0; i < types.size(); ++i) {
                this.field("f" + i, types.get(i));
            }
            return this;
        }

        public Builder fields(DataType ... types) {
            for (int i = 0; i < types.length; ++i) {
                this.field("f" + i, types[i]);
            }
            return this;
        }

        public Builder fields(DataType[] types, String[] names) {
            for (int i = 0; i < types.length; ++i) {
                this.field(names[i], types[i]);
            }
            return this;
        }

        public RowType build() {
            return new RowType(this.isNullable, this.fields);
        }
    }
}

