/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.lance;

import java.util.Map;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.table.Table;
import org.apache.paimon.table.lance.LanceTableImpl;
import org.apache.paimon.types.RowType;

public interface LanceTable
extends Table {
    public String location();

    @Override
    public LanceTable copy(Map<String, String> var1);

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Identifier identifier;
        private FileIO fileIO;
        private RowType rowType;
        private String location;
        private Map<String, String> options;
        private String comment;

        public Builder identifier(Identifier identifier) {
            this.identifier = identifier;
            return this;
        }

        public Builder fileIO(FileIO fileIO) {
            this.fileIO = fileIO;
            return this;
        }

        public Builder rowType(RowType rowType) {
            this.rowType = rowType;
            return this;
        }

        public Builder location(String location) {
            this.location = location;
            return this;
        }

        public Builder options(Map<String, String> options) {
            this.options = options;
            return this;
        }

        public Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public LanceTable build() {
            return new LanceTableImpl(this.identifier, this.fileIO, this.rowType, this.location, this.options, this.comment);
        }
    }
}

