/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.KeyValue;
import org.apache.paimon.mergetree.compact.DeduplicateMergeFunction;
import org.apache.paimon.mergetree.compact.FirstRowMergeFunction;
import org.apache.paimon.mergetree.compact.MergeFunctionFactory;
import org.apache.paimon.mergetree.compact.PartialUpdateMergeFunction;
import org.apache.paimon.mergetree.compact.aggregate.AggregateMergeFunction;
import org.apache.paimon.options.Options;
import org.apache.paimon.schema.KeyValueFieldsExtractor;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.table.Table;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.RowType;

public class PrimaryKeyTableUtils {
    public static RowType addKeyNamePrefix(RowType type) {
        return new RowType(PrimaryKeyTableUtils.addKeyNamePrefix(type.getFields()));
    }

    public static List<DataField> addKeyNamePrefix(List<DataField> keyFields) {
        return keyFields.stream().map(f -> f.newName("_KEY_" + f.name()).newId(f.id() + 0x3FFFFFFF)).collect(Collectors.toList());
    }

    public static MergeFunctionFactory<KeyValue> createMergeFunctionFactory(TableSchema tableSchema, KeyValueFieldsExtractor extractor) {
        RowType rowType = tableSchema.logicalRowType();
        Options conf = Options.fromMap(tableSchema.options());
        CoreOptions options = new CoreOptions(conf);
        CoreOptions.MergeEngine mergeEngine = options.mergeEngine();
        switch (mergeEngine) {
            case DEDUPLICATE: {
                return DeduplicateMergeFunction.factory(conf);
            }
            case PARTIAL_UPDATE: {
                return PartialUpdateMergeFunction.factory(conf, rowType, tableSchema.primaryKeys());
            }
            case AGGREGATE: {
                return AggregateMergeFunction.factory(conf, tableSchema.fieldNames(), rowType.getFieldTypes(), tableSchema.primaryKeys());
            }
            case FIRST_ROW: {
                return FirstRowMergeFunction.factory(conf);
            }
        }
        throw new UnsupportedOperationException("Unsupported merge engine: " + mergeEngine);
    }

    public static void validatePKUpsertDeletable(Table table) {
        if (table.primaryKeys().isEmpty()) {
            throw new UnsupportedOperationException(String.format("table '%s' can not support delete, because there is no primary key.", table.getClass().getName()));
        }
        Options options = Options.fromMap(table.options());
        CoreOptions.MergeEngine mergeEngine = options.get(CoreOptions.MERGE_ENGINE);
        switch (mergeEngine) {
            case DEDUPLICATE: {
                return;
            }
            case PARTIAL_UPDATE: {
                if (options.get(CoreOptions.PARTIAL_UPDATE_REMOVE_RECORD_ON_DELETE).booleanValue() || options.get(CoreOptions.PARTIAL_UPDATE_REMOVE_RECORD_ON_SEQUENCE_GROUP) != null) {
                    return;
                }
                throw new UnsupportedOperationException(String.format("Merge engine %s doesn't support batch delete by default. To support batch delete, please set %s to true when there is no %s or set %s.", mergeEngine, CoreOptions.PARTIAL_UPDATE_REMOVE_RECORD_ON_DELETE.key(), "sequence-group", CoreOptions.PARTIAL_UPDATE_REMOVE_RECORD_ON_SEQUENCE_GROUP));
            }
            case AGGREGATE: {
                if (options.get(CoreOptions.AGGREGATION_REMOVE_RECORD_ON_DELETE).booleanValue()) {
                    return;
                }
                throw new UnsupportedOperationException(String.format("Merge engine %s doesn't support batch delete by default. To support batch delete, please set %s to true.", mergeEngine, CoreOptions.AGGREGATION_REMOVE_RECORD_ON_DELETE.key()));
            }
        }
        throw new UnsupportedOperationException(String.format("Merge engine %s can not support batch delete.", mergeEngine));
    }

    public static class PrimaryKeyFieldsExtractor
    implements KeyValueFieldsExtractor {
        private static final long serialVersionUID = 1L;
        public static final PrimaryKeyFieldsExtractor EXTRACTOR = new PrimaryKeyFieldsExtractor();

        private PrimaryKeyFieldsExtractor() {
        }

        @Override
        public List<DataField> keyFields(TableSchema schema) {
            return PrimaryKeyTableUtils.addKeyNamePrefix(schema.trimmedPrimaryKeysFields());
        }

        @Override
        public List<DataField> valueFields(TableSchema schema) {
            return schema.fields();
        }
    }
}

