/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.Snapshot;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.disk.IOManager;
import org.apache.paimon.fs.Path;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.io.DataInputView;
import org.apache.paimon.io.DataInputViewStreamWrapper;
import org.apache.paimon.io.DataOutputView;
import org.apache.paimon.io.DataOutputViewStreamWrapper;
import org.apache.paimon.manifest.PartitionEntry;
import org.apache.paimon.metrics.MetricRegistry;
import org.apache.paimon.options.Options;
import org.apache.paimon.partition.PartitionPredicate;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.predicate.TopN;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.table.DelegatedFileStoreTable;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.FileStoreTableFactory;
import org.apache.paimon.table.source.DataFilePlan;
import org.apache.paimon.table.source.DataSplit;
import org.apache.paimon.table.source.DataTableScan;
import org.apache.paimon.table.source.InnerTableRead;
import org.apache.paimon.table.source.InnerTableScan;
import org.apache.paimon.table.source.Split;
import org.apache.paimon.table.source.TableRead;
import org.apache.paimon.table.source.TableScan;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.Filter;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.SegmentsCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FallbackReadFileStoreTable
extends DelegatedFileStoreTable {
    private static final Logger LOG = LoggerFactory.getLogger(FallbackReadFileStoreTable.class);
    private final FileStoreTable fallback;

    public FallbackReadFileStoreTable(FileStoreTable wrapped, FileStoreTable fallback) {
        super(wrapped);
        this.fallback = fallback;
        Preconditions.checkArgument(!(wrapped instanceof FallbackReadFileStoreTable));
        Preconditions.checkArgument(!(fallback instanceof FallbackReadFileStoreTable));
    }

    public FileStoreTable fallback() {
        return this.fallback;
    }

    @Override
    public FileStoreTable copy(Map<String, String> dynamicOptions) {
        return new FallbackReadFileStoreTable((FileStoreTable)this.wrapped.copy((Map)dynamicOptions), (FileStoreTable)this.fallback.copy((Map)this.rewriteFallbackOptions(dynamicOptions)));
    }

    @Override
    public FileStoreTable copy(TableSchema newTableSchema) {
        return new FallbackReadFileStoreTable(this.wrapped.copy(newTableSchema), this.fallback.copy(newTableSchema.copy(this.rewriteFallbackOptions(newTableSchema.options()))));
    }

    @Override
    public FileStoreTable copyWithoutTimeTravel(Map<String, String> dynamicOptions) {
        return new FallbackReadFileStoreTable(this.wrapped.copyWithoutTimeTravel(dynamicOptions), this.fallback.copyWithoutTimeTravel(this.rewriteFallbackOptions(dynamicOptions)));
    }

    @Override
    public FileStoreTable copyWithLatestSchema() {
        return new FallbackReadFileStoreTable(this.wrapped.copyWithLatestSchema(), this.fallback.copyWithLatestSchema());
    }

    @Override
    public FileStoreTable switchToBranch(String branchName) {
        return new FallbackReadFileStoreTable(this.switchWrappedToBranch(branchName), this.fallback);
    }

    @Override
    public void setManifestCache(SegmentsCache<Path> manifestCache) {
        super.setManifestCache(manifestCache);
        this.fallback.setManifestCache(manifestCache);
    }

    private FileStoreTable switchWrappedToBranch(String branchName) {
        Optional<TableSchema> optionalSchema = this.wrapped.schemaManager().copyWithBranch(branchName).latest();
        Preconditions.checkArgument(optionalSchema.isPresent(), "Branch " + branchName + " does not exist");
        TableSchema branchSchema = optionalSchema.get();
        Options branchOptions = new Options(branchSchema.options());
        branchOptions.set(CoreOptions.BRANCH, branchName);
        branchSchema = branchSchema.copy(branchOptions.toMap());
        return FileStoreTableFactory.createWithoutFallbackBranch(this.wrapped.fileIO(), this.wrapped.location(), branchSchema, new Options(), this.wrapped.catalogEnvironment());
    }

    private Map<String, String> rewriteFallbackOptions(Map<String, String> options) {
        String scanSnapshotIdOptionKey;
        String scanSnapshotId;
        HashMap<String, String> result = new HashMap<String, String>(options);
        String branchKey = CoreOptions.BRANCH.key();
        if (options.containsKey(branchKey)) {
            result.put(branchKey, this.fallback.options().get(branchKey));
        }
        if ((scanSnapshotId = options.get(scanSnapshotIdOptionKey = CoreOptions.SCAN_SNAPSHOT_ID.key())) != null) {
            long id = Long.parseLong(scanSnapshotId);
            long millis = this.wrapped.snapshotManager().snapshot(id).timeMillis();
            Snapshot fallbackSnapshot = this.fallback.snapshotManager().earlierOrEqualTimeMills(millis);
            long fallbackId = fallbackSnapshot == null ? 1L : fallbackSnapshot.id();
            result.put(scanSnapshotIdOptionKey, String.valueOf(fallbackId));
        }
        result.remove(CoreOptions.BUCKET.key());
        return result;
    }

    @Override
    public DataTableScan newScan() {
        this.validateSchema();
        return new FallbackReadScan(this.wrapped.newScan(), this.fallback.newScan());
    }

    private void validateSchema() {
        String mainBranch = this.wrapped.coreOptions().branch();
        String fallbackBranch = this.fallback.coreOptions().branch();
        RowType mainRowType = this.wrapped.schema().logicalRowType();
        RowType fallbackRowType = this.fallback.schema().logicalRowType();
        Preconditions.checkArgument(this.sameRowTypeIgnoreNullable(mainRowType, fallbackRowType), "Branch %s and %s does not have the same row type.\nRow type of branch %s is %s.\nRow type of branch %s is %s.", mainBranch, fallbackBranch, mainBranch, mainRowType, fallbackBranch, fallbackRowType);
        List<String> mainPrimaryKeys = this.wrapped.schema().primaryKeys();
        List<String> fallbackPrimaryKeys = this.fallback.schema().primaryKeys();
        if (!mainPrimaryKeys.isEmpty()) {
            if (fallbackPrimaryKeys.isEmpty()) {
                throw new IllegalArgumentException("Branch " + mainBranch + " has primary keys while fallback branch " + fallbackBranch + " does not. This is not allowed.");
            }
            Preconditions.checkArgument(mainPrimaryKeys.equals(fallbackPrimaryKeys), "Branch %s and %s both have primary keys but are not the same.\nPrimary keys of %s are %s.\nPrimary keys of %s are %s.", mainBranch, fallbackBranch, mainBranch, mainPrimaryKeys, fallbackBranch, fallbackPrimaryKeys);
        }
    }

    private boolean sameRowTypeIgnoreNullable(RowType mainRowType, RowType fallbackRowType) {
        if (mainRowType.getFieldCount() != fallbackRowType.getFieldCount()) {
            return false;
        }
        for (int i = 0; i < mainRowType.getFieldCount(); ++i) {
            DataType fallbackType;
            DataType mainType = mainRowType.getFields().get(i).type();
            if (mainType.equalsIgnoreNullable(fallbackType = fallbackRowType.getFields().get(i).type())) continue;
            return false;
        }
        return true;
    }

    @Override
    public InnerTableRead newRead() {
        return new Read();
    }

    private class Read
    implements InnerTableRead {
        private final InnerTableRead mainRead;
        private final InnerTableRead fallbackRead;

        private Read() {
            this.mainRead = FallbackReadFileStoreTable.this.wrapped.newRead();
            this.fallbackRead = FallbackReadFileStoreTable.this.fallback.newRead();
        }

        @Override
        public InnerTableRead withFilter(Predicate predicate) {
            this.mainRead.withFilter(predicate);
            this.fallbackRead.withFilter(predicate);
            return this;
        }

        @Override
        public InnerTableRead withReadType(RowType readType) {
            this.mainRead.withReadType(readType);
            this.fallbackRead.withReadType(readType);
            return this;
        }

        @Override
        public InnerTableRead forceKeepDelete() {
            this.mainRead.forceKeepDelete();
            this.fallbackRead.forceKeepDelete();
            return this;
        }

        @Override
        public TableRead executeFilter() {
            this.mainRead.executeFilter();
            this.fallbackRead.executeFilter();
            return this;
        }

        @Override
        public TableRead withIOManager(IOManager ioManager) {
            this.mainRead.withIOManager(ioManager);
            this.fallbackRead.withIOManager(ioManager);
            return this;
        }

        @Override
        public RecordReader<InternalRow> createReader(Split split) throws IOException {
            FallbackDataSplit fallbackDataSplit;
            if (split instanceof FallbackDataSplit && (fallbackDataSplit = (FallbackDataSplit)split).isFallback) {
                try {
                    return this.fallbackRead.createReader(fallbackDataSplit);
                }
                catch (Exception ignored) {
                    LOG.error("Reading from fallback branch has problems for files: {}", (Object)fallbackDataSplit.dataFiles().stream().map(DataFileMeta::fileName).collect(Collectors.joining(", ")));
                }
            }
            DataSplit dataSplit = (DataSplit)split;
            return this.mainRead.createReader(dataSplit);
        }
    }

    public static class FallbackReadScan
    implements DataTableScan {
        private final DataTableScan mainScan;
        private final DataTableScan fallbackScan;

        public FallbackReadScan(DataTableScan mainScan, DataTableScan fallbackScan) {
            this.mainScan = mainScan;
            this.fallbackScan = fallbackScan;
        }

        @Override
        public FallbackReadScan withShard(int indexOfThisSubtask, int numberOfParallelSubtasks) {
            this.mainScan.withShard(indexOfThisSubtask, numberOfParallelSubtasks);
            this.fallbackScan.withShard(indexOfThisSubtask, numberOfParallelSubtasks);
            return this;
        }

        @Override
        public FallbackReadScan withFilter(Predicate predicate) {
            this.mainScan.withFilter(predicate);
            this.fallbackScan.withFilter(predicate);
            return this;
        }

        @Override
        public FallbackReadScan withLimit(int limit) {
            this.mainScan.withLimit(limit);
            this.fallbackScan.withLimit(limit);
            return this;
        }

        @Override
        public FallbackReadScan withPartitionFilter(Map<String, String> partitionSpec) {
            this.mainScan.withPartitionFilter(partitionSpec);
            this.fallbackScan.withPartitionFilter(partitionSpec);
            return this;
        }

        @Override
        public FallbackReadScan withPartitionFilter(List<BinaryRow> partitions) {
            this.mainScan.withPartitionFilter(partitions);
            this.fallbackScan.withPartitionFilter(partitions);
            return this;
        }

        @Override
        public InnerTableScan withPartitionsFilter(List<Map<String, String>> partitions) {
            this.mainScan.withPartitionsFilter(partitions);
            this.fallbackScan.withPartitionsFilter(partitions);
            return this;
        }

        @Override
        public InnerTableScan withPartitionFilter(PartitionPredicate partitionPredicate) {
            this.mainScan.withPartitionFilter(partitionPredicate);
            this.fallbackScan.withPartitionFilter(partitionPredicate);
            return this;
        }

        @Override
        public FallbackReadScan withBucketFilter(Filter<Integer> bucketFilter) {
            this.mainScan.withBucketFilter(bucketFilter);
            this.fallbackScan.withBucketFilter(bucketFilter);
            return this;
        }

        @Override
        public FallbackReadScan withLevelFilter(Filter<Integer> levelFilter) {
            this.mainScan.withLevelFilter(levelFilter);
            this.fallbackScan.withLevelFilter(levelFilter);
            return this;
        }

        @Override
        public FallbackReadScan withMetricRegistry(MetricRegistry metricRegistry) {
            this.mainScan.withMetricRegistry(metricRegistry);
            this.fallbackScan.withMetricRegistry(metricRegistry);
            return this;
        }

        @Override
        public InnerTableScan withTopN(TopN topN) {
            this.mainScan.withTopN(topN);
            this.fallbackScan.withTopN(topN);
            return this;
        }

        @Override
        public InnerTableScan dropStats() {
            this.mainScan.dropStats();
            this.fallbackScan.dropStats();
            return this;
        }

        @Override
        public TableScan.Plan plan() {
            ArrayList<DataSplit> splits = new ArrayList<DataSplit>();
            HashSet<BinaryRow> completePartitions = new HashSet<BinaryRow>();
            for (Split split : this.mainScan.plan().splits()) {
                DataSplit dataSplit = (DataSplit)split;
                splits.add(new FallbackDataSplit(dataSplit, false));
                completePartitions.add(dataSplit.partition());
            }
            List<BinaryRow> remainingPartitions = this.fallbackScan.listPartitions().stream().filter(p -> !completePartitions.contains(p)).collect(Collectors.toList());
            if (!remainingPartitions.isEmpty()) {
                this.fallbackScan.withPartitionFilter(remainingPartitions);
                for (Split split : this.fallbackScan.plan().splits()) {
                    splits.add(new FallbackDataSplit((DataSplit)split, true));
                }
            }
            return new DataFilePlan(splits);
        }

        @Override
        public List<PartitionEntry> listPartitionEntries() {
            ArrayList<PartitionEntry> partitionEntries = new ArrayList<PartitionEntry>(this.mainScan.listPartitionEntries());
            Set partitions = partitionEntries.stream().map(PartitionEntry::partition).collect(Collectors.toSet());
            List<PartitionEntry> fallBackPartitionEntries = this.fallbackScan.listPartitionEntries();
            fallBackPartitionEntries.stream().filter(e -> !partitions.contains(e.partition())).forEach(partitionEntries::add);
            return partitionEntries;
        }
    }

    public static class FallbackDataSplit
    extends DataSplit {
        private static final long serialVersionUID = 1L;
        private boolean isFallback;

        private FallbackDataSplit(DataSplit dataSplit, boolean isFallback) {
            this.assign(dataSplit);
            this.isFallback = isFallback;
        }

        @Override
        public boolean equals(Object o) {
            return super.equals(o) && this.isFallback == ((FallbackDataSplit)o).isFallback;
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.isFallback);
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            this.serialize(new DataOutputViewStreamWrapper(out));
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            FallbackDataSplit split = FallbackDataSplit.deserialize(new DataInputViewStreamWrapper(in));
            this.assign(split);
            this.isFallback = split.isFallback;
        }

        @Override
        public void serialize(DataOutputView out) throws IOException {
            super.serialize(out);
            out.writeBoolean(this.isFallback);
        }

        public static FallbackDataSplit deserialize(DataInputView in) throws IOException {
            DataSplit dataSplit = DataSplit.deserialize(in);
            return new FallbackDataSplit(dataSplit, in.readBoolean());
        }
    }
}

