/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.shade.org.apache.parquet;

import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.paimon.shade.org.apache.parquet.ParquetReadOptions;
import org.apache.paimon.shade.org.apache.parquet.bytes.ByteBufferAllocator;
import org.apache.paimon.shade.org.apache.parquet.compression.CompressionCodecFactory;
import org.apache.paimon.shade.org.apache.parquet.conf.HadoopParquetConfiguration;
import org.apache.paimon.shade.org.apache.parquet.crypto.DecryptionPropertiesFactory;
import org.apache.paimon.shade.org.apache.parquet.crypto.FileDecryptionProperties;
import org.apache.paimon.shade.org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.paimon.shade.org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.paimon.shade.org.apache.parquet.hadoop.ParquetMetricsCallback;

public class HadoopReadOptions
extends ParquetReadOptions {
    private final Configuration conf;

    private HadoopReadOptions(boolean useSignedStringMinMax, boolean useStatsFilter, boolean useDictionaryFilter, boolean useRecordFilter, boolean useColumnIndexFilter, boolean usePageChecksumVerification, boolean useBloomFilter, boolean useOffHeapDecryptBuffer, boolean useHadoopVectoredIo, FilterCompat.Filter recordFilter, ParquetMetadataConverter.MetadataFilter metadataFilter, CompressionCodecFactory codecFactory, ByteBufferAllocator allocator, int maxAllocationSize, Map<String, String> properties, Configuration conf, FileDecryptionProperties fileDecryptionProperties, ParquetMetricsCallback metricsCallback) {
        super(useSignedStringMinMax, useStatsFilter, useDictionaryFilter, useRecordFilter, useColumnIndexFilter, usePageChecksumVerification, useBloomFilter, useOffHeapDecryptBuffer, useHadoopVectoredIo, recordFilter, metadataFilter, codecFactory, allocator, maxAllocationSize, properties, fileDecryptionProperties, metricsCallback, new HadoopParquetConfiguration(conf));
        this.conf = conf;
    }

    @Override
    public String getProperty(String property) {
        String value = super.getProperty(property);
        if (value != null) {
            return value;
        }
        return this.conf.get(property);
    }

    public Configuration getConf() {
        return this.conf;
    }

    public static Builder builder(Configuration conf) {
        return new Builder(conf);
    }

    public static Builder builder(Configuration conf, Path filePath) {
        return new Builder(conf, filePath);
    }

    private static FileDecryptionProperties createDecryptionProperties(Path file, Configuration hadoopConfig) {
        DecryptionPropertiesFactory cryptoFactory = DecryptionPropertiesFactory.loadFactory(hadoopConfig);
        if (null == cryptoFactory) {
            return null;
        }
        return cryptoFactory.getFileDecryptionProperties(hadoopConfig, file);
    }

    public static class Builder
    extends ParquetReadOptions.Builder {
        private final Configuration conf;
        private final Path filePath;

        public Builder(Configuration conf) {
            this(conf, null);
        }

        public Builder(Configuration conf, Path filePath) {
            super(new HadoopParquetConfiguration(conf));
            this.conf = conf;
            this.filePath = filePath;
        }

        @Override
        public ParquetReadOptions build() {
            if (null == this.fileDecryptionProperties) {
                this.fileDecryptionProperties = HadoopReadOptions.createDecryptionProperties(this.filePath, this.conf);
            }
            return new HadoopReadOptions(this.useSignedStringMinMax, this.useStatsFilter, this.useDictionaryFilter, this.useRecordFilter, this.useColumnIndexFilter, this.usePageChecksumVerification, this.useBloomFilter, this.useOffHeapDecryptBuffer, this.useHadoopVectoredIo, this.recordFilter, this.metadataFilter, this.codecFactory, this.allocator, this.maxAllocationSize, this.properties, this.conf, this.fileDecryptionProperties, this.metricsCallback);
        }
    }
}

