/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.shade.org.apache.datasketches.memory.internal;

import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.CharBuffer;
import org.apache.paimon.shade.org.apache.datasketches.memory.Utf8CodingException;
import org.apache.paimon.shade.org.apache.datasketches.memory.internal.UnsafeUtil;

final class Utf8 {
    private Utf8() {
    }

    static final int getCharsFromUtf8(long offsetBytes, int utf8LengthBytes, Appendable dst, long cumBaseOffset, Object unsafeObj) throws IOException, Utf8CodingException {
        byte b;
        int i;
        if (dst instanceof CharBuffer && ((CharBuffer)dst).hasArray()) {
            return Utf8.getCharBufferCharsFromUtf8(offsetBytes, (CharBuffer)dst, utf8LengthBytes, cumBaseOffset, unsafeObj);
        }
        long address = cumBaseOffset + offsetBytes;
        for (i = 0; i < utf8LengthBytes && DecodeUtil.isOneByte(b = UnsafeUtil.unsafe.getByte(unsafeObj, address + (long)i)); ++i) {
            dst.append((char)b);
        }
        if (i == utf8LengthBytes) {
            return i;
        }
        return Utf8.getNonAsciiCharsFromUtf8(dst, address + (long)i, address + (long)utf8LengthBytes, unsafeObj, cumBaseOffset) + i;
    }

    private static int getCharBufferCharsFromUtf8(long offsetBytes, CharBuffer cbuf, int utf8LengthBytes, long cumBaseOffset, Object unsafeObj) {
        byte b;
        int i;
        int startCpos;
        char[] carr = cbuf.array();
        int cpos = startCpos = cbuf.position() + cbuf.arrayOffset();
        int clim = cbuf.arrayOffset() + cbuf.limit();
        long address = cumBaseOffset + offsetBytes;
        int cbufNoCheckLimit = Math.min(utf8LengthBytes, clim - cpos);
        for (i = 0; i < cbufNoCheckLimit && DecodeUtil.isOneByte(b = UnsafeUtil.unsafe.getByte(unsafeObj, address + (long)i)); ++i) {
            carr[cpos++] = (char)b;
        }
        while (i < utf8LengthBytes && DecodeUtil.isOneByte(b = UnsafeUtil.unsafe.getByte(unsafeObj, address + (long)i))) {
            Utf8.checkCharBufferPos(cbuf, cpos, clim);
            carr[cpos++] = (char)b;
            ++i;
        }
        if (i == utf8LengthBytes) {
            cbuf.position(cpos - cbuf.arrayOffset());
            return cpos - startCpos;
        }
        return Utf8.getCharBufferNonAsciiCharsFromUtf8(cbuf, carr, cpos, clim, address + (long)i, address + (long)utf8LengthBytes, unsafeObj, cumBaseOffset) - cbuf.arrayOffset();
    }

    private static int getCharBufferNonAsciiCharsFromUtf8(CharBuffer cbuf, char[] carr, int cpos, int clim, long address, long addressLimit, Object unsafeObj, long cumBaseOffset) {
        while (address < addressLimit) {
            byte byte1;
            if (DecodeUtil.isOneByte(byte1 = UnsafeUtil.unsafe.getByte(unsafeObj, address++))) {
                byte b;
                Utf8.checkCharBufferPos(cbuf, cpos, clim);
                carr[cpos++] = (char)byte1;
                while (address < addressLimit && DecodeUtil.isOneByte(b = UnsafeUtil.unsafe.getByte(unsafeObj, address))) {
                    ++address;
                    Utf8.checkCharBufferPos(cbuf, cpos, clim);
                    carr[cpos++] = (char)b;
                }
                continue;
            }
            if (DecodeUtil.isTwoBytes(byte1)) {
                if (address >= addressLimit) {
                    cbuf.position(cpos - cbuf.arrayOffset());
                    long off = address - cumBaseOffset;
                    long limit = addressLimit - cumBaseOffset;
                    throw Utf8CodingException.shortUtf8DecodeByteSequence(byte1, off, limit, 2);
                }
                Utf8.checkCharBufferPos(cbuf, cpos, clim);
                DecodeUtil.handleTwoBytesCharBuffer(byte1, UnsafeUtil.unsafe.getByte(unsafeObj, address++), cbuf, carr, cpos);
                ++cpos;
                continue;
            }
            if (DecodeUtil.isThreeBytes(byte1)) {
                if (address >= addressLimit - 1L) {
                    cbuf.position(cpos - cbuf.arrayOffset());
                    long off = address - cumBaseOffset;
                    long limit = addressLimit - cumBaseOffset;
                    throw Utf8CodingException.shortUtf8DecodeByteSequence(byte1, off, limit, 3);
                }
                Utf8.checkCharBufferPos(cbuf, cpos, clim);
                DecodeUtil.handleThreeBytesCharBuffer(byte1, UnsafeUtil.unsafe.getByte(unsafeObj, address++), UnsafeUtil.unsafe.getByte(unsafeObj, address++), cbuf, carr, cpos);
                ++cpos;
                continue;
            }
            if (address >= addressLimit - 2L) {
                cbuf.position(cpos - cbuf.arrayOffset());
                long off = address - cumBaseOffset;
                long limit = addressLimit - cumBaseOffset;
                throw Utf8CodingException.shortUtf8DecodeByteSequence(byte1, off, limit, 4);
            }
            if (cpos >= clim - 1) {
                cbuf.position(cpos - cbuf.arrayOffset());
                throw new BufferOverflowException();
            }
            DecodeUtil.handleFourBytesCharBuffer(byte1, UnsafeUtil.unsafe.getByte(unsafeObj, address++), UnsafeUtil.unsafe.getByte(unsafeObj, address++), UnsafeUtil.unsafe.getByte(unsafeObj, address++), cbuf, carr, cpos);
            cpos += 2;
        }
        cbuf.position(cpos - cbuf.arrayOffset());
        return cpos;
    }

    private static int getNonAsciiCharsFromUtf8(Appendable dst, long address, long addressLimit, Object unsafeObj, long cumBaseOffset) throws IOException {
        int chars = 0;
        while (address < addressLimit) {
            byte byte1;
            if (DecodeUtil.isOneByte(byte1 = UnsafeUtil.unsafe.getByte(unsafeObj, address++))) {
                byte b;
                dst.append((char)byte1);
                ++chars;
                while (address < addressLimit && DecodeUtil.isOneByte(b = UnsafeUtil.unsafe.getByte(unsafeObj, address))) {
                    ++address;
                    dst.append((char)b);
                    ++chars;
                }
                continue;
            }
            if (DecodeUtil.isTwoBytes(byte1)) {
                if (address >= addressLimit) {
                    long off = address - cumBaseOffset;
                    long limit = addressLimit - cumBaseOffset;
                    throw Utf8CodingException.shortUtf8DecodeByteSequence(byte1, off, limit, 2);
                }
                DecodeUtil.handleTwoBytes(byte1, UnsafeUtil.unsafe.getByte(unsafeObj, address++), dst);
                ++chars;
                continue;
            }
            if (DecodeUtil.isThreeBytes(byte1)) {
                if (address >= addressLimit - 1L) {
                    long off = address - cumBaseOffset;
                    long limit = addressLimit - cumBaseOffset;
                    throw Utf8CodingException.shortUtf8DecodeByteSequence(byte1, off, limit, 3);
                }
                DecodeUtil.handleThreeBytes(byte1, UnsafeUtil.unsafe.getByte(unsafeObj, address++), UnsafeUtil.unsafe.getByte(unsafeObj, address++), dst);
                ++chars;
                continue;
            }
            if (address >= addressLimit - 2L) {
                long off = address - cumBaseOffset;
                long limit = addressLimit - cumBaseOffset;
                throw Utf8CodingException.shortUtf8DecodeByteSequence(byte1, off, limit, 4);
            }
            DecodeUtil.handleFourBytes(byte1, UnsafeUtil.unsafe.getByte(unsafeObj, address++), UnsafeUtil.unsafe.getByte(unsafeObj, address++), UnsafeUtil.unsafe.getByte(unsafeObj, address++), dst);
            chars += 2;
        }
        return chars;
    }

    private static void checkCharBufferPos(CharBuffer cbuf, int cpos, int clim) {
        if (cpos == clim) {
            cbuf.position(cpos - cbuf.arrayOffset());
            throw new BufferOverflowException();
        }
    }

    static long putCharsToUtf8(long offsetBytes, CharSequence src, long capacityBytes, long cumBaseOffset, Object unsafeObj) {
        char c;
        int cIdx = 0;
        long bIdx = cumBaseOffset + offsetBytes;
        long bCnt = 0L;
        long byteLimit = cumBaseOffset + capacityBytes;
        int utf16Length = src.length();
        while (cIdx < utf16Length && (long)cIdx + bIdx < byteLimit && (c = src.charAt(cIdx)) < '\u0080') {
            UnsafeUtil.unsafe.putByte(unsafeObj, bIdx + (long)cIdx, (byte)c);
            ++cIdx;
            ++bCnt;
        }
        if (cIdx == utf16Length) {
            return bCnt;
        }
        bIdx += (long)cIdx;
        while (cIdx < utf16Length) {
            char low;
            c = src.charAt(cIdx);
            if (c < '\u0080' && bIdx < byteLimit) {
                UnsafeUtil.unsafe.putByte(unsafeObj, bIdx++, (byte)c);
                ++bCnt;
            } else if (c < '\u0800' && bIdx < byteLimit - 1L) {
                UnsafeUtil.unsafe.putByte(unsafeObj, bIdx++, (byte)(0x3C0 | c >>> 6));
                UnsafeUtil.unsafe.putByte(unsafeObj, bIdx++, (byte)(0x80 | 0x3F & c));
                bCnt += 2L;
            } else if (!Character.isSurrogate(c) && bIdx < byteLimit - 2L) {
                UnsafeUtil.unsafe.putByte(unsafeObj, bIdx++, (byte)(0x1E0 | c >>> 12));
                UnsafeUtil.unsafe.putByte(unsafeObj, bIdx++, (byte)(0x80 | 0x3F & c >>> 6));
                UnsafeUtil.unsafe.putByte(unsafeObj, bIdx++, (byte)(0x80 | 0x3F & c));
                bCnt += 3L;
            } else if (cIdx <= utf16Length - 2 && bIdx <= byteLimit - 4L && Character.isSurrogatePair(c, low = src.charAt(cIdx + 1))) {
                ++cIdx;
                int codePoint = Character.toCodePoint(c, low);
                UnsafeUtil.unsafe.putByte(unsafeObj, bIdx++, (byte)(0xF0 | codePoint >>> 18));
                UnsafeUtil.unsafe.putByte(unsafeObj, bIdx++, (byte)(0x80 | 0x3F & codePoint >>> 12));
                UnsafeUtil.unsafe.putByte(unsafeObj, bIdx++, (byte)(0x80 | 0x3F & codePoint >>> 6));
                UnsafeUtil.unsafe.putByte(unsafeObj, bIdx++, (byte)(0x80 | 0x3F & codePoint));
                bCnt += 4L;
            } else {
                if (c < '\u0080' && bIdx >= byteLimit || c < '\u0800' && bIdx >= byteLimit - 1L || c < '\uffff' && bIdx >= byteLimit - 2L) {
                    throw Utf8CodingException.outOfMemory();
                }
                if (cIdx > utf16Length - 2) {
                    throw Utf8CodingException.unpairedSurrogate(c);
                }
                if (bIdx > byteLimit - 4L) {
                    int remaining = (int)(bIdx - byteLimit + 4L);
                    throw Utf8CodingException.shortUtf8EncodeByteLength(remaining);
                }
                if (!Character.isSurrogatePair(c, src.charAt(cIdx + 1))) {
                    throw Utf8CodingException.illegalSurrogatePair(c, src.charAt(cIdx + 1));
                }
                throw new IllegalArgumentException("Unknown Utf8 encoding exception");
            }
            ++cIdx;
        }
        return bCnt;
    }

    private static class DecodeUtil {
        private DecodeUtil() {
        }

        static boolean isOneByte(byte b) {
            return b >= 0;
        }

        static boolean isTwoBytes(byte b) {
            return b < -32;
        }

        static boolean isThreeBytes(byte b) {
            return b < -16;
        }

        static void handleTwoBytes(byte byte1, byte byte2, Appendable dst) throws IOException, Utf8CodingException {
            if (byte1 < -62 || DecodeUtil.isNotTrailingByte(byte2)) {
                byte[] out = new byte[]{byte1, byte2};
                throw Utf8CodingException.illegalUtf8DecodeByteSequence(out);
            }
            dst.append((char)((byte1 & 0x1F) << 6 | DecodeUtil.trailingByteValue(byte2)));
        }

        static void handleTwoBytesCharBuffer(byte byte1, byte byte2, CharBuffer cb, char[] ca, int cp) throws Utf8CodingException {
            if (byte1 < -62 || DecodeUtil.isNotTrailingByte(byte2)) {
                byte[] out = new byte[]{byte1, byte2};
                cb.position(cp - cb.arrayOffset());
                throw Utf8CodingException.illegalUtf8DecodeByteSequence(out);
            }
            ca[cp] = (char)((byte1 & 0x1F) << 6 | DecodeUtil.trailingByteValue(byte2));
        }

        static void handleThreeBytes(byte byte1, byte byte2, byte byte3, Appendable dst) throws IOException, Utf8CodingException {
            if (DecodeUtil.isNotTrailingByte(byte2) || byte1 == -32 && byte2 < -96 || byte1 == -19 && byte2 >= -96 || DecodeUtil.isNotTrailingByte(byte3)) {
                byte[] out = new byte[]{byte1, byte2, byte3};
                throw Utf8CodingException.illegalUtf8DecodeByteSequence(out);
            }
            dst.append((char)((byte1 & 0xF) << 12 | DecodeUtil.trailingByteValue(byte2) << 6 | DecodeUtil.trailingByteValue(byte3)));
        }

        static void handleThreeBytesCharBuffer(byte byte1, byte byte2, byte byte3, CharBuffer cb, char[] ca, int cp) throws Utf8CodingException {
            if (DecodeUtil.isNotTrailingByte(byte2) || byte1 == -32 && byte2 < -96 || byte1 == -19 && byte2 >= -96 || DecodeUtil.isNotTrailingByte(byte3)) {
                cb.position(cp - cb.arrayOffset());
                byte[] out = new byte[]{byte1, byte2, byte3};
                throw Utf8CodingException.illegalUtf8DecodeByteSequence(out);
            }
            ca[cp] = (char)((byte1 & 0xF) << 12 | DecodeUtil.trailingByteValue(byte2) << 6 | DecodeUtil.trailingByteValue(byte3));
        }

        static void handleFourBytes(byte byte1, byte byte2, byte byte3, byte byte4, Appendable dst) throws IOException, Utf8CodingException {
            if (DecodeUtil.isNotTrailingByte(byte2) || (byte1 << 28) + (byte2 - -112) >> 30 != 0 || DecodeUtil.isNotTrailingByte(byte3) || DecodeUtil.isNotTrailingByte(byte4)) {
                byte[] out = new byte[]{byte1, byte2, byte3, byte4};
                throw Utf8CodingException.illegalUtf8DecodeByteSequence(out);
            }
            int codepoint = (byte1 & 7) << 18 | DecodeUtil.trailingByteValue(byte2) << 12 | DecodeUtil.trailingByteValue(byte3) << 6 | DecodeUtil.trailingByteValue(byte4);
            dst.append(DecodeUtil.highSurrogate(codepoint));
            dst.append(DecodeUtil.lowSurrogate(codepoint));
        }

        static void handleFourBytesCharBuffer(byte byte1, byte byte2, byte byte3, byte byte4, CharBuffer cb, char[] ca, int cp) throws Utf8CodingException {
            if (DecodeUtil.isNotTrailingByte(byte2) || (byte1 << 28) + (byte2 - -112) >> 30 != 0 || DecodeUtil.isNotTrailingByte(byte3) || DecodeUtil.isNotTrailingByte(byte4)) {
                cb.position(cp - cb.arrayOffset());
                byte[] out = new byte[]{byte1, byte2, byte3, byte4};
                throw Utf8CodingException.illegalUtf8DecodeByteSequence(out);
            }
            int codepoint = (byte1 & 7) << 18 | DecodeUtil.trailingByteValue(byte2) << 12 | DecodeUtil.trailingByteValue(byte3) << 6 | DecodeUtil.trailingByteValue(byte4);
            ca[cp] = DecodeUtil.highSurrogate(codepoint);
            ca[cp + 1] = DecodeUtil.lowSurrogate(codepoint);
        }

        private static boolean isNotTrailingByte(byte b) {
            return b > -65;
        }

        private static int trailingByteValue(byte b) {
            return b & 0x3F;
        }

        private static char highSurrogate(int codePoint) {
            return (char)(55232 + (codePoint >>> 10));
        }

        private static char lowSurrogate(int codePoint) {
            return (char)(56320 + (codePoint & 0x3FF));
        }
    }
}

