/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.operation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.disk.IOManager;
import org.apache.paimon.format.FileFormatDiscover;
import org.apache.paimon.format.FormatKey;
import org.apache.paimon.format.FormatReaderContext;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.io.DataFilePathFactory;
import org.apache.paimon.io.DataFileRecordReader;
import org.apache.paimon.mergetree.compact.ConcatRecordReader;
import org.apache.paimon.operation.SplitRead;
import org.apache.paimon.partition.PartitionUtils;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.reader.DataEvolutionFileReader;
import org.apache.paimon.reader.FileRecordReader;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.table.SpecialFields;
import org.apache.paimon.table.source.DataEvolutionSplitGenerator;
import org.apache.paimon.table.source.DataSplit;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.FileStorePathFactory;
import org.apache.paimon.utils.FormatReaderMapping;
import org.apache.paimon.utils.Preconditions;

public class DataEvolutionSplitRead
implements SplitRead<InternalRow> {
    private final FileIO fileIO;
    private final SchemaManager schemaManager;
    private final TableSchema schema;
    private final FileFormatDiscover formatDiscover;
    private final FileStorePathFactory pathFactory;
    private final Map<FormatKey, FormatReaderMapping> formatReaderMappings;
    protected RowType readRowType;

    public DataEvolutionSplitRead(FileIO fileIO, SchemaManager schemaManager, TableSchema schema, RowType rowType, FileFormatDiscover formatDiscover, FileStorePathFactory pathFactory) {
        this.fileIO = fileIO;
        this.schemaManager = schemaManager;
        this.schema = schema;
        this.formatDiscover = formatDiscover;
        this.pathFactory = pathFactory;
        this.formatReaderMappings = new HashMap<FormatKey, FormatReaderMapping>();
        this.readRowType = rowType;
    }

    @Override
    public SplitRead<InternalRow> forceKeepDelete() {
        return this;
    }

    @Override
    public SplitRead<InternalRow> withIOManager(@Nullable IOManager ioManager) {
        return this;
    }

    @Override
    public SplitRead<InternalRow> withReadType(RowType readRowType) {
        this.readRowType = readRowType;
        return this;
    }

    @Override
    public SplitRead<InternalRow> withFilter(@Nullable Predicate predicate) {
        return this;
    }

    @Override
    public RecordReader<InternalRow> createReader(DataSplit split) throws IOException {
        List<DataFileMeta> files = split.dataFiles();
        BinaryRow partition = split.partition();
        DataFilePathFactory dataFilePathFactory = this.pathFactory.createDataFilePathFactory(partition, split.bucket());
        ArrayList suppliers = new ArrayList();
        FormatReaderMapping.Builder formatBuilder = new FormatReaderMapping.Builder(this.formatDiscover, this.readRowType.getFields(), schema -> SpecialFields.rowTypeWithRowTracking(schema.logicalRowType(), true).getFields(), null, null, null);
        List<List<DataFileMeta>> splitByRowId = DataEvolutionSplitGenerator.split(files);
        for (List<DataFileMeta> needMergeFiles : splitByRowId) {
            if (needMergeFiles.size() == 1 || this.readRowType.getFields().isEmpty()) {
                suppliers.add(() -> this.createFileReader(partition, dataFilePathFactory, (DataFileMeta)needMergeFiles.get(0), formatBuilder));
                continue;
            }
            suppliers.add(() -> this.createUnionReader(needMergeFiles, partition, dataFilePathFactory, formatBuilder));
        }
        return ConcatRecordReader.create(suppliers);
    }

    private DataEvolutionFileReader createUnionReader(List<DataFileMeta> needMergeFiles, BinaryRow partition, DataFilePathFactory dataFilePathFactory, FormatReaderMapping.Builder formatBuilder) throws IOException {
        int i;
        long rowCount = needMergeFiles.get(0).rowCount();
        long firstRowId = needMergeFiles.get(0).firstRowId();
        for (DataFileMeta file : needMergeFiles) {
            Preconditions.checkArgument(file.rowCount() == rowCount, "All files in a field merge split should have the same row count.");
            Preconditions.checkArgument(file.firstRowId() == firstRowId, "All files in a field merge split should have the same first row id and could not be null.");
        }
        List<DataField> allReadFields = this.readRowType.getFields();
        RecordReader[] fileRecordReaders = new RecordReader[needMergeFiles.size()];
        int[] readFieldIndex = allReadFields.stream().mapToInt(DataField::id).toArray();
        int[] rowOffsets = new int[allReadFields.size()];
        int[] fieldOffsets = new int[allReadFields.size()];
        Arrays.fill(rowOffsets, -1);
        Arrays.fill(fieldOffsets, -1);
        for (i = 0; i < needMergeFiles.size(); ++i) {
            DataFileMeta file = needMergeFiles.get(i);
            String formatIdentifier = DataFilePathFactory.formatIdentifier(file.fileName());
            long schemaId = file.schemaId();
            TableSchema dataSchema = this.schemaManager.schema(schemaId).project(file.writeCols());
            int[] fieldIds = SpecialFields.rowTypeWithRowTracking(dataSchema.logicalRowType()).getFields().stream().mapToInt(DataField::id).toArray();
            ArrayList<DataField> readFields = new ArrayList<DataField>();
            block2: for (int j = 0; j < readFieldIndex.length; ++j) {
                for (int fieldId : fieldIds) {
                    if (readFieldIndex[j] != fieldId) continue;
                    if (rowOffsets[j] != -1) continue block2;
                    rowOffsets[j] = i;
                    fieldOffsets[j] = readFields.size();
                    readFields.add(allReadFields.get(j));
                    continue block2;
                }
            }
            if (readFields.isEmpty()) {
                fileRecordReaders[i] = null;
                continue;
            }
            List<String> readFieldNames = readFields.stream().map(DataField::name).collect(Collectors.toList());
            FormatReaderMapping formatReaderMapping = this.formatReaderMappings.computeIfAbsent(new FormatKey(file.schemaId(), formatIdentifier, readFieldNames), key -> formatBuilder.build(formatIdentifier, this.schema, dataSchema, readFields, false));
            fileRecordReaders[i] = this.createFileReader(partition, file, dataFilePathFactory, formatReaderMapping);
        }
        for (i = 0; i < rowOffsets.length; ++i) {
            if (rowOffsets[i] != -1) continue;
            Preconditions.checkArgument(allReadFields.get(i).type().isNullable(), String.format("Field %s is not null but can't find any file contains it.", allReadFields.get(i)));
        }
        return new DataEvolutionFileReader(rowOffsets, fieldOffsets, fileRecordReaders);
    }

    private FileRecordReader<InternalRow> createFileReader(BinaryRow partition, DataFilePathFactory dataFilePathFactory, DataFileMeta file, FormatReaderMapping.Builder formatBuilder) throws IOException {
        String formatIdentifier = DataFilePathFactory.formatIdentifier(file.fileName());
        long schemaId = file.schemaId();
        FormatReaderMapping formatReaderMapping = this.formatReaderMappings.computeIfAbsent(new FormatKey(file.schemaId(), formatIdentifier), key -> formatBuilder.build(formatIdentifier, this.schema, schemaId == this.schema.id() ? this.schema : this.schemaManager.schema(schemaId)));
        return this.createFileReader(partition, file, dataFilePathFactory, formatReaderMapping);
    }

    private FileRecordReader<InternalRow> createFileReader(BinaryRow partition, DataFileMeta file, DataFilePathFactory dataFilePathFactory, FormatReaderMapping formatReaderMapping) throws IOException {
        FormatReaderContext formatReaderContext = new FormatReaderContext(this.fileIO, dataFilePathFactory.toPath(file), file.fileSize(), null);
        return new DataFileRecordReader(this.schema.logicalRowType(), formatReaderMapping.getReaderFactory(), formatReaderContext, formatReaderMapping.getIndexMapping(), formatReaderMapping.getCastMapping(), PartitionUtils.create(formatReaderMapping.getPartitionPair(), partition), true, file.firstRowId(), file.maxSequenceNumber(), formatReaderMapping.getSystemFields());
    }
}

