/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.mergetree.compact;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.apache.paimon.compact.CompactUnit;
import org.apache.paimon.mergetree.LevelSortedRun;
import org.apache.paimon.mergetree.compact.CompactStrategy;
import org.apache.paimon.mergetree.compact.UniversalCompaction;

public class ForceUpLevel0Compaction
implements CompactStrategy {
    private final UniversalCompaction universal;
    @Nullable
    private final Integer maxCompactInterval;
    @Nullable
    private final AtomicInteger compactTriggerCount;

    public ForceUpLevel0Compaction(UniversalCompaction universal, @Nullable Integer maxCompactInterval) {
        this.universal = universal;
        this.maxCompactInterval = maxCompactInterval;
        this.compactTriggerCount = maxCompactInterval == null ? null : new AtomicInteger(0);
    }

    @Nullable
    public Integer maxCompactInterval() {
        return this.maxCompactInterval;
    }

    @Override
    public Optional<CompactUnit> pick(int numLevels, List<LevelSortedRun> runs) {
        Optional<CompactUnit> pick = this.universal.pick(numLevels, runs);
        if (pick.isPresent()) {
            return pick;
        }
        if (this.maxCompactInterval == null || this.compactTriggerCount == null) {
            return this.universal.forcePickL0(numLevels, runs);
        }
        this.compactTriggerCount.getAndIncrement();
        if (this.compactTriggerCount.compareAndSet(this.maxCompactInterval, 0)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Universal compaction due to max lookup compaction interval {}.", (Object)this.maxCompactInterval);
            }
            return this.universal.forcePickL0(numLevels, runs);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Skip universal compaction due to lookup compaction trigger count {} is less than the max interval {}.", (Object)this.compactTriggerCount.get(), (Object)this.maxCompactInterval);
        }
        return Optional.empty();
    }
}

