/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.manifest;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.manifest.FileEntry;
import org.apache.paimon.manifest.FileKind;
import org.apache.paimon.manifest.ManifestEntry;

public class PojoManifestEntry
implements ManifestEntry {
    private final FileKind kind;
    private final BinaryRow partition;
    private final int bucket;
    private final int totalBuckets;
    private final DataFileMeta file;

    public PojoManifestEntry(FileKind kind, BinaryRow partition, int bucket, int totalBuckets, DataFileMeta file) {
        this.kind = kind;
        this.partition = partition;
        this.bucket = bucket;
        this.totalBuckets = totalBuckets;
        this.file = file;
    }

    @Override
    public FileKind kind() {
        return this.kind;
    }

    @Override
    public BinaryRow partition() {
        return this.partition;
    }

    @Override
    public int bucket() {
        return this.bucket;
    }

    @Override
    public int level() {
        return this.file.level();
    }

    @Override
    public String fileName() {
        return this.file.fileName();
    }

    @Override
    @Nullable
    public String externalPath() {
        return this.file.externalPath().orElse(null);
    }

    @Override
    public BinaryRow minKey() {
        return this.file.minKey();
    }

    @Override
    public BinaryRow maxKey() {
        return this.file.maxKey();
    }

    @Override
    public List<String> extraFiles() {
        return this.file.extraFiles();
    }

    @Override
    public int totalBuckets() {
        return this.totalBuckets;
    }

    @Override
    public DataFileMeta file() {
        return this.file;
    }

    @Override
    public FileEntry.Identifier identifier() {
        return new FileEntry.Identifier(this.partition, this.bucket, this.file.level(), this.file.fileName(), this.file.extraFiles(), this.file.embeddedIndex(), this.externalPath());
    }

    @Override
    public PojoManifestEntry copyWithoutStats() {
        return new PojoManifestEntry(this.kind, this.partition, this.bucket, this.totalBuckets, this.file.copyWithoutStats());
    }

    @Override
    public PojoManifestEntry assignSequenceNumber(long minSequenceNumber, long maxSequenceNumber) {
        return new PojoManifestEntry(this.kind, this.partition, this.bucket, this.totalBuckets, this.file.assignSequenceNumber(minSequenceNumber, maxSequenceNumber));
    }

    @Override
    public PojoManifestEntry assignFirstRowId(long firstRowId) {
        return new PojoManifestEntry(this.kind, this.partition, this.bucket, this.totalBuckets, this.file.assignFirstRowId(firstRowId));
    }

    public boolean equals(Object o) {
        if (!(o instanceof ManifestEntry)) {
            return false;
        }
        ManifestEntry that = (ManifestEntry)o;
        return Objects.equals((Object)this.kind, (Object)that.kind()) && Objects.equals(this.partition, that.partition()) && this.bucket == that.bucket() && this.totalBuckets == that.totalBuckets() && Objects.equals(this.file, that.file());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.kind, this.partition, this.bucket, this.totalBuckets, this.file});
    }

    public String toString() {
        return String.format("{%s, %s, %d, %d, %s}", new Object[]{this.kind, this.partition, this.bucket, this.totalBuckets, this.file});
    }
}

