/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.lookup.rocksdb;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.paimon.data.serializer.Serializer;
import org.apache.paimon.lookup.ListState;
import org.apache.paimon.lookup.rocksdb.RocksDBState;
import org.apache.paimon.lookup.rocksdb.RocksDBStateFactory;
import org.apache.paimon.utils.ListDelimitedSerializer;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.RocksDBException;

public class RocksDBListState<K, V>
extends RocksDBState<K, V, List<V>>
implements ListState<K, V> {
    private final ListDelimitedSerializer listSerializer = new ListDelimitedSerializer();

    public RocksDBListState(RocksDBStateFactory stateFactory, ColumnFamilyHandle columnFamily, Serializer<K> keySerializer, Serializer<V> valueSerializer, long lruCacheSize) {
        super(stateFactory, columnFamily, keySerializer, valueSerializer, lruCacheSize);
    }

    @Override
    public void add(K key, V value) throws IOException {
        byte[] keyBytes = this.serializeKey(key);
        byte[] valueBytes = this.serializeValue(value);
        try {
            this.db.merge(this.columnFamily, this.writeOptions, keyBytes, valueBytes);
        }
        catch (RocksDBException e) {
            throw new IOException(e);
        }
        this.cache.invalidate(this.wrap(keyBytes));
    }

    @Override
    public List<V> get(K key) throws IOException {
        byte[] keyBytes = this.serializeKey(key);
        return this.cache.get(this.wrap(keyBytes), k -> {
            byte[] valueBytes;
            try {
                valueBytes = this.db.get(this.columnFamily, keyBytes);
            }
            catch (RocksDBException e) {
                throw new RuntimeException(e);
            }
            List rows = this.listSerializer.deserializeList(valueBytes, this.valueSerializer);
            if (rows == null) {
                return Collections.emptyList();
            }
            return rows;
        });
    }
}

