/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.io;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.KeyValue;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.deletionvectors.ApplyDeletionVectorReader;
import org.apache.paimon.deletionvectors.DeletionVector;
import org.apache.paimon.format.FileFormatDiscover;
import org.apache.paimon.format.FormatKey;
import org.apache.paimon.format.FormatReaderContext;
import org.apache.paimon.format.OrcFormatReaderContext;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.io.DataFilePathFactory;
import org.apache.paimon.io.DataFileRecordReader;
import org.apache.paimon.io.FileReaderFactory;
import org.apache.paimon.io.KeyValueDataFileRecordReader;
import org.apache.paimon.partition.PartitionUtils;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.reader.FileRecordReader;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.schema.KeyValueFieldsExtractor;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.AsyncRecordReader;
import org.apache.paimon.utils.FileStorePathFactory;
import org.apache.paimon.utils.FormatReaderMapping;

public class KeyValueFileReaderFactory
implements FileReaderFactory<KeyValue> {
    private final FileIO fileIO;
    private final SchemaManager schemaManager;
    private final TableSchema schema;
    private final RowType keyType;
    private final RowType valueType;
    private final FormatReaderMapping.Builder formatReaderMappingBuilder;
    private final DataFilePathFactory pathFactory;
    private final long asyncThreshold;
    private final Map<FormatKey, FormatReaderMapping> formatReaderMappings;
    private final BinaryRow partition;
    private final DeletionVector.Factory dvFactory;

    private KeyValueFileReaderFactory(FileIO fileIO, SchemaManager schemaManager, TableSchema schema, RowType keyType, RowType valueType, FormatReaderMapping.Builder formatReaderMappingBuilder, DataFilePathFactory pathFactory, long asyncThreshold, BinaryRow partition, DeletionVector.Factory dvFactory) {
        this.fileIO = fileIO;
        this.schemaManager = schemaManager;
        this.schema = schema;
        this.keyType = keyType;
        this.valueType = valueType;
        this.formatReaderMappingBuilder = formatReaderMappingBuilder;
        this.pathFactory = pathFactory;
        this.asyncThreshold = asyncThreshold;
        this.partition = partition;
        this.formatReaderMappings = new HashMap<FormatKey, FormatReaderMapping>();
        this.dvFactory = dvFactory;
    }

    @Override
    public RecordReader<KeyValue> createRecordReader(DataFileMeta file) throws IOException {
        if (file.fileSize() >= this.asyncThreshold && file.fileName().endsWith(".orc")) {
            return new AsyncRecordReader<KeyValue>(() -> this.createRecordReader(file, false, 2));
        }
        return this.createRecordReader(file, true, null);
    }

    private FileRecordReader<KeyValue> createRecordReader(DataFileMeta file, boolean reuseFormat, @Nullable Integer orcPoolSize) throws IOException {
        String formatIdentifier = DataFilePathFactory.formatIdentifier(file.fileName());
        long schemaId = file.schemaId();
        Supplier<FormatReaderMapping> formatSupplier = () -> this.formatReaderMappingBuilder.build(formatIdentifier, this.schema, schemaId == this.schema.id() ? this.schema : this.schemaManager.schema(schemaId));
        FormatReaderMapping formatReaderMapping = reuseFormat ? this.formatReaderMappings.computeIfAbsent(new FormatKey(schemaId, formatIdentifier), key -> (FormatReaderMapping)formatSupplier.get()) : formatSupplier.get();
        Path filePath = this.pathFactory.toPath(file);
        long fileSize = file.fileSize();
        FileRecordReader<InternalRow> fileRecordReader = new DataFileRecordReader(this.schema.logicalRowType(), formatReaderMapping.getReaderFactory(), orcPoolSize == null ? new FormatReaderContext(this.fileIO, filePath, fileSize) : new OrcFormatReaderContext(this.fileIO, filePath, fileSize, orcPoolSize), formatReaderMapping.getIndexMapping(), formatReaderMapping.getCastMapping(), PartitionUtils.create(formatReaderMapping.getPartitionPair(), this.partition), false, null, -1L, Collections.emptyMap());
        Optional<DeletionVector> deletionVector = this.dvFactory.create(file.fileName());
        if (deletionVector.isPresent() && !deletionVector.get().isEmpty()) {
            fileRecordReader = new ApplyDeletionVectorReader(fileRecordReader, deletionVector.get());
        }
        return new KeyValueDataFileRecordReader(fileRecordReader, this.keyType, this.valueType, file.level());
    }

    public static Builder builder(FileIO fileIO, SchemaManager schemaManager, TableSchema schema, RowType keyType, RowType valueType, FileFormatDiscover formatDiscover, FileStorePathFactory pathFactory, KeyValueFieldsExtractor extractor, CoreOptions options) {
        return new Builder(fileIO, schemaManager, schema, keyType, valueType, formatDiscover, pathFactory, extractor, options);
    }

    public static class Builder {
        private final FileIO fileIO;
        private final SchemaManager schemaManager;
        private final TableSchema schema;
        private final RowType keyType;
        private final RowType valueType;
        private final FileFormatDiscover formatDiscover;
        private final FileStorePathFactory pathFactory;
        private final KeyValueFieldsExtractor extractor;
        private final CoreOptions options;
        private RowType readKeyType;
        private RowType readValueType;

        private Builder(FileIO fileIO, SchemaManager schemaManager, TableSchema schema, RowType keyType, RowType valueType, FileFormatDiscover formatDiscover, FileStorePathFactory pathFactory, KeyValueFieldsExtractor extractor, CoreOptions options) {
            this.fileIO = fileIO;
            this.schemaManager = schemaManager;
            this.schema = schema;
            this.keyType = keyType;
            this.valueType = valueType;
            this.formatDiscover = formatDiscover;
            this.pathFactory = pathFactory;
            this.extractor = extractor;
            this.options = options;
            this.readKeyType = keyType;
            this.readValueType = valueType;
        }

        public Builder copyWithoutProjection() {
            return new Builder(this.fileIO, this.schemaManager, this.schema, this.keyType, this.valueType, this.formatDiscover, this.pathFactory, this.extractor, this.options);
        }

        public Builder withReadKeyType(RowType readKeyType) {
            this.readKeyType = readKeyType;
            return this;
        }

        public Builder withReadValueType(RowType readValueType) {
            this.readValueType = readValueType;
            return this;
        }

        public RowType keyType() {
            return this.keyType;
        }

        public RowType readValueType() {
            return this.readValueType;
        }

        public KeyValueFileReaderFactory build(BinaryRow partition, int bucket, DeletionVector.Factory dvFactory) {
            return this.build(partition, bucket, dvFactory, true, Collections.emptyList());
        }

        public KeyValueFileReaderFactory build(BinaryRow partition, int bucket, DeletionVector.Factory dvFactory, boolean projectKeys, @Nullable List<Predicate> filters) {
            RowType finalReadKeyType = projectKeys ? this.readKeyType : this.keyType;
            Function<TableSchema, List<DataField>> fieldsExtractor = schema -> {
                List<DataField> dataKeyFields = this.extractor.keyFields((TableSchema)schema);
                List<DataField> dataValueFields = this.extractor.valueFields((TableSchema)schema);
                return KeyValue.createKeyValueFields(dataKeyFields, dataValueFields);
            };
            List<DataField> readTableFields = KeyValue.createKeyValueFields(finalReadKeyType.getFields(), this.readValueType.getFields());
            return new KeyValueFileReaderFactory(this.fileIO, this.schemaManager, this.schema, finalReadKeyType, this.readValueType, new FormatReaderMapping.Builder(this.formatDiscover, readTableFields, fieldsExtractor, filters, null, null), this.pathFactory.createDataFilePathFactory(partition, bucket), this.options.fileReaderAsyncThreshold().getBytes(), partition, dvFactory);
        }

        public FileIO fileIO() {
            return this.fileIO;
        }
    }
}

