/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.io;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.paimon.deletionvectors.BitmapDeletionVector;
import org.apache.paimon.deletionvectors.DeletionVector;
import org.apache.paimon.fileindex.FileIndexPredicate;
import org.apache.paimon.fileindex.FileIndexResult;
import org.apache.paimon.fileindex.bitmap.BitmapIndexResult;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.io.DataFilePathFactory;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.predicate.PredicateBuilder;
import org.apache.paimon.predicate.TopN;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.utils.ListUtils;
import org.apache.paimon.utils.RoaringBitmap32;

public class FileIndexEvaluator {
    public static FileIndexResult evaluate(FileIO fileIO, TableSchema dataSchema, List<Predicate> dataFilter, @Nullable TopN topN, @Nullable Integer limit, DataFilePathFactory dataFilePathFactory, DataFileMeta file, @Nullable DeletionVector dv) throws IOException {
        if (ListUtils.isNullOrEmpty(dataFilter) && topN == null) {
            if (limit == null) {
                return FileIndexResult.REMAIN;
            }
            return FileIndexEvaluator.createBaseSelection(file, dv).limit(limit);
        }
        try (FileIndexPredicate predicate = FileIndexEvaluator.createFileIndexPredicate(fileIO, dataSchema, dataFilePathFactory, file);){
            FileIndexResult fileIndexResult;
            FileIndexResult result;
            if (predicate == null) {
                FileIndexResult fileIndexResult2 = FileIndexResult.REMAIN;
                return fileIndexResult2;
            }
            BitmapIndexResult selection = FileIndexEvaluator.createBaseSelection(file, dv);
            if (!ListUtils.isNullOrEmpty(dataFilter)) {
                Predicate filter = PredicateBuilder.and(dataFilter.toArray(new Predicate[0]));
                result = predicate.evaluate(filter);
                result.and(selection);
            } else if (topN != null) {
                result = predicate.evaluateTopN(topN, selection);
            } else {
                FileIndexResult fileIndexResult3 = FileIndexResult.REMAIN;
                return fileIndexResult3;
            }
            if (Objects.equals(result, selection)) {
                fileIndexResult = FileIndexResult.REMAIN;
                return fileIndexResult;
            }
            if (!result.remain()) {
                fileIndexResult = FileIndexResult.SKIP;
                return fileIndexResult;
            }
            fileIndexResult = result;
            return fileIndexResult;
        }
    }

    private static BitmapIndexResult createBaseSelection(DataFileMeta file, @Nullable DeletionVector dv) {
        BitmapIndexResult selection = new BitmapIndexResult(() -> RoaringBitmap32.bitmapOfRange(0L, file.rowCount()));
        if (dv instanceof BitmapDeletionVector) {
            RoaringBitmap32 deletion = ((BitmapDeletionVector)dv).get();
            selection = selection.andNot(deletion);
        }
        return selection;
    }

    @Nullable
    private static FileIndexPredicate createFileIndexPredicate(FileIO fileIO, TableSchema dataSchema, DataFilePathFactory dataFilePathFactory, DataFileMeta file) throws IOException {
        FileIndexPredicate predicate;
        byte[] embeddedIndex = file.embeddedIndex();
        if (embeddedIndex != null) {
            predicate = new FileIndexPredicate(embeddedIndex, dataSchema.logicalRowType());
        } else {
            List indexFiles = file.extraFiles().stream().filter(name -> name.endsWith(".index")).collect(Collectors.toList());
            if (indexFiles.isEmpty()) {
                return null;
            }
            if (indexFiles.size() > 1) {
                throw new RuntimeException("Found more than one index file for one data file: " + String.join((CharSequence)" and ", indexFiles));
            }
            predicate = new FileIndexPredicate(dataFilePathFactory.toAlignedPath((String)indexFiles.get(0), file), fileIO, dataSchema.logicalRowType());
        }
        return predicate;
    }
}

