/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hive;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.TableType;
import org.apache.paimon.format.csv.CsvOptions;
import org.apache.paimon.hive.HiveCatalog;
import org.apache.paimon.hive.HiveTypeUtils;
import org.apache.paimon.options.Options;
import org.apache.paimon.schema.Schema;
import org.apache.paimon.table.FormatTable;
import org.apache.paimon.types.RowType;

class HiveTableUtils {
    HiveTableUtils() {
    }

    public static Schema tryToFormatSchema(Table hiveTable) {
        FormatTable.Format format;
        String inputFormat;
        if (HiveCatalog.isView(hiveTable)) {
            throw new UnsupportedOperationException("Hive view is not supported.");
        }
        Options options = Options.fromMap(hiveTable.getParameters());
        List<String> partitionKeys = HiveTableUtils.getFieldNames(hiveTable.getPartitionKeys());
        RowType rowType = HiveTableUtils.createRowType(hiveTable);
        String comment = options.remove("comment");
        StorageDescriptor sd = hiveTable.getSd();
        if (sd == null) {
            throw new UnsupportedOperationException("Unsupported table: " + hiveTable);
        }
        String location = sd.getLocation();
        SerDeInfo serdeInfo = sd.getSerdeInfo();
        if (serdeInfo == null) {
            throw new UnsupportedOperationException("Unsupported table: " + hiveTable);
        }
        String serLib = serdeInfo.getSerializationLib() == null ? "" : serdeInfo.getSerializationLib().toLowerCase();
        String string = inputFormat = sd.getInputFormat() == null ? "" : sd.getInputFormat();
        if (serLib.contains("parquet")) {
            format = FormatTable.Format.PARQUET;
        } else if (serLib.contains("orc")) {
            format = FormatTable.Format.ORC;
        } else if (inputFormat.contains("Text")) {
            if (serLib.contains("json")) {
                format = FormatTable.Format.JSON;
            } else {
                format = FormatTable.Format.CSV;
                options.set(CsvOptions.FIELD_DELIMITER, serdeInfo.getParameters().getOrDefault("field.delim", "\u0001"));
            }
        } else {
            throw new UnsupportedOperationException("Unsupported table: " + hiveTable);
        }
        Schema.Builder builder = Schema.newBuilder();
        rowType.getFields().forEach(f -> builder.column(f.name(), f.type(), f.description()));
        options.set(CoreOptions.PATH, location);
        options.set(CoreOptions.TYPE, TableType.FORMAT_TABLE);
        options.set(CoreOptions.FILE_FORMAT, format.name().toLowerCase());
        return builder.partitionKeys(partitionKeys).options(options.toMap()).comment(comment).build();
    }

    private static List<String> getFieldNames(List<FieldSchema> fieldSchemas) {
        ArrayList<String> names = new ArrayList<String>(fieldSchemas.size());
        for (FieldSchema fs : fieldSchemas) {
            names.add(fs.getName());
        }
        return names;
    }

    public static RowType createRowType(Table table) {
        ArrayList allCols = new ArrayList(table.getSd().getCols());
        allCols.addAll(table.getPartitionKeys());
        RowType.Builder builder = RowType.builder();
        for (FieldSchema fs : allCols) {
            builder.field(fs.getName(), HiveTypeUtils.toPaimonType(fs.getType()), fs.getComment());
        }
        return builder.build();
    }
}

