/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.fs.hadoop;

import java.io.IOException;
import java.net.URI;
import java.util.concurrent.Callable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Progressable;
import org.apache.paimon.options.Options;
import org.apache.paimon.security.HadoopModule;
import org.apache.paimon.security.SecurityConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopSecuredFileSystem
extends FileSystem {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopSecuredFileSystem.class);
    private final FileSystem fileSystem;
    private final UserGroupInformation ugi;

    private HadoopSecuredFileSystem(FileSystem fileSystem, UserGroupInformation ugi) {
        this.fileSystem = fileSystem;
        this.ugi = ugi;
    }

    public Configuration getConf() {
        return this.fileSystem.getConf();
    }

    public URI getUri() {
        return this.runSecured(() -> ((FileSystem)this.fileSystem).getUri());
    }

    public FSDataInputStream open(Path path, int bufferSize) throws IOException {
        return this.runSecuredWithIOException(() -> this.fileSystem.open(path, bufferSize));
    }

    public FSDataOutputStream create(Path path, FsPermission fsPermission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progressable) throws IOException {
        return this.runSecuredWithIOException(() -> this.fileSystem.create(path, fsPermission, overwrite, bufferSize, replication, blockSize, progressable));
    }

    public boolean exists(Path f) throws IOException {
        return this.runSecuredWithIOException(() -> this.fileSystem.exists(f));
    }

    public FSDataOutputStream append(Path path, int bufferSize, Progressable progressable) throws IOException {
        return this.runSecuredWithIOException(() -> this.fileSystem.append(path, bufferSize, progressable));
    }

    public boolean rename(Path src, Path dst) throws IOException {
        return this.runSecuredWithIOException(() -> this.fileSystem.rename(src, dst));
    }

    public boolean delete(Path path, boolean recursive) throws IOException {
        return this.runSecuredWithIOException(() -> this.fileSystem.delete(path, recursive));
    }

    public FileStatus[] listStatus(Path path) throws IOException {
        return this.runSecuredWithIOException(() -> this.fileSystem.listStatus(path));
    }

    public void setWorkingDirectory(Path path) {
        this.runSecured(() -> this.fileSystem.setWorkingDirectory(path));
    }

    public Path getWorkingDirectory() {
        return this.runSecured(() -> ((FileSystem)this.fileSystem).getWorkingDirectory());
    }

    public boolean mkdirs(Path path, FsPermission fsPermission) throws IOException {
        return this.runSecuredWithIOException(() -> this.fileSystem.mkdirs(path, fsPermission));
    }

    public FileStatus getFileStatus(Path path) throws IOException {
        return this.runSecuredWithIOException(() -> this.fileSystem.getFileStatus(path));
    }

    private void runSecured(Runnable securedRunnable) {
        this.runSecured(() -> {
            securedRunnable.run();
            return null;
        });
    }

    private <T> T runSecured(Callable<T> securedCallable) {
        try {
            return (T)this.ugi.doAs(securedCallable::call);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private <T> T runSecuredWithIOException(Callable<T> securedCallable) throws IOException {
        try {
            return (T)this.ugi.doAs(securedCallable::call);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static FileSystem trySecureFileSystem(FileSystem fileSystem, Options options, Configuration configuration) throws IOException {
        SecurityConfiguration config = new SecurityConfiguration(options);
        if (config.isLegal()) {
            LOG.info("Hadoop security configuration is legal, use the secured FileSystem.");
            HadoopModule module = new HadoopModule(config, configuration);
            module.install();
            UserGroupInformation ugi = UserGroupInformation.getLoginUser();
            return new HadoopSecuredFileSystem(fileSystem, ugi);
        }
        LOG.info("Hadoop security configuration is illegal, use the original FileSystem.");
        return fileSystem;
    }
}

