/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.text;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.format.text.HadoopCompressionUtils;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.reader.FileRecordIterator;
import org.apache.paimon.reader.FileRecordReader;
import org.apache.paimon.types.RowType;

public abstract class BaseTextFileReader
implements FileRecordReader<InternalRow> {
    protected final Path filePath;
    protected final RowType rowType;
    protected final InputStream decompressedStream;
    protected final BufferedReader bufferedReader;
    protected boolean readerClosed = false;
    protected BaseTextRecordIterator reader;

    protected BaseTextFileReader(FileIO fileIO, Path filePath, RowType rowType) throws IOException {
        this.filePath = filePath;
        this.rowType = rowType;
        this.decompressedStream = HadoopCompressionUtils.createDecompressedInputStream(fileIO.newInputStream(filePath), filePath);
        this.bufferedReader = new BufferedReader(new InputStreamReader(this.decompressedStream, StandardCharsets.UTF_8));
        this.reader = this.createRecordIterator();
    }

    protected abstract BaseTextRecordIterator createRecordIterator();

    protected abstract InternalRow parseLine(String var1) throws IOException;

    protected void setupReading() throws IOException {
    }

    @Override
    @Nullable
    public FileRecordIterator<InternalRow> readBatch() throws IOException {
        if (this.readerClosed) {
            return null;
        }
        this.setupReading();
        if (this.reader.end) {
            return null;
        }
        return this.reader;
    }

    @Override
    public void close() throws IOException {
        if (!this.readerClosed) {
            if (this.bufferedReader != null) {
                this.bufferedReader.close();
            }
            if (this.decompressedStream != null) {
                this.decompressedStream.close();
            }
            this.readerClosed = true;
        }
    }

    protected abstract class BaseTextRecordIterator
    implements FileRecordIterator<InternalRow> {
        protected long currentPosition = 0L;
        protected boolean end = false;

        protected BaseTextRecordIterator() {
        }

        @Override
        public InternalRow next() throws IOException {
            if (BaseTextFileReader.this.readerClosed) {
                return null;
            }
            String nextLine = BaseTextFileReader.this.bufferedReader.readLine();
            if (nextLine == null) {
                this.end = true;
                return null;
            }
            ++this.currentPosition;
            return BaseTextFileReader.this.parseLine(nextLine);
        }

        @Override
        public void releaseBatch() {
        }

        @Override
        public Path filePath() {
            return BaseTextFileReader.this.filePath;
        }

        @Override
        public long returnedPosition() {
            return Math.max(0L, this.currentPosition - 1L);
        }
    }
}

