/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.parquet;

import java.util.ArrayList;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.paimon.data.variant.PaimonShreddingUtils;
import org.apache.paimon.format.parquet.ParquetOptions;
import org.apache.paimon.format.parquet.ParquetSchemaConverter;
import org.apache.paimon.shade.org.apache.parquet.schema.MessageType;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.types.VariantType;
import org.apache.paimon.utils.JsonSerdeUtil;

public class VariantUtils {
    public static RowType[] extractShreddingSchemasFromParquetSchema(DataField[] readFields, MessageType fileSchema) {
        RowType[] shreddingSchemas = new RowType[readFields.length];
        for (int i = 0; i < readFields.length; ++i) {
            RowType shreddingSchema;
            DataField field = readFields[i];
            if (!(field.type() instanceof VariantType) || !fileSchema.getType(field.name()).asGroupType().containsField("typed_value")) continue;
            shreddingSchemas[i] = shreddingSchema = (RowType)ParquetSchemaConverter.convertToPaimonField(fileSchema.getType(field.name())).type();
        }
        return shreddingSchemas;
    }

    @Nullable
    public static RowType shreddingFields(Configuration conf) {
        String shreddingSchema = conf.get(ParquetOptions.PARQUET_VARIANT_SHREDDING_SCHEMA.key(), "");
        if (shreddingSchema.isEmpty()) {
            return null;
        }
        return (RowType)JsonSerdeUtil.fromJson(shreddingSchema, DataType.class);
    }

    @Nullable
    public static RowType extractShreddingSchemaFromConf(Configuration conf, String fieldName) {
        RowType shreddingFields = VariantUtils.shreddingFields(conf);
        if (shreddingFields != null && shreddingFields.containsField(fieldName)) {
            return PaimonShreddingUtils.variantShreddingSchema((RowType)shreddingFields.getField(fieldName).type());
        }
        return null;
    }

    public static RowType replaceWithShreddingType(Configuration conf, RowType rowType) {
        RowType shreddingFields = VariantUtils.shreddingFields(conf);
        if (shreddingFields == null) {
            return rowType;
        }
        ArrayList<DataField> newFields = new ArrayList<DataField>();
        for (DataField field : rowType.getFields()) {
            if (field.type() instanceof VariantType && shreddingFields.containsField(field.name())) {
                RowType shreddingSchema = PaimonShreddingUtils.variantShreddingSchema((RowType)shreddingFields.getField(field.name()).type());
                newFields.add(field.newType(shreddingSchema));
                continue;
            }
            newFields.add(field);
        }
        return new RowType(rowType.isNullable(), newFields);
    }
}

