/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.orc.writer;

import java.util.List;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.format.orc.writer.FieldWriter;
import org.apache.paimon.format.orc.writer.FieldWriterFactory;
import org.apache.paimon.format.orc.writer.Vectorizer;
import org.apache.paimon.shade.org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.paimon.shade.org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.paimon.shade.org.apache.orc.TypeDescription;
import org.apache.paimon.types.DataField;

public class RowDataVectorizer
extends Vectorizer<InternalRow> {
    private final FieldWriter[] fieldWriters;
    private final String[] fieldNames;
    private final boolean[] isNullable;

    public RowDataVectorizer(TypeDescription schema, List<DataField> dataFields, boolean legacyTimestampLtzType) {
        super(schema);
        FieldWriterFactory fieldWriterFactory = new FieldWriterFactory(legacyTimestampLtzType);
        this.fieldWriters = new FieldWriter[dataFields.size()];
        this.fieldNames = new String[dataFields.size()];
        this.isNullable = new boolean[dataFields.size()];
        for (int i = 0; i < dataFields.size(); ++i) {
            DataField field = dataFields.get(i);
            this.fieldWriters[i] = field.type().accept(fieldWriterFactory);
            this.fieldNames[i] = field.name();
            this.isNullable[i] = field.type().isNullable();
        }
    }

    @Override
    public void vectorize(InternalRow row, VectorizedRowBatch batch) {
        int rowId = batch.size++;
        for (int i = 0; i < row.getFieldCount(); ++i) {
            ColumnVector fieldColumn = batch.cols[i];
            if (row.isNullAt(i)) {
                if (!this.isNullable[i]) {
                    throw new IllegalArgumentException(String.format("Field '%s' expected not null but found null value. A possible cause is that the table used %s or %s merge-engine and the aggregate function produced null value when retracting.", this.fieldNames[i], CoreOptions.MergeEngine.PARTIAL_UPDATE, CoreOptions.MergeEngine.AGGREGATE));
                }
                fieldColumn.noNulls = false;
                fieldColumn.isNull[rowId] = true;
                continue;
            }
            this.fieldWriters[i].write(rowId, fieldColumn, row, i);
        }
    }
}

