/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.avro;

import java.util.Map;
import java.util.Optional;
import org.apache.paimon.format.avro.LogicalMap;
import org.apache.paimon.shade.org.apache.avro.LogicalType;
import org.apache.paimon.shade.org.apache.avro.LogicalTypes;
import org.apache.paimon.shade.org.apache.avro.Schema;
import org.apache.paimon.shade.org.apache.avro.SchemaBuilder;
import org.apache.paimon.types.ArrayType;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeRoot;
import org.apache.paimon.types.DecimalType;
import org.apache.paimon.types.IntType;
import org.apache.paimon.types.LocalZonedTimestampType;
import org.apache.paimon.types.MapType;
import org.apache.paimon.types.MultisetType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.types.TimeType;
import org.apache.paimon.types.TimestampType;

public class AvroSchemaConverter {
    private static final String ICEBERG = "iceberg";

    private AvroSchemaConverter() {
    }

    public static Schema convertToSchema(DataType schema, Map<String, String> rowNameMapping) {
        return AvroSchemaConverter.convertToSchema(schema, "org.apache.paimon.avro.generated.record", rowNameMapping);
    }

    public static Schema convertToSchema(DataType dataType, String rowName, Map<String, String> rowNameMapping) {
        if (rowNameMapping.containsKey(rowName)) {
            rowName = rowNameMapping.get(rowName);
        }
        boolean nullable = dataType.isNullable();
        switch (dataType.getTypeRoot()) {
            case BOOLEAN: {
                Schema bool = (Schema)SchemaBuilder.builder().booleanType();
                return nullable ? AvroSchemaConverter.nullableSchema(bool) : bool;
            }
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: {
                Schema integer = (Schema)SchemaBuilder.builder().intType();
                return nullable ? AvroSchemaConverter.nullableSchema(integer) : integer;
            }
            case BIGINT: {
                Schema bigint = (Schema)SchemaBuilder.builder().longType();
                return nullable ? AvroSchemaConverter.nullableSchema(bigint) : bigint;
            }
            case FLOAT: {
                Schema f = (Schema)SchemaBuilder.builder().floatType();
                return nullable ? AvroSchemaConverter.nullableSchema(f) : f;
            }
            case DOUBLE: {
                Schema d = (Schema)SchemaBuilder.builder().doubleType();
                return nullable ? AvroSchemaConverter.nullableSchema(d) : d;
            }
            case CHAR: 
            case VARCHAR: {
                Schema str = (Schema)SchemaBuilder.builder().stringType();
                return nullable ? AvroSchemaConverter.nullableSchema(str) : str;
            }
            case BINARY: 
            case VARBINARY: {
                Schema binary = (Schema)SchemaBuilder.builder().bytesType();
                return nullable ? AvroSchemaConverter.nullableSchema(binary) : binary;
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                LogicalType avroLogicalType;
                TimestampType timestampType = (TimestampType)dataType;
                int precision = timestampType.getPrecision();
                if (precision <= 3) {
                    avroLogicalType = LogicalTypes.timestampMillis();
                } else if (precision <= 6) {
                    avroLogicalType = LogicalTypes.timestampMicros();
                } else {
                    throw new IllegalArgumentException("Avro does not support TIMESTAMP type with precision: " + precision + ", it only supports precision less than 6.");
                }
                Schema timestamp = avroLogicalType.addToSchema((Schema)SchemaBuilder.builder().longType());
                return nullable ? AvroSchemaConverter.nullableSchema(timestamp) : timestamp;
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                LogicalType localTimestampLogicalType;
                LocalZonedTimestampType localTimestampType = (LocalZonedTimestampType)dataType;
                int precision = localTimestampType.getPrecision();
                if (precision <= 3) {
                    localTimestampLogicalType = LogicalTypes.localTimestampMillis();
                } else if (precision <= 6) {
                    localTimestampLogicalType = LogicalTypes.localTimestampMicros();
                } else {
                    throw new IllegalArgumentException("Avro does not support TIMESTAMP type with precision: " + precision + ", it only supports precision less than 6.");
                }
                Schema localTimestampSchema = localTimestampLogicalType.addToSchema((Schema)SchemaBuilder.builder().longType());
                return nullable ? AvroSchemaConverter.nullableSchema(localTimestampSchema) : localTimestampSchema;
            }
            case DATE: {
                Schema date = LogicalTypes.date().addToSchema((Schema)SchemaBuilder.builder().intType());
                return nullable ? AvroSchemaConverter.nullableSchema(date) : date;
            }
            case TIME_WITHOUT_TIME_ZONE: {
                int precision = ((TimeType)dataType).getPrecision();
                if (precision > 3) {
                    throw new IllegalArgumentException("Avro does not support TIME type with precision: " + precision + ", it only supports precision less than 3.");
                }
                Schema time = LogicalTypes.timeMillis().addToSchema((Schema)SchemaBuilder.builder().intType());
                return nullable ? AvroSchemaConverter.nullableSchema(time) : time;
            }
            case DECIMAL: {
                DecimalType decimalType = (DecimalType)dataType;
                Schema decimal = LogicalTypes.decimal(decimalType.getPrecision(), decimalType.getScale()).addToSchema((Schema)SchemaBuilder.builder().bytesType());
                return nullable ? AvroSchemaConverter.nullableSchema(decimal) : decimal;
            }
            case ROW: {
                RowType rowType = (RowType)dataType;
                SchemaBuilder.FieldAssembler builder = SchemaBuilder.builder().record(rowName).fields();
                for (DataField dataField : rowType.getFields()) {
                    String fieldName = dataField.name();
                    DataType fieldType = dataField.type();
                    SchemaBuilder.FieldBuilder name = builder.name(fieldName);
                    if (rowNameMapping.containsKey(ICEBERG)) {
                        name.prop("field-id", dataField.id());
                    }
                    SchemaBuilder.GenericDefault fieldBuilder = name.type(AvroSchemaConverter.convertToSchema(fieldType, rowName + "_" + fieldName, rowNameMapping));
                    if (fieldType.isNullable()) {
                        builder = fieldBuilder.withDefault(null);
                        continue;
                    }
                    builder = fieldBuilder.noDefault();
                }
                Schema record = (Schema)builder.endRecord();
                return nullable ? AvroSchemaConverter.nullableSchema(record) : record;
            }
            case MULTISET: 
            case MAP: {
                Schema map;
                DataType keyType = AvroSchemaConverter.extractKeyTypeToAvroMap(dataType);
                DataType valueType = AvroSchemaConverter.extractValueTypeToAvroMap(dataType);
                if (AvroSchemaConverter.isArrayMap(dataType)) {
                    if (rowNameMapping.containsKey(ICEBERG)) {
                        rowName = Optional.ofNullable(rowNameMapping.get("kv_name_" + rowName)).orElse(rowName);
                    }
                    SchemaBuilder.FieldBuilder key = SchemaBuilder.builder().record(rowName).fields().name("key");
                    if (rowNameMapping.containsKey(ICEBERG)) {
                        Optional.ofNullable(rowNameMapping.get("k_id_" + rowName)).map(Integer::valueOf).ifPresent(fieldId -> {
                            SchemaBuilder.FieldBuilder cfr_ignored_0 = (SchemaBuilder.FieldBuilder)key.prop("field-id", fieldId);
                        });
                    }
                    SchemaBuilder.FieldBuilder value = key.type(AvroSchemaConverter.convertToSchema(keyType, rowName + "_key", rowNameMapping)).noDefault().name("value");
                    if (rowNameMapping.containsKey(ICEBERG)) {
                        Optional.ofNullable(rowNameMapping.get("v_id_" + rowName)).map(Integer::valueOf).ifPresent(fieldId -> {
                            SchemaBuilder.FieldBuilder cfr_ignored_0 = (SchemaBuilder.FieldBuilder)value.prop("field-id", fieldId);
                        });
                    }
                    SchemaBuilder.GenericDefault kvBuilder = value.type(AvroSchemaConverter.convertToSchema(valueType, rowName + "_value", rowNameMapping));
                    SchemaBuilder.FieldAssembler assembler = valueType.isNullable() ? kvBuilder.withDefault(null) : kvBuilder.noDefault();
                    map = (Schema)SchemaBuilder.builder().array().items((Schema)assembler.endRecord());
                    map = LogicalMap.get().addToSchema(map);
                } else {
                    map = (Schema)SchemaBuilder.builder().map().values(AvroSchemaConverter.convertToSchema(valueType, rowName, rowNameMapping));
                }
                return nullable ? AvroSchemaConverter.nullableSchema(map) : map;
            }
            case ARRAY: {
                ArrayType arrayType = (ArrayType)dataType;
                DataType elementType = arrayType.getElementType();
                SchemaBuilder.ArrayBuilder arrayBuilder = SchemaBuilder.builder().array();
                if (rowNameMapping.containsKey(ICEBERG)) {
                    Optional.ofNullable(rowNameMapping.get("array_id_" + rowName)).map(Integer::valueOf).ifPresent(elementId -> {
                        SchemaBuilder.ArrayBuilder cfr_ignored_0 = (SchemaBuilder.ArrayBuilder)arrayBuilder.prop("element-id", elementId);
                    });
                }
                Schema array = (Schema)arrayBuilder.items(AvroSchemaConverter.convertToSchema(elementType, rowName, rowNameMapping));
                return nullable ? AvroSchemaConverter.nullableSchema(array) : array;
            }
        }
        throw new UnsupportedOperationException("Unsupported to derive Schema for type: " + dataType);
    }

    public static boolean isArrayMap(DataType type) {
        DataType keyType = AvroSchemaConverter.extractKeyTypeToAvroMap(type);
        return keyType.getTypeRoot() != DataTypeRoot.VARCHAR && keyType.getTypeRoot() != DataTypeRoot.CHAR;
    }

    public static DataType extractKeyTypeToAvroMap(DataType type) {
        if (type instanceof MapType) {
            MapType mapType = (MapType)type;
            return mapType.getKeyType();
        }
        MultisetType multisetType = (MultisetType)type;
        return multisetType.getElementType();
    }

    public static DataType extractValueTypeToAvroMap(DataType type) {
        if (type instanceof MapType) {
            MapType mapType = (MapType)type;
            return mapType.getValueType();
        }
        return new IntType();
    }

    private static Schema nullableSchema(Schema schema) {
        return schema.isNullable() ? schema : Schema.createUnion((Schema)SchemaBuilder.builder().nullType(), schema);
    }
}

