/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.fileindex.rangebitmap.dictionary.chunked;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Comparator;
import org.apache.paimon.fileindex.rangebitmap.dictionary.Dictionary;
import org.apache.paimon.fileindex.rangebitmap.dictionary.chunked.Chunk;
import org.apache.paimon.fileindex.rangebitmap.dictionary.chunked.KeyFactory;
import org.apache.paimon.fs.SeekableInputStream;
import org.apache.paimon.utils.IOUtils;

public class ChunkedDictionary
implements Dictionary {
    public static final byte CURRENT_VERSION = 1;
    private final int size;
    private final int offsetsLength;
    private final int chunksLength;
    private final int bodyOffset;
    private final SeekableInputStream in;
    private final KeyFactory factory;
    private final Comparator<Object> comparator;
    private final Chunk[] caches;
    private ByteBuffer offsets;
    private ByteBuffer chunks;

    public ChunkedDictionary(SeekableInputStream in, int offset, KeyFactory factory) throws IOException {
        in.seek(offset);
        byte[] headerLengthInBytes = new byte[4];
        IOUtils.readFully((InputStream)in, headerLengthInBytes);
        int headerLength = ByteBuffer.wrap(headerLengthInBytes).getInt();
        byte[] headerInBytes = new byte[headerLength];
        IOUtils.readFully((InputStream)in, headerInBytes);
        ByteBuffer header = ByteBuffer.wrap(headerInBytes);
        byte version = header.get();
        if (version > 1) {
            throw new IllegalArgumentException(String.format("invalid version %d", version));
        }
        this.size = header.getInt();
        this.offsetsLength = header.getInt();
        this.chunksLength = header.getInt();
        this.factory = factory;
        this.comparator = factory.createComparator();
        this.in = in;
        this.bodyOffset = offset + 4 + headerLength;
        this.caches = new Chunk[this.size];
    }

    @Override
    public int find(Object key) {
        int low = 0;
        int high = this.size - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            Chunk found = this.get(mid);
            int result = this.comparator.compare(found.key(), key);
            if (result > 0) {
                high = mid - 1;
                continue;
            }
            if (result < 0) {
                low = mid + 1;
                continue;
            }
            return found.code();
        }
        if (low == 0) {
            return -(low + 1);
        }
        return this.get(low - 1).find(key);
    }

    @Override
    public Object find(int code) {
        if (code < 0) {
            throw new IndexOutOfBoundsException("invalid code: " + code);
        }
        int low = 0;
        int high = this.size - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            Chunk found = this.get(mid);
            int result = Integer.compare(found.code(), code);
            if (result > 0) {
                high = mid - 1;
                continue;
            }
            if (result < 0) {
                low = mid + 1;
                continue;
            }
            return found.key();
        }
        return this.get(low - 1).find(code);
    }

    private Chunk get(int index) {
        if (this.caches[index] != null) {
            return this.caches[index];
        }
        if (this.offsets == null || this.chunks == null) {
            try {
                byte[] bytes = new byte[this.offsetsLength + this.chunksLength];
                this.in.seek(this.bodyOffset);
                IOUtils.readFully((InputStream)this.in, bytes);
                ByteBuffer buffer = ByteBuffer.wrap(bytes);
                this.offsets = (ByteBuffer)buffer.slice().limit(this.offsetsLength);
                buffer.position(this.offsetsLength);
                this.chunks = (ByteBuffer)buffer.slice().limit(this.chunksLength);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.offsets.position(index * 4);
        int offset = this.offsets.getInt();
        this.chunks.position(offset);
        ByteBuffer header = this.offsets.position() == this.offsets.limit() ? (ByteBuffer)this.chunks.slice().limit(this.chunksLength - offset) : (ByteBuffer)this.chunks.slice().limit(this.offsets.getInt() - offset);
        this.caches[index] = this.factory.mmapChunk(header, this.bodyOffset + this.offsetsLength + this.chunksLength, this.in);
        return this.caches[index];
    }

    public static class Appender
    implements Dictionary.Appender {
        public static final byte CURRENT_VERSION = 1;
        private final KeyFactory factory;
        private final Comparator<Object> comparator;
        private final int limitedSerializedSizeInBytes;
        private final ByteArrayOutputStream offsetsBos;
        private final DataOutputStream offsets;
        private final ByteArrayOutputStream chunksBos;
        private final DataOutputStream chunks;
        private final ByteArrayOutputStream keysBos;
        private final DataOutputStream keys;
        private Chunk chunk;
        private int chunksOffset;
        private int keysOffset;
        private int size;
        private Object key;
        private Integer code;

        public Appender(KeyFactory factory, int limitedSerializedSizeInBytes) {
            this.factory = factory;
            this.comparator = factory.createComparator();
            this.limitedSerializedSizeInBytes = limitedSerializedSizeInBytes;
            this.offsetsBos = new ByteArrayOutputStream();
            this.chunksBos = new ByteArrayOutputStream();
            this.keysBos = new ByteArrayOutputStream();
            this.offsets = new DataOutputStream(this.offsetsBos);
            this.chunks = new DataOutputStream(this.chunksBos);
            this.keys = new DataOutputStream(this.keysBos);
            this.chunksOffset = 0;
            this.keysOffset = 0;
        }

        @Override
        public void sortedAppend(Object key, int code) {
            if (key == null) {
                throw new IllegalArgumentException("key should not be null");
            }
            if (this.key != null && this.comparator.compare(this.key, key) >= 0) {
                throw new IllegalArgumentException("key can not out of order");
            }
            this.key = key;
            if (this.code != null && this.code.compareTo(code) >= 0) {
                throw new IllegalArgumentException("code can not out of order");
            }
            this.code = code;
            this.append(key, code);
        }

        @Override
        public byte[] serialize() {
            if (this.chunk != null) {
                this.flush();
            }
            int headerSize = 0;
            ++headerSize;
            headerSize += 4;
            headerSize += 4;
            int bodySize = 0;
            bodySize += this.offsets.size();
            bodySize += this.chunks.size();
            ByteBuffer buffer = ByteBuffer.allocate(4 + (headerSize += 4) + (bodySize += this.keys.size()));
            buffer.putInt(headerSize);
            buffer.put((byte)1);
            buffer.putInt(this.size);
            buffer.putInt(this.offsets.size());
            buffer.putInt(this.chunks.size());
            buffer.put(this.offsetsBos.toByteArray());
            buffer.put(this.chunksBos.toByteArray());
            buffer.put(this.keysBos.toByteArray());
            return buffer.array();
        }

        private void append(Object key, int code) {
            if (this.chunk == null) {
                this.chunk = this.factory.createChunk(key, code, this.keysOffset, this.limitedSerializedSizeInBytes);
            } else {
                if (this.chunk.tryAdd(key)) {
                    return;
                }
                this.flush();
                this.chunk = this.factory.createChunk(key, code, this.keysOffset, this.limitedSerializedSizeInBytes);
            }
        }

        private void flush() {
            try {
                byte[] chunkInBytes = this.chunk.serializeChunk();
                byte[] keysInBytes = this.chunk.serializeKeys();
                this.offsets.writeInt(this.chunksOffset);
                this.chunksOffset += chunkInBytes.length;
                this.keysOffset += keysInBytes.length;
                this.chunks.write(chunkInBytes);
                this.keys.write(keysInBytes);
                ++this.size;
                this.chunk = null;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

