/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.deletionvectors;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.paimon.deletionvectors.Bitmap64DeletionVector;
import org.apache.paimon.deletionvectors.BitmapDeletionVector;
import org.apache.paimon.deletionvectors.BucketedDvMaintainer;
import org.apache.paimon.deletionvectors.DeletionVectorJudger;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.fs.SeekableInputStream;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.table.source.DeletionFile;

public interface DeletionVector
extends DeletionVectorJudger {
    public void delete(long var1);

    public void merge(DeletionVector var1);

    default public boolean checkedDelete(long position) {
        if (this.isDeleted(position)) {
            return false;
        }
        this.delete(position);
        return true;
    }

    public boolean isEmpty();

    public long getCardinality();

    public int serializeTo(DataOutputStream var1) throws IOException;

    public static DeletionVector read(FileIO fileIO, DeletionFile deletionFile) throws IOException {
        Path path = new Path(deletionFile.path());
        try (SeekableInputStream input = fileIO.newInputStream(path);){
            input.seek(deletionFile.offset());
            DataInputStream dis = new DataInputStream(input);
            DeletionVector deletionVector = DeletionVector.read(dis, deletionFile.length());
            return deletionVector;
        }
    }

    public static DeletionVector read(DataInputStream dis, @Nullable Long length) throws IOException {
        int bitmapLength = dis.readInt();
        int magicNumber = dis.readInt();
        if (magicNumber == 1581511376) {
            if (length != null && (long)bitmapLength != length) {
                throw new RuntimeException("Size not match, actual size: " + bitmapLength + ", expected size: " + length);
            }
            byte[] bytes = new byte[bitmapLength - 4];
            dis.readFully(bytes);
            dis.skipBytes(4);
            return BitmapDeletionVector.deserializeFromByteBuffer(ByteBuffer.wrap(bytes));
        }
        if (Bitmap64DeletionVector.toLittleEndianInt(magicNumber) == 1681511377) {
            long expectedBitmapLength;
            if (length != null && (long)bitmapLength != (expectedBitmapLength = length - 4L - 4L)) {
                throw new RuntimeException("Size not match, actual size: " + bitmapLength + ", expected size: " + expectedBitmapLength);
            }
            byte[] bytes = new byte[bitmapLength - 4];
            dis.readFully(bytes);
            dis.skipBytes(4);
            return Bitmap64DeletionVector.deserializeFromBitmapDataBytes(bytes);
        }
        throw new RuntimeException("Invalid magic number: " + magicNumber + ", v1 dv magic number: " + 1581511376 + ", v2 magic number: " + 1681511377);
    }

    public static Factory emptyFactory() {
        return fileName -> Optional.empty();
    }

    public static Factory factory(@Nullable BucketedDvMaintainer dvMaintainer) {
        if (dvMaintainer == null) {
            return DeletionVector.emptyFactory();
        }
        return dvMaintainer::deletionVectorOf;
    }

    public static Factory factory(FileIO fileIO, List<DataFileMeta> files, @Nullable List<DeletionFile> deletionFiles) {
        DeletionFile.Factory factory = DeletionFile.factory(files, deletionFiles);
        return fileName -> {
            Optional<DeletionFile> deletionFile = factory.create(fileName);
            if (deletionFile.isPresent()) {
                return Optional.of(DeletionVector.read(fileIO, deletionFile.get()));
            }
            return Optional.empty();
        };
    }

    public static byte[] serializeToBytes(DeletionVector deletionVector) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            deletionVector.serializeTo(dos);
            return bos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static DeletionVector deserializeFromBytes(byte[] bytes) {
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        DataInputStream dis = new DataInputStream(bis);
        try {
            return DeletionVector.read(dis, null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static interface Factory {
        public Optional<DeletionVector> create(String var1) throws IOException;
    }
}

