/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.data;

import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.paimon.data.AbstractPagedOutputView;
import org.apache.paimon.memory.MemorySegment;
import org.apache.paimon.memory.MemorySegmentSource;
import org.apache.paimon.utils.MathUtils;

public class SimpleCollectingOutputView
extends AbstractPagedOutputView {
    private final ArrayList<MemorySegment> fullSegments;
    private final MemorySegmentSource memorySource;
    private final int segmentSizeBits;
    private int segmentNum;

    public SimpleCollectingOutputView(MemorySegmentSource memSource, int segmentSize) {
        this(new ArrayList<MemorySegment>(), memSource, segmentSize);
    }

    public SimpleCollectingOutputView(ArrayList<MemorySegment> fullSegmentTarget, MemorySegmentSource memSource, int segmentSize) {
        super(memSource.nextSegment(), segmentSize);
        this.segmentSizeBits = MathUtils.log2strict(segmentSize);
        this.fullSegments = fullSegmentTarget;
        this.memorySource = memSource;
        this.fullSegments.add(this.getCurrentSegment());
    }

    public ArrayList<MemorySegment> fullSegments() {
        return this.fullSegments;
    }

    public void reset() {
        if (!this.fullSegments.isEmpty()) {
            throw new IllegalStateException("The target list still contains memory segments.");
        }
        this.clear();
        try {
            this.advance();
        }
        catch (IOException ioex) {
            throw new RuntimeException("Error getting first segment for record collector.", ioex);
        }
        this.segmentNum = 0;
    }

    @Override
    protected MemorySegment nextSegment(MemorySegment current, int positionInCurrent) throws EOFException {
        MemorySegment next = this.memorySource.nextSegment();
        if (next != null) {
            this.fullSegments.add(next);
            ++this.segmentNum;
            return next;
        }
        throw new EOFException("Can't collect further: memorySource depleted");
    }

    public long getCurrentOffset() {
        return ((long)this.segmentNum << this.segmentSizeBits) + (long)this.getCurrentPositionInSegment();
    }
}

