/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.append;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.deletionvectors.append.AppendDeleteFileMaintainer;
import org.apache.paimon.deletionvectors.append.BaseAppendDeleteFileMaintainer;
import org.apache.paimon.index.IndexFileMeta;
import org.apache.paimon.io.CompactIncrement;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.io.DataIncrement;
import org.apache.paimon.manifest.FileKind;
import org.apache.paimon.manifest.IndexManifestEntry;
import org.apache.paimon.operation.BaseAppendFileStoreWrite;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.sink.CommitMessage;
import org.apache.paimon.table.sink.CommitMessageImpl;
import org.apache.paimon.utils.Preconditions;

public class AppendCompactTask {
    private final BinaryRow partition;
    private final List<DataFileMeta> compactBefore;
    private final List<DataFileMeta> compactAfter;

    public AppendCompactTask(BinaryRow partition, List<DataFileMeta> files) {
        Preconditions.checkArgument(files != null);
        this.partition = partition;
        this.compactBefore = new ArrayList<DataFileMeta>(files);
        this.compactAfter = new ArrayList<DataFileMeta>();
    }

    public BinaryRow partition() {
        return this.partition;
    }

    public List<DataFileMeta> compactBefore() {
        return this.compactBefore;
    }

    public List<DataFileMeta> compactAfter() {
        return this.compactAfter;
    }

    public CommitMessage doCompact(FileStoreTable table, BaseAppendFileStoreWrite write) throws Exception {
        boolean dvEnabled = table.coreOptions().deletionVectorsEnabled();
        Preconditions.checkArgument(dvEnabled || this.compactBefore.size() > 1, "AppendOnlyCompactionTask need more than one file input.");
        ArrayList<IndexFileMeta> newIndexFiles = new ArrayList<IndexFileMeta>();
        ArrayList<IndexFileMeta> deletedIndexFiles = new ArrayList<IndexFileMeta>();
        if (dvEnabled) {
            AppendDeleteFileMaintainer dvIndexFileMaintainer = BaseAppendDeleteFileMaintainer.forUnawareAppend(table.store().newIndexFileHandler(), table.snapshotManager().latestSnapshot(), this.partition);
            this.compactAfter.addAll(write.compactRewrite(this.partition, 0, dvIndexFileMaintainer::getDeletionVector, this.compactBefore));
            this.compactBefore.forEach(f -> dvIndexFileMaintainer.notifyRemovedDeletionVector(f.fileName()));
            List<IndexManifestEntry> indexEntries = dvIndexFileMaintainer.persist();
            for (IndexManifestEntry entry : indexEntries) {
                if (entry.kind() == FileKind.ADD) {
                    newIndexFiles.add(entry.indexFile());
                    continue;
                }
                deletedIndexFiles.add(entry.indexFile());
            }
        } else {
            this.compactAfter.addAll(write.compactRewrite(this.partition, 0, null, this.compactBefore));
        }
        CompactIncrement compactIncrement = new CompactIncrement(this.compactBefore, this.compactAfter, Collections.emptyList(), newIndexFiles, deletedIndexFiles);
        return new CommitMessageImpl(this.partition, 0, table.coreOptions().bucket(), DataIncrement.emptyIncrement(), compactIncrement);
    }

    public int hashCode() {
        return Objects.hash(this.partition, this.compactBefore, this.compactAfter);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AppendCompactTask that = (AppendCompactTask)o;
        return Objects.equals(this.partition, that.partition) && Objects.equals(this.compactBefore, that.compactBefore) && Objects.equals(this.compactAfter, that.compactAfter);
    }

    public String toString() {
        return String.format("CompactionTask {partition = %s, compactBefore = %s, compactAfter = %s}", this.partition, this.compactBefore, this.compactAfter);
    }
}

