/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.rest.interceptor;

import java.net.URISyntaxException;
import org.apache.paimon.shade.hc.core5.http.EntityDetails;
import org.apache.paimon.shade.hc.core5.http.HttpRequest;
import org.apache.paimon.shade.hc.core5.http.HttpResponse;
import org.apache.paimon.shade.hc.core5.http.HttpResponseInterceptor;
import org.apache.paimon.shade.hc.core5.http.protocol.HttpContext;
import org.apache.paimon.shade.hc.core5.http.protocol.HttpCoreContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingInterceptor
implements HttpResponseInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(LoggingInterceptor.class);
    public static final String REQUEST_ID_KEY = "x-request-id";
    public static final String DEFAULT_REQUEST_ID = "unknown";
    public static final String REQUEST_START_TIME_KEY = "request-start-time";

    @Override
    public void process(HttpResponse httpResponse, EntityDetails entityDetails, HttpContext httpContext) {
        HttpCoreContext coreContext = HttpCoreContext.adapt(httpContext);
        HttpRequest request = coreContext.getRequest();
        Long startTime = (Long)coreContext.getAttribute(REQUEST_START_TIME_KEY);
        long durationMs = System.currentTimeMillis() - startTime;
        String requestId = httpResponse.getHeaders(REQUEST_ID_KEY).length > 0 ? httpResponse.getFirstHeader(REQUEST_ID_KEY).getValue() : DEFAULT_REQUEST_ID;
        try {
            LOG.info("[rest] requestId:{} method:{} url:{} duration:{}ms", new Object[]{requestId, request.getMethod(), request.getUri(), durationMs});
        }
        catch (URISyntaxException e) {
            LOG.warn("Failed to log rest request: {}", (Object)e.getMessage());
        }
    }
}

