/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.utils;

import java.util.Map;

public class Filter {
    private FilterOperator operator;
    private Object value;
    private Map<String, Filter> nextLevel = null;

    public Filter() {
        this.operator = null;
        this.value = null;
    }

    public Filter(FilterOperator operator, Object value) {
        this.operator = operator;
        this.value = value;
    }

    public Filter(String op, Object value) {
        this.operator = this.getFilterOperator(op);
        this.value = value;
    }

    public Filter(FilterOperator operator, Object value, Map<String, Filter> next) {
        this.operator = operator;
        this.value = value;
        this.nextLevel = next;
    }

    public Filter(String op, Object value, Map<String, Filter> next) {
        this.operator = this.getFilterOperator(op);
        this.value = value;
        this.nextLevel = next;
    }

    public FilterOperator getOperator() {
        return this.operator;
    }

    public void setOperator(FilterOperator operator) {
        this.operator = operator;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Map<String, Filter> getNextLevel() {
        return this.nextLevel;
    }

    public void setNextLevel(Map<String, Filter> nextLevel) {
        this.nextLevel = nextLevel;
    }

    public FilterOperator getFilterOperator(String op) {
        if (op.equalsIgnoreCase("equals")) {
            return FilterOperator.EQUALS;
        }
        if (op.equalsIgnoreCase("GREATER")) {
            return FilterOperator.GREATER;
        }
        if (op.equalsIgnoreCase("LESSER")) {
            return FilterOperator.LESSER;
        }
        if (op.equalsIgnoreCase("REGEX")) {
            return FilterOperator.REGEX;
        }
        return null;
    }

    public String toString() {
        return "(" + (Object)((Object)this.operator) + "," + this.value + "," + this.nextLevel + ")";
    }

    public static enum FilterOperator {
        EQUALS,
        LESSER,
        GREATER,
        REGEX;

    }
}

