/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.debug.replicas.chunk;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.client.ECReplicationConfig;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.XceiverClientManager;
import org.apache.hadoop.hdds.scm.XceiverClientSpi;
import org.apache.hadoop.hdds.scm.cli.ContainerOperationClient;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.storage.ContainerProtocolCalls;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.container.common.impl.ContainerLayoutVersion;
import org.apache.hadoop.ozone.debug.replicas.chunk.ChunkType;
import org.apache.hadoop.ozone.om.helpers.OmKeyArgs;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.om.protocol.OzoneManagerProtocol;
import org.apache.hadoop.ozone.shell.OzoneAddress;
import org.apache.hadoop.ozone.shell.keys.KeyHandler;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.StringUtils;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import picocli.CommandLine;

@CommandLine.Command(name="chunk-info", description={"Returns chunk location information about an existing key"})
public class ChunkKeyHandler
extends KeyHandler {
    private String getChunkLocationPath(String containerLocation) {
        return containerLocation + File.separator + "chunks";
    }

    protected void execute(OzoneClient client, OzoneAddress address) throws IOException {
        try (ContainerOperationClient containerOperationClient = new ContainerOperationClient(this.getOzoneConf());
             XceiverClientManager xceiverClientManager = containerOperationClient.getXceiverClientManager();){
            List locationInfos;
            OzoneManagerProtocol ozoneManagerClient = client.getObjectStore().getClientProxy().getOzoneManagerClient();
            address.ensureKeyAddress();
            String volumeName = address.getVolumeName();
            String bucketName = address.getBucketName();
            String keyName = address.getKeyName();
            OmKeyArgs keyArgs = new OmKeyArgs.Builder().setVolumeName(volumeName).setBucketName(bucketName).setKeyName(keyName).build();
            OmKeyInfo keyInfo = ozoneManagerClient.lookupKey(keyArgs);
            List list = locationInfos = keyInfo.getLatestVersionLocations() != null ? keyInfo.getLatestVersionLocations().getBlocksLatestVersionOnly() : null;
            if (locationInfos == null) {
                System.err.println("No replica/s found.");
                return;
            }
            if (locationInfos.isEmpty()) {
                System.err.println("No key locations found.");
                return;
            }
            ContainerLayoutVersion containerLayoutVersion = ContainerLayoutVersion.getConfiguredVersion((ConfigurationSource)this.getConf());
            ObjectMapper mapper = new ObjectMapper();
            JsonFactory jsonFactory = mapper.getFactory();
            try (JsonGenerator jsonGen = jsonFactory.createGenerator((OutputStream)System.out);){
                jsonGen.useDefaultPrettyPrinter();
                jsonGen.writeStartObject();
                jsonGen.writeStringField("volumeName", volumeName);
                jsonGen.writeStringField("bucketName", bucketName);
                jsonGen.writeStringField("name", keyName);
                jsonGen.writeArrayFieldStart("keyLocations");
                for (OmKeyLocationInfo keyLocation : locationInfos) {
                    jsonGen.writeStartArray();
                    Pipeline keyPipeline = keyLocation.getPipeline();
                    boolean isECKey = keyPipeline.getReplicationConfig().getReplicationType() == HddsProtos.ReplicationType.EC;
                    Pipeline pipeline = !isECKey && keyPipeline.getType() != HddsProtos.ReplicationType.STAND_ALONE ? keyPipeline.copyForRead() : keyPipeline;
                    XceiverClientSpi xceiverClient = xceiverClientManager.acquireClientForReadData(pipeline);
                    try {
                        Map readContainerResponses = containerOperationClient.readContainerFromAllNodes(keyLocation.getContainerID(), pipeline);
                        for (DatanodeDetails datanodeDetails : pipeline.getNodes()) {
                            try {
                                ContainerProtos.GetBlockResponseProto blockResponse = ContainerProtocolCalls.getBlock((XceiverClientSpi)xceiverClient, (BlockID)keyLocation.getBlockID(), (Token)keyLocation.getToken(), (Map)pipeline.getReplicaIndexes());
                                if (blockResponse == null || !blockResponse.hasBlockData()) {
                                    System.err.printf("GetBlock call failed on %s datanode and %s block.%n", datanodeDetails.getHostName(), keyLocation.getBlockID());
                                    continue;
                                }
                                ContainerProtos.BlockData blockData = blockResponse.getBlockData();
                                ContainerProtos.ChunkInfo chunkInfo = blockData.getChunksCount() > 0 ? blockData.getChunks(0) : null;
                                String fileName = "";
                                if (chunkInfo != null) {
                                    ContainerProtos.ContainerDataProto containerData = ((ContainerProtos.ReadContainerResponseProto)readContainerResponses.get(datanodeDetails)).getContainerData();
                                    fileName = containerLayoutVersion.getChunkFile(new File(this.getChunkLocationPath(containerData.getContainerPath())), keyLocation.getBlockID(), chunkInfo.getChunkName()).toString();
                                }
                                jsonGen.writeStartObject();
                                jsonGen.writeObjectFieldStart("datanode");
                                jsonGen.writeStringField("hostname", datanodeDetails.getHostName());
                                jsonGen.writeStringField("ip", datanodeDetails.getIpAddress());
                                jsonGen.writeStringField("uuid", datanodeDetails.getUuidString());
                                jsonGen.writeEndObject();
                                jsonGen.writeStringField("file", fileName);
                                jsonGen.writeObjectFieldStart("blockData");
                                jsonGen.writeObjectFieldStart("blockID");
                                jsonGen.writeNumberField("containerID", blockData.getBlockID().getContainerID());
                                jsonGen.writeNumberField("localID", blockData.getBlockID().getLocalID());
                                jsonGen.writeNumberField("blockCommitSequenceId", blockData.getBlockID().getBlockCommitSequenceId());
                                jsonGen.writeEndObject();
                                jsonGen.writeNumberField("size", blockData.getSize());
                                jsonGen.writeArrayFieldStart("chunks");
                                for (ContainerProtos.ChunkInfo chunk : blockData.getChunksList()) {
                                    jsonGen.writeStartObject();
                                    jsonGen.writeNumberField("offset", chunk.getOffset());
                                    jsonGen.writeNumberField("len", chunk.getLen());
                                    if (chunk.hasChecksumData()) {
                                        jsonGen.writeArrayFieldStart("checksums");
                                        for (ByteString bs : chunk.getChecksumData().getChecksumsList()) {
                                            jsonGen.writeString(StringUtils.byteToHexString((byte[])bs.toByteArray()));
                                        }
                                        jsonGen.writeEndArray();
                                        jsonGen.writeStringField("checksumType", chunk.getChecksumData().getType().name());
                                        jsonGen.writeNumberField("bytesPerChecksum", chunk.getChecksumData().getBytesPerChecksum());
                                    }
                                    if (chunk.hasStripeChecksum()) {
                                        byte[] stripeBytes = chunk.getStripeChecksum().toByteArray();
                                        int checksumLen = ((ByteString)chunk.getChecksumData().getChecksumsList().get(0)).size();
                                        jsonGen.writeArrayFieldStart("stripeChecksum");
                                        for (int i = 0; i <= stripeBytes.length - checksumLen; i += checksumLen) {
                                            byte[] slice = Arrays.copyOfRange(stripeBytes, i, i + checksumLen);
                                            jsonGen.writeString(StringUtils.byteToHexString((byte[])slice));
                                        }
                                        jsonGen.writeEndArray();
                                    }
                                    jsonGen.writeEndObject();
                                }
                                jsonGen.writeEndArray();
                                jsonGen.writeEndObject();
                                if (isECKey) {
                                    int dataCount;
                                    int replicaIndex = keyPipeline.getReplicaIndex(datanodeDetails);
                                    ChunkType chunkType = replicaIndex > (dataCount = ((ECReplicationConfig)keyPipeline.getReplicationConfig()).getData()) ? ChunkType.PARITY : ChunkType.DATA;
                                    jsonGen.writeStringField("chunkType", chunkType.name());
                                    jsonGen.writeNumberField("replicaIndex", replicaIndex);
                                }
                                jsonGen.writeEndObject();
                                jsonGen.flush();
                            }
                            catch (Exception e) {
                                System.err.printf("Error getting block from datanode %s: %s%n", datanodeDetails.getHostName(), e.getMessage());
                            }
                        }
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    finally {
                        xceiverClientManager.releaseClientForReadData(xceiverClient, false);
                    }
                    jsonGen.writeEndArray();
                }
                jsonGen.writeEndArray();
                jsonGen.writeEndObject();
                jsonGen.flush();
                System.out.println();
            }
        }
    }
}

