/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.debug;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.scm.metadata.SCMDBDefinition;
import org.apache.hadoop.hdds.utils.db.DBDefinition;
import org.apache.hadoop.ozone.container.metadata.DatanodeSchemaOneDBDefinition;
import org.apache.hadoop.ozone.container.metadata.DatanodeSchemaThreeDBDefinition;
import org.apache.hadoop.ozone.container.metadata.DatanodeSchemaTwoDBDefinition;
import org.apache.hadoop.ozone.container.metadata.WitnessedContainerDBDefinition;
import org.apache.hadoop.ozone.om.codec.OMDBDefinition;
import org.apache.hadoop.ozone.recon.scm.ReconSCMDBDefinition;
import org.apache.hadoop.ozone.recon.spi.impl.ReconDBDefinition;

public final class DBDefinitionFactory {
    private static final AtomicReference<String> DATANODE_DB_SCHEMA_VERSION = new AtomicReference();
    private static final Map<String, DBDefinition> DB_MAP;

    private DBDefinitionFactory() {
    }

    public static DBDefinition getDefinition(String dbName) {
        DBDefinition definition;
        if (!dbName.equals("om.db") && dbName.startsWith("om.db")) {
            dbName = "om.db";
        }
        return (definition = DB_MAP.get(dbName)) != null ? definition : DBDefinitionFactory.getReconDBDefinition(dbName);
    }

    public static DBDefinition getDefinition(Path path, ConfigurationSource config) {
        Path dbPath = Objects.requireNonNull(path, "path == null");
        Path fileName = dbPath.getFileName();
        if (fileName == null) {
            throw new IllegalArgumentException("DB path has no filename");
        }
        String dbName = fileName.toString();
        if (dbName.endsWith("container.db")) {
            switch (DATANODE_DB_SCHEMA_VERSION.get()) {
                case "V1": {
                    return new DatanodeSchemaOneDBDefinition(dbPath.toAbsolutePath().toString(), config);
                }
                case "V3": {
                    return new DatanodeSchemaThreeDBDefinition(dbPath.toAbsolutePath().toString(), config);
                }
            }
            return new DatanodeSchemaTwoDBDefinition(dbPath.toAbsolutePath().toString(), config);
        }
        return DBDefinitionFactory.getDefinition(dbName);
    }

    private static DBDefinition getReconDBDefinition(String dbName) {
        if (dbName.startsWith("recon-container-key.db")) {
            return new ReconDBDefinition(dbName);
        }
        if (dbName.startsWith("om.snapshot.db")) {
            return OMDBDefinition.get();
        }
        return null;
    }

    public static void setDnDBSchemaVersion(String dnDBSchemaVersion) {
        DATANODE_DB_SCHEMA_VERSION.set(dnDBSchemaVersion);
    }

    static {
        HashMap map = new HashMap();
        Arrays.asList(SCMDBDefinition.get(), OMDBDefinition.get(), ReconSCMDBDefinition.get(), WitnessedContainerDBDefinition.get()).forEach(dbDefinition -> map.put(dbDefinition.getName(), dbDefinition));
        DB_MAP = Collections.unmodifiableMap(map);
    }
}

