/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shell.checknative;

import java.util.Collections;
import java.util.concurrent.Callable;
import org.apache.hadoop.hdds.cli.GenericCli;
import org.apache.hadoop.hdds.utils.NativeLibraryLoader;
import org.apache.hadoop.hdds.utils.db.managed.ManagedRocksObjectUtils;
import org.apache.hadoop.io.erasurecode.ErasureCodeNative;
import org.apache.hadoop.util.NativeCodeLoader;
import picocli.CommandLine;

@CommandLine.Command(name="ozone checknative", description={"Checks if native libraries are loaded"})
public class CheckNative
extends GenericCli
implements Callable<Void> {
    public static void main(String[] argv) {
        new CheckNative().run(argv);
    }

    @Override
    public Void call() throws Exception {
        boolean nativeHadoopLoaded = NativeCodeLoader.isNativeCodeLoaded();
        String hadoopLibraryName = "";
        String isalDetail = "";
        boolean isalLoaded = false;
        if (nativeHadoopLoaded) {
            hadoopLibraryName = NativeCodeLoader.getLibraryName();
            isalDetail = ErasureCodeNative.getLoadingFailureReason();
            if (isalDetail != null) {
                isalLoaded = false;
            } else {
                isalDetail = ErasureCodeNative.getLibraryName();
                isalLoaded = true;
            }
        }
        this.out().println("Native library checking:");
        this.out().printf("hadoop:  %b %s%n", nativeHadoopLoaded, hadoopLibraryName);
        this.out().printf("ISA-L:   %b %s%n", isalLoaded, isalDetail);
        boolean nativeRocksToolsLoaded = NativeLibraryLoader.getInstance().loadLibrary("ozone_rocksdb_tools", Collections.singletonList(ManagedRocksObjectUtils.getRocksDBLibFileName()));
        String rocksToolsDetail = "";
        if (nativeRocksToolsLoaded) {
            rocksToolsDetail = NativeLibraryLoader.getJniLibraryFileName();
        }
        this.out().printf("rocks-tools: %b %s%n", nativeRocksToolsLoaded, rocksToolsDetail);
        return null;
    }
}

