/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.repair.om;

import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.apache.hadoop.hdds.utils.IOUtils;
import org.apache.hadoop.hdds.utils.db.StringCodec;
import org.apache.hadoop.hdds.utils.db.managed.ManagedRocksDB;
import org.apache.hadoop.hdds.utils.db.managed.ManagedRocksIterator;
import org.apache.hadoop.ozone.debug.RocksDBUtils;
import org.apache.hadoop.ozone.om.helpers.SnapshotInfo;
import org.apache.hadoop.ozone.repair.RepairTool;
import org.apache.hadoop.ozone.shell.bucket.BucketUri;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="chain", description={"CLI to update global and path previous snapshot for a snapshot in case snapshot chain is corrupted."})
public class SnapshotChainRepair
extends RepairTool {
    protected static final Logger LOG = LoggerFactory.getLogger(SnapshotChainRepair.class);
    @CommandLine.Mixin
    private BucketUri bucketUri;
    @CommandLine.Parameters(description={"Snapshot name to update"}, index="1")
    private String snapshotName;
    @CommandLine.Option(names={"--db"}, required=true, description={"Database File Path"})
    private String dbPath;
    @CommandLine.Option(names={"--global-previous", "--gp"}, required=true, description={"Global previous snapshotId to set for the given snapshot"})
    private UUID globalPreviousSnapshotId;
    @CommandLine.Option(names={"--path-previous", "--pp"}, required=true, description={"Path previous snapshotId to set for the given snapshot"})
    private UUID pathPreviousSnapshotId;

    @Override
    @Nonnull
    protected RepairTool.Component serviceToBeOffline() {
        return RepairTool.Component.OM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void execute() throws Exception {
        ArrayList<ColumnFamilyHandle> cfHandleList = new ArrayList<ColumnFamilyHandle>();
        List<ColumnFamilyDescriptor> cfDescList = RocksDBUtils.getColumnFamilyDescriptors(this.dbPath);
        try (ManagedRocksDB db = ManagedRocksDB.open((String)this.dbPath, cfDescList, cfHandleList);){
            ColumnFamilyHandle snapshotInfoCfh = RocksDBUtils.getColumnFamilyHandle("snapshotInfoTable", cfHandleList);
            if (snapshotInfoCfh == null) {
                this.error("%s is not in a column family in DB for the given path.", "snapshotInfoTable");
                return;
            }
            String snapshotInfoTableKey = SnapshotInfo.getTableKey((String)this.bucketUri.getValue().getVolumeName(), (String)this.bucketUri.getValue().getBucketName(), (String)this.snapshotName);
            SnapshotInfo snapshotInfo = (SnapshotInfo)RocksDBUtils.getValue(db, snapshotInfoCfh, snapshotInfoTableKey, SnapshotInfo.getCodec());
            if (snapshotInfo == null) {
                this.error("%s does not exist for given bucketUri: %s", this.snapshotName, "/" + this.bucketUri.getValue().getVolumeName() + "/" + this.bucketUri.getValue().getBucketName());
                return;
            }
            Set<UUID> snapshotIdSet = this.getSnapshotIdSet(db, snapshotInfoCfh);
            if (Objects.equals(snapshotInfo.getSnapshotId(), this.globalPreviousSnapshotId)) {
                this.error("globalPreviousSnapshotId: '%s' is equal to given snapshot's ID: '%s'.", this.globalPreviousSnapshotId, snapshotInfo.getSnapshotId());
                return;
            }
            if (Objects.equals(snapshotInfo.getSnapshotId(), this.pathPreviousSnapshotId)) {
                this.error("pathPreviousSnapshotId: '%s' is equal to given snapshot's ID: '%s'.", this.pathPreviousSnapshotId, snapshotInfo.getSnapshotId());
                return;
            }
            if (!snapshotIdSet.contains(this.globalPreviousSnapshotId)) {
                this.error("globalPreviousSnapshotId: '%s' does not exist in snapshotInfoTable.", this.globalPreviousSnapshotId);
                return;
            }
            if (!snapshotIdSet.contains(this.pathPreviousSnapshotId)) {
                this.error("pathPreviousSnapshotId: '%s' does not exist in snapshotInfoTable.", this.pathPreviousSnapshotId);
                return;
            }
            snapshotInfo.setGlobalPreviousSnapshotId(this.globalPreviousSnapshotId);
            snapshotInfo.setPathPreviousSnapshotId(this.pathPreviousSnapshotId);
            this.info("Updating SnapshotInfo to %s", snapshotInfo);
            byte[] snapshotInfoBytes = SnapshotInfo.getCodec().toPersistedFormat((Object)snapshotInfo);
            byte[] persistedFormat = StringCodec.get().toPersistedFormat(snapshotInfoTableKey);
            if (this.isDryRun()) return;
            ((RocksDB)db.get()).put(snapshotInfoCfh, persistedFormat, snapshotInfoBytes);
            this.info("Snapshot Info is updated to : %s", RocksDBUtils.getValue(db, snapshotInfoCfh, snapshotInfoTableKey, SnapshotInfo.getCodec()));
            return;
        }
        catch (RocksDBException exception) {
            this.error("Failed to update the RocksDB for the given path: %s", this.dbPath);
            this.error("Make sure that Ozone entity (OM, SCM or DN) is not running for the give dbPath and current host.", new Object[0]);
            LOG.error(exception.toString());
            return;
        }
        finally {
            IOUtils.closeQuietly(cfHandleList);
        }
    }

    private Set<UUID> getSnapshotIdSet(ManagedRocksDB db, ColumnFamilyHandle snapshotInfoCfh) throws IOException {
        HashSet<UUID> snapshotIdSet = new HashSet<UUID>();
        try (ManagedRocksIterator iterator = new ManagedRocksIterator(((RocksDB)db.get()).newIterator(snapshotInfoCfh));){
            ((RocksIterator)iterator.get()).seekToFirst();
            while (((RocksIterator)iterator.get()).isValid()) {
                SnapshotInfo snapshotInfo = (SnapshotInfo)SnapshotInfo.getCodec().fromPersistedFormat(((RocksIterator)iterator.get()).value());
                snapshotIdSet.add(snapshotInfo.getSnapshotId());
                ((RocksIterator)iterator.get()).next();
            }
        }
        return snapshotIdSet;
    }
}

