/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.recon.schema;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.ozone.recon.schema.ReconSchemaDefinition;
import org.apache.ozone.recon.schema.SqlDbUtils;
import org.jooq.Constraint;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;

@Singleton
public class ReconTaskSchemaDefinition
implements ReconSchemaDefinition {
    public static final String RECON_TASK_STATUS_TABLE_NAME = "RECON_TASK_STATUS";
    private final DataSource dataSource;

    @Inject
    ReconTaskSchemaDefinition(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public void initializeSchema() throws SQLException {
        Connection conn = this.dataSource.getConnection();
        if (!SqlDbUtils.TABLE_EXISTS_CHECK.test(conn, RECON_TASK_STATUS_TABLE_NAME)) {
            this.createReconTaskStatusTable(conn);
        }
    }

    private void createReconTaskStatusTable(Connection conn) {
        DSL.using((Connection)conn).createTableIfNotExists(RECON_TASK_STATUS_TABLE_NAME).column("task_name", SQLDataType.VARCHAR((int)766).nullable(false)).column("last_updated_timestamp", SQLDataType.BIGINT).column("last_updated_seq_number", SQLDataType.BIGINT).column("last_task_run_status", SQLDataType.INTEGER).column("is_current_task_running", SQLDataType.INTEGER).constraint((Constraint)DSL.constraint((String)"pk_task_name").primaryKey(new String[]{"task_name"})).execute();
    }
}

