/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.key;

import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.response.CleanupTableInfo;
import org.apache.hadoop.ozone.om.response.key.AbstractOMKeyDeleteResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

@CleanupTableInfo(cleanupTables={"openKeyTable", "openFileTable", "deletedTable", "bucketTable"})
public class OMOpenKeysDeleteResponse
extends AbstractOMKeyDeleteResponse {
    private Map<String, OmKeyInfo> keysToDelete;

    public OMOpenKeysDeleteResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, @Nonnull Map<String, OmKeyInfo> keysToDelete, @Nonnull BucketLayout bucketLayout) {
        super(omResponse, bucketLayout);
        this.keysToDelete = keysToDelete;
    }

    public OMOpenKeysDeleteResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, @Nonnull BucketLayout bucketLayout) {
        super(omResponse, bucketLayout);
        this.checkStatusNotOK();
    }

    @Override
    public void addToDBBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        Table openKeyTable = omMetadataManager.getOpenKeyTable(this.getBucketLayout());
        for (Map.Entry<String, OmKeyInfo> keyInfoPair : this.keysToDelete.entrySet()) {
            this.addDeletionToBatch(omMetadataManager, batchOperation, openKeyTable, keyInfoPair.getKey(), keyInfoPair.getValue());
        }
    }
}

