/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.s3.tenant;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.util.HashMap;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.OMMultiTenantManager;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.execution.flowcontrol.ExecutionContext;
import org.apache.hadoop.ozone.om.helpers.OmDBAccessIdInfo;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.s3.tenant.OMTenantAssignAdminResponse;
import org.apache.hadoop.ozone.om.upgrade.BelongsToLayoutVersion;
import org.apache.hadoop.ozone.om.upgrade.DisallowedUntilLayoutVersion;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutFeature;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutFeatureAspect;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMTenantAssignAdminRequest
extends OMClientRequest {
    public static final Logger LOG;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        OMTenantAssignAdminRequest.ajc$preClinit();
        LOG = LoggerFactory.getLogger(OMTenantAssignAdminRequest.class);
    }

    public OMTenantAssignAdminRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    @DisallowedUntilLayoutVersion(value=OMLayoutFeature.MULTITENANCY_SCHEMA)
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        OzoneManager ozoneManager2 = ozoneManager;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)ozoneManager2);
        OMLayoutFeatureAspect.aspectOf().checkLayoutFeature(joinPoint);
        if (this != null && this.getClass().isAnnotationPresent(BelongsToLayoutVersion.class)) {
            OMLayoutFeatureAspect.aspectOf().beforeRequestApplyTxn(joinPoint);
        }
        OzoneManagerProtocolProtos.OMRequest omRequest = super.preExecute(ozoneManager);
        OzoneManagerProtocolProtos.TenantAssignAdminRequest request = omRequest.getTenantAssignAdminRequest();
        String accessId = request.getAccessId();
        String tenantId = request.getTenantId();
        OMMultiTenantManager multiTenantManager = ozoneManager.getMultiTenantManager();
        if (StringUtils.isEmpty((CharSequence)tenantId)) {
            Optional<String> optionalTenantId = multiTenantManager.getTenantForAccessID(accessId);
            if (!optionalTenantId.isPresent()) {
                throw new OMException("accessId '" + accessId + "' is not assigned to " + "any tenant", OMException.ResultCodes.TENANT_NOT_FOUND);
            }
            tenantId = optionalTenantId.get();
            assert (!StringUtils.isEmpty((CharSequence)tenantId));
        }
        multiTenantManager.checkTenantExistence(tenantId);
        multiTenantManager.checkTenantAdmin(tenantId, true);
        OmDBAccessIdInfo accessIdInfo = (OmDBAccessIdInfo)ozoneManager.getMetadataManager().getTenantAccessIdTable().get((Object)accessId);
        if (accessIdInfo == null) {
            throw new OMException("accessId '" + accessId + "' not found.", OMException.ResultCodes.ACCESS_ID_NOT_FOUND);
        }
        if (!accessIdInfo.getTenantId().equals(tenantId)) {
            throw new OMException("accessId '" + accessId + "' must be assigned to tenant '" + tenantId + "' first.", OMException.ResultCodes.INVALID_TENANT_ID);
        }
        boolean delegated = request.hasDelegated() ? request.getDelegated() : true;
        multiTenantManager.getAuthorizerLock().tryWriteLockInOMRequest();
        try {
            multiTenantManager.getAuthorizerOp().assignTenantAdmin(accessId, delegated);
        }
        catch (Exception e) {
            multiTenantManager.getAuthorizerLock().unlockWriteInOMRequest();
            throw e;
        }
        OzoneManagerProtocolProtos.OMRequest.Builder omRequestBuilder = omRequest.toBuilder().setTenantAssignAdminRequest(OzoneManagerProtocolProtos.TenantAssignAdminRequest.newBuilder().setAccessId(accessId).setTenantId(tenantId).setDelegated(delegated).build());
        return omRequestBuilder.build();
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, ExecutionContext context) {
        Exception exception;
        boolean delegated;
        String tenantId;
        String accessId;
        HashMap<String, String> auditMap;
        OMTenantAssignAdminResponse omClientResponse;
        OMMetrics omMetrics;
        block15: {
            OMMultiTenantManager multiTenantManager = ozoneManager.getMultiTenantManager();
            omMetrics = ozoneManager.getMetrics();
            omMetrics.incNumTenantAssignAdmins();
            omClientResponse = null;
            OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
            auditMap = new HashMap<String, String>();
            OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
            OzoneManagerProtocolProtos.TenantAssignAdminRequest request = this.getOmRequest().getTenantAssignAdminRequest();
            accessId = request.getAccessId();
            tenantId = request.getTenantId();
            delegated = request.getDelegated();
            boolean acquiredVolumeLock = false;
            exception = null;
            String volumeName = null;
            try {
                try {
                    volumeName = ozoneManager.getMultiTenantManager().getTenantVolumeName(tenantId);
                    this.mergeOmLockDetails(omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volumeName}));
                    acquiredVolumeLock = this.getOmLockDetails().isLockAcquired();
                    OmDBAccessIdInfo dbAccessIdInfo = (OmDBAccessIdInfo)omMetadataManager.getTenantAccessIdTable().get((Object)accessId);
                    if (dbAccessIdInfo == null) {
                        throw new OMException("OmDBAccessIdInfo entry is missing for accessId '" + accessId + "'", OMException.ResultCodes.METADATA_ERROR);
                    }
                    assert (dbAccessIdInfo.getTenantId().equals(tenantId));
                    OmDBAccessIdInfo newOmDBAccessIdInfo = new OmDBAccessIdInfo.Builder().setTenantId(dbAccessIdInfo.getTenantId()).setUserPrincipal(dbAccessIdInfo.getUserPrincipal()).setIsAdmin(true).setIsDelegatedAdmin(delegated).build();
                    omMetadataManager.getTenantAccessIdTable().addCacheEntry(new CacheKey((Object)accessId), CacheValue.get((long)context.getIndex(), (Object)newOmDBAccessIdInfo));
                    multiTenantManager.getCacheOp().assignTenantAdmin(accessId, delegated);
                    omResponse.setTenantAssignAdminResponse(OzoneManagerProtocolProtos.TenantAssignAdminResponse.newBuilder().build());
                    omClientResponse = new OMTenantAssignAdminResponse(omResponse.build(), accessId, newOmDBAccessIdInfo);
                }
                catch (IOException | InvalidPathException ex) {
                    exception = ex;
                    omClientResponse = new OMTenantAssignAdminResponse(this.createErrorOMResponse(omResponse, exception));
                    if (acquiredVolumeLock) {
                        Preconditions.checkNotNull((Object)volumeName);
                        this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volumeName}));
                    }
                    multiTenantManager.getAuthorizerLock().unlockWriteInOMRequest();
                    if (omClientResponse != null) {
                        omClientResponse.setOmLockDetails(this.getOmLockDetails());
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (acquiredVolumeLock) {
                    Preconditions.checkNotNull((Object)volumeName);
                    this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volumeName}));
                }
                multiTenantManager.getAuthorizerLock().unlockWriteInOMRequest();
                if (omClientResponse != null) {
                    omClientResponse.setOmLockDetails(this.getOmLockDetails());
                }
                throw throwable;
            }
            if (acquiredVolumeLock) {
                Preconditions.checkNotNull((Object)volumeName);
                this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volumeName}));
            }
            multiTenantManager.getAuthorizerLock().unlockWriteInOMRequest();
            if (omClientResponse != null) {
                omClientResponse.setOmLockDetails(this.getOmLockDetails());
            }
        }
        auditMap.put("tenant", tenantId);
        this.markForAudit(ozoneManager.getAuditLogger(), this.buildAuditMessage(OMAction.TENANT_ASSIGN_ADMIN, auditMap, exception, this.getOmRequest().getUserInfo()));
        if (exception == null) {
            LOG.info("Assigned admin to accessId '{}' in tenant '{}', delegated: {}", new Object[]{accessId, tenantId, delegated});
        } else {
            LOG.error("Failed to assign admin to accessId '{}' in tenant '{}', delegated: {}: {}", new Object[]{accessId, tenantId, delegated, exception.getMessage()});
            omMetrics.incNumTenantAssignAdminFails();
        }
        return omClientResponse;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OMTenantAssignAdminRequest.java", OMTenantAssignAdminRequest.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "preExecute", "org.apache.hadoop.ozone.om.request.s3.tenant.OMTenantAssignAdminRequest", "org.apache.hadoop.ozone.om.OzoneManager", "ozoneManager", "java.io.IOException", "org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos$OMRequest"), 71);
    }
}

