/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.ratis.utils;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.protobuf.ServiceException;
import java.io.File;
import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.security.SecurityConfig;
import org.apache.hadoop.hdds.security.x509.certificate.client.CertificateClient;
import org.apache.hadoop.hdds.server.ServerUtils;
import org.apache.hadoop.hdds.utils.HAUtils;
import org.apache.hadoop.hdds.utils.TransactionInfo;
import org.apache.hadoop.hdds.utils.db.DBDefinition;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.OzoneManagerUtils;
import org.apache.hadoop.ozone.om.codec.OMDBDefinition;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.exceptions.OMLeaderNotReadyException;
import org.apache.hadoop.ozone.om.exceptions.OMNotLeaderException;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.request.BucketLayoutAwareOMKeyRequestFactory;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.bucket.OMBucketCreateRequest;
import org.apache.hadoop.ozone.om.request.bucket.OMBucketDeleteRequest;
import org.apache.hadoop.ozone.om.request.bucket.OMBucketSetOwnerRequest;
import org.apache.hadoop.ozone.om.request.bucket.OMBucketSetPropertyRequest;
import org.apache.hadoop.ozone.om.request.bucket.acl.OMBucketAddAclRequest;
import org.apache.hadoop.ozone.om.request.bucket.acl.OMBucketRemoveAclRequest;
import org.apache.hadoop.ozone.om.request.bucket.acl.OMBucketSetAclRequest;
import org.apache.hadoop.ozone.om.request.file.OMRecoverLeaseRequest;
import org.apache.hadoop.ozone.om.request.key.OMDirectoriesPurgeRequestWithFSO;
import org.apache.hadoop.ozone.om.request.key.OMKeyPurgeRequest;
import org.apache.hadoop.ozone.om.request.key.OMOpenKeysDeleteRequest;
import org.apache.hadoop.ozone.om.request.key.acl.OMKeyAddAclRequest;
import org.apache.hadoop.ozone.om.request.key.acl.OMKeyAddAclRequestWithFSO;
import org.apache.hadoop.ozone.om.request.key.acl.OMKeyRemoveAclRequest;
import org.apache.hadoop.ozone.om.request.key.acl.OMKeyRemoveAclRequestWithFSO;
import org.apache.hadoop.ozone.om.request.key.acl.OMKeySetAclRequest;
import org.apache.hadoop.ozone.om.request.key.acl.OMKeySetAclRequestWithFSO;
import org.apache.hadoop.ozone.om.request.key.acl.prefix.OMPrefixAddAclRequest;
import org.apache.hadoop.ozone.om.request.key.acl.prefix.OMPrefixRemoveAclRequest;
import org.apache.hadoop.ozone.om.request.key.acl.prefix.OMPrefixSetAclRequest;
import org.apache.hadoop.ozone.om.request.s3.multipart.S3ExpiredMultipartUploadsAbortRequest;
import org.apache.hadoop.ozone.om.request.s3.security.OMSetSecretRequest;
import org.apache.hadoop.ozone.om.request.s3.security.S3GetSecretRequest;
import org.apache.hadoop.ozone.om.request.s3.security.S3RevokeSecretRequest;
import org.apache.hadoop.ozone.om.request.s3.tenant.OMSetRangerServiceVersionRequest;
import org.apache.hadoop.ozone.om.request.s3.tenant.OMTenantAssignAdminRequest;
import org.apache.hadoop.ozone.om.request.s3.tenant.OMTenantAssignUserAccessIdRequest;
import org.apache.hadoop.ozone.om.request.s3.tenant.OMTenantCreateRequest;
import org.apache.hadoop.ozone.om.request.s3.tenant.OMTenantDeleteRequest;
import org.apache.hadoop.ozone.om.request.s3.tenant.OMTenantRevokeAdminRequest;
import org.apache.hadoop.ozone.om.request.s3.tenant.OMTenantRevokeUserAccessIdRequest;
import org.apache.hadoop.ozone.om.request.security.OMCancelDelegationTokenRequest;
import org.apache.hadoop.ozone.om.request.security.OMGetDelegationTokenRequest;
import org.apache.hadoop.ozone.om.request.security.OMRenewDelegationTokenRequest;
import org.apache.hadoop.ozone.om.request.snapshot.OMSnapshotCreateRequest;
import org.apache.hadoop.ozone.om.request.snapshot.OMSnapshotDeleteRequest;
import org.apache.hadoop.ozone.om.request.snapshot.OMSnapshotMoveDeletedKeysRequest;
import org.apache.hadoop.ozone.om.request.snapshot.OMSnapshotMoveTableKeysRequest;
import org.apache.hadoop.ozone.om.request.snapshot.OMSnapshotPurgeRequest;
import org.apache.hadoop.ozone.om.request.snapshot.OMSnapshotRenameRequest;
import org.apache.hadoop.ozone.om.request.snapshot.OMSnapshotSetPropertyRequest;
import org.apache.hadoop.ozone.om.request.upgrade.OMCancelPrepareRequest;
import org.apache.hadoop.ozone.om.request.upgrade.OMFinalizeUpgradeRequest;
import org.apache.hadoop.ozone.om.request.upgrade.OMPrepareRequest;
import org.apache.hadoop.ozone.om.request.util.OMEchoRPCWriteRequest;
import org.apache.hadoop.ozone.om.request.volume.OMQuotaRepairRequest;
import org.apache.hadoop.ozone.om.request.volume.OMVolumeCreateRequest;
import org.apache.hadoop.ozone.om.request.volume.OMVolumeDeleteRequest;
import org.apache.hadoop.ozone.om.request.volume.OMVolumeSetOwnerRequest;
import org.apache.hadoop.ozone.om.request.volume.OMVolumeSetQuotaRequest;
import org.apache.hadoop.ozone.om.request.volume.acl.OMVolumeAddAclRequest;
import org.apache.hadoop.ozone.om.request.volume.acl.OMVolumeRemoveAclRequest;
import org.apache.hadoop.ozone.om.request.volume.acl.OMVolumeSetAclRequest;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.ratis.grpc.GrpcTlsConfig;
import org.apache.ratis.protocol.ClientId;
import org.rocksdb.RocksDBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OzoneManagerRatisUtils {
    private static final Logger LOG = LoggerFactory.getLogger(OzoneManagerRatisUtils.class);

    private OzoneManagerRatisUtils() {
    }

    public static OMClientRequest createClientRequest(OzoneManagerProtocolProtos.OMRequest omRequest, OzoneManager ozoneManager) throws IOException {
        OzoneManagerProtocolProtos.Type cmdType = omRequest.getCmdType();
        BucketLayout bucketLayout = BucketLayout.DEFAULT;
        String volumeName = "";
        String bucketName = "";
        switch (cmdType) {
            case CreateVolume: {
                return new OMVolumeCreateRequest(omRequest);
            }
            case SetVolumeProperty: {
                boolean hasQuota = omRequest.getSetVolumePropertyRequest().hasQuotaInBytes();
                boolean hasOwner = omRequest.getSetVolumePropertyRequest().hasOwnerName();
                Preconditions.checkState((hasOwner || hasQuota ? 1 : 0) != 0, (Object)"Either Quota or owner should be set in the SetVolumeProperty request");
                Preconditions.checkState((!hasOwner || !hasQuota ? 1 : 0) != 0, (Object)"Either Quota or owner should be set in the SetVolumeProperty request. Should not set both");
                if (hasQuota) {
                    return new OMVolumeSetQuotaRequest(omRequest);
                }
                return new OMVolumeSetOwnerRequest(omRequest);
            }
            case DeleteVolume: {
                return new OMVolumeDeleteRequest(omRequest);
            }
            case CreateBucket: {
                return new OMBucketCreateRequest(omRequest);
            }
            case DeleteBucket: {
                return new OMBucketDeleteRequest(omRequest);
            }
            case SetBucketProperty: {
                boolean hasBucketOwner = omRequest.getSetBucketPropertyRequest().getBucketArgs().hasOwnerName();
                if (hasBucketOwner) {
                    return new OMBucketSetOwnerRequest(omRequest);
                }
                return new OMBucketSetPropertyRequest(omRequest);
            }
            case AddAcl: 
            case RemoveAcl: 
            case SetAcl: {
                return OzoneManagerRatisUtils.getOMAclRequest(omRequest, ozoneManager);
            }
            case GetDelegationToken: {
                return new OMGetDelegationTokenRequest(omRequest);
            }
            case CancelDelegationToken: {
                return new OMCancelDelegationTokenRequest(omRequest);
            }
            case RenewDelegationToken: {
                return new OMRenewDelegationTokenRequest(omRequest);
            }
            case GetS3Secret: {
                return new S3GetSecretRequest(omRequest);
            }
            case FinalizeUpgrade: {
                return new OMFinalizeUpgradeRequest(omRequest);
            }
            case Prepare: {
                return new OMPrepareRequest(omRequest);
            }
            case CancelPrepare: {
                return new OMCancelPrepareRequest(omRequest);
            }
            case SetS3Secret: {
                return new OMSetSecretRequest(omRequest);
            }
            case RevokeS3Secret: {
                return new S3RevokeSecretRequest(omRequest);
            }
            case PurgeKeys: {
                return new OMKeyPurgeRequest(omRequest);
            }
            case PurgeDirectories: {
                return new OMDirectoriesPurgeRequestWithFSO(omRequest);
            }
            case CreateTenant: {
                ozoneManager.checkS3MultiTenancyEnabled();
                return new OMTenantCreateRequest(omRequest);
            }
            case DeleteTenant: {
                ozoneManager.checkS3MultiTenancyEnabled();
                return new OMTenantDeleteRequest(omRequest);
            }
            case TenantAssignUserAccessId: {
                ozoneManager.checkS3MultiTenancyEnabled();
                return new OMTenantAssignUserAccessIdRequest(omRequest);
            }
            case TenantRevokeUserAccessId: {
                ozoneManager.checkS3MultiTenancyEnabled();
                return new OMTenantRevokeUserAccessIdRequest(omRequest);
            }
            case TenantAssignAdmin: {
                ozoneManager.checkS3MultiTenancyEnabled();
                return new OMTenantAssignAdminRequest(omRequest);
            }
            case TenantRevokeAdmin: {
                ozoneManager.checkS3MultiTenancyEnabled();
                return new OMTenantRevokeAdminRequest(omRequest);
            }
            case SetRangerServiceVersion: {
                return new OMSetRangerServiceVersionRequest(omRequest);
            }
            case CreateSnapshot: {
                return new OMSnapshotCreateRequest(omRequest);
            }
            case DeleteSnapshot: {
                return new OMSnapshotDeleteRequest(omRequest);
            }
            case RenameSnapshot: {
                return new OMSnapshotRenameRequest(omRequest);
            }
            case SnapshotMoveDeletedKeys: {
                return new OMSnapshotMoveDeletedKeysRequest(omRequest);
            }
            case SnapshotMoveTableKeys: {
                return new OMSnapshotMoveTableKeysRequest(omRequest);
            }
            case SnapshotPurge: {
                return new OMSnapshotPurgeRequest(omRequest);
            }
            case SetSnapshotProperty: {
                return new OMSnapshotSetPropertyRequest(omRequest);
            }
            case DeleteOpenKeys: {
                BucketLayout bktLayout = BucketLayout.DEFAULT;
                if (omRequest.getDeleteOpenKeysRequest().hasBucketLayout()) {
                    bktLayout = BucketLayout.fromProto((OzoneManagerProtocolProtos.BucketLayoutProto)omRequest.getDeleteOpenKeysRequest().getBucketLayout());
                }
                return new OMOpenKeysDeleteRequest(omRequest, bktLayout);
            }
            case RecoverLease: {
                volumeName = omRequest.getRecoverLeaseRequest().getVolumeName();
                bucketName = omRequest.getRecoverLeaseRequest().getBucketName();
                bucketLayout = OzoneManagerUtils.getBucketLayout(ozoneManager.getMetadataManager(), volumeName, bucketName);
                if (bucketLayout != BucketLayout.FILE_SYSTEM_OPTIMIZED) {
                    throw new IOException("Bucket " + bucketName + " is not FSO layout. " + "It does not support lease recovery");
                }
                return new OMRecoverLeaseRequest(omRequest);
            }
            case CreateDirectory: {
                OzoneManagerProtocolProtos.KeyArgs keyArgs = omRequest.getCreateDirectoryRequest().getKeyArgs();
                volumeName = keyArgs.getVolumeName();
                bucketName = keyArgs.getBucketName();
                break;
            }
            case CreateFile: {
                OzoneManagerProtocolProtos.KeyArgs keyArgs = omRequest.getCreateFileRequest().getKeyArgs();
                volumeName = keyArgs.getVolumeName();
                bucketName = keyArgs.getBucketName();
                break;
            }
            case CreateKey: {
                OzoneManagerProtocolProtos.KeyArgs keyArgs = omRequest.getCreateKeyRequest().getKeyArgs();
                volumeName = keyArgs.getVolumeName();
                bucketName = keyArgs.getBucketName();
                break;
            }
            case AllocateBlock: {
                OzoneManagerProtocolProtos.KeyArgs keyArgs = omRequest.getAllocateBlockRequest().getKeyArgs();
                volumeName = keyArgs.getVolumeName();
                bucketName = keyArgs.getBucketName();
                break;
            }
            case CommitKey: {
                OzoneManagerProtocolProtos.KeyArgs keyArgs = omRequest.getCommitKeyRequest().getKeyArgs();
                volumeName = keyArgs.getVolumeName();
                bucketName = keyArgs.getBucketName();
                break;
            }
            case DeleteKey: {
                OzoneManagerProtocolProtos.KeyArgs keyArgs = omRequest.getDeleteKeyRequest().getKeyArgs();
                volumeName = keyArgs.getVolumeName();
                bucketName = keyArgs.getBucketName();
                break;
            }
            case DeleteKeys: {
                OzoneManagerProtocolProtos.DeleteKeyArgs deleteKeyArgs = omRequest.getDeleteKeysRequest().getDeleteKeys();
                volumeName = deleteKeyArgs.getVolumeName();
                bucketName = deleteKeyArgs.getBucketName();
                break;
            }
            case RenameKey: {
                OzoneManagerProtocolProtos.KeyArgs keyArgs = omRequest.getRenameKeyRequest().getKeyArgs();
                volumeName = keyArgs.getVolumeName();
                bucketName = keyArgs.getBucketName();
                break;
            }
            case RenameKeys: {
                OzoneManagerProtocolProtos.RenameKeysArgs renameKeysArgs = omRequest.getRenameKeysRequest().getRenameKeysArgs();
                volumeName = renameKeysArgs.getVolumeName();
                bucketName = renameKeysArgs.getBucketName();
                break;
            }
            case InitiateMultiPartUpload: {
                OzoneManagerProtocolProtos.KeyArgs keyArgs = omRequest.getInitiateMultiPartUploadRequest().getKeyArgs();
                volumeName = keyArgs.getVolumeName();
                bucketName = keyArgs.getBucketName();
                break;
            }
            case CommitMultiPartUpload: {
                OzoneManagerProtocolProtos.KeyArgs keyArgs = omRequest.getCommitMultiPartUploadRequest().getKeyArgs();
                volumeName = keyArgs.getVolumeName();
                bucketName = keyArgs.getBucketName();
                break;
            }
            case AbortMultiPartUpload: {
                OzoneManagerProtocolProtos.KeyArgs keyArgs = omRequest.getAbortMultiPartUploadRequest().getKeyArgs();
                volumeName = keyArgs.getVolumeName();
                bucketName = keyArgs.getBucketName();
                break;
            }
            case CompleteMultiPartUpload: {
                OzoneManagerProtocolProtos.KeyArgs keyArgs = omRequest.getCompleteMultiPartUploadRequest().getKeyArgs();
                volumeName = keyArgs.getVolumeName();
                bucketName = keyArgs.getBucketName();
                break;
            }
            case SetTimes: {
                OzoneManagerProtocolProtos.KeyArgs keyArgs = omRequest.getSetTimesRequest().getKeyArgs();
                volumeName = keyArgs.getVolumeName();
                bucketName = keyArgs.getBucketName();
                break;
            }
            case EchoRPC: {
                return new OMEchoRPCWriteRequest(omRequest);
            }
            case AbortExpiredMultiPartUploads: {
                return new S3ExpiredMultipartUploadsAbortRequest(omRequest);
            }
            case QuotaRepair: {
                return new OMQuotaRepairRequest(omRequest);
            }
            case PutObjectTagging: {
                OzoneManagerProtocolProtos.KeyArgs keyArgs = omRequest.getPutObjectTaggingRequest().getKeyArgs();
                volumeName = keyArgs.getVolumeName();
                bucketName = keyArgs.getBucketName();
                break;
            }
            case DeleteObjectTagging: {
                OzoneManagerProtocolProtos.KeyArgs keyArgs = omRequest.getDeleteObjectTaggingRequest().getKeyArgs();
                volumeName = keyArgs.getVolumeName();
                bucketName = keyArgs.getBucketName();
                break;
            }
            default: {
                throw new OMException("Unrecognized write command type request " + cmdType, OMException.ResultCodes.INVALID_REQUEST);
            }
        }
        return BucketLayoutAwareOMKeyRequestFactory.createRequest(volumeName, bucketName, omRequest, ozoneManager.getMetadataManager());
    }

    private static OMClientRequest getOMAclRequest(OzoneManagerProtocolProtos.OMRequest omRequest, OzoneManager ozoneManager) {
        OzoneManagerProtocolProtos.Type cmdType = omRequest.getCmdType();
        if (OzoneManagerProtocolProtos.Type.AddAcl == cmdType) {
            OzoneManagerProtocolProtos.OzoneObj.ObjectType type = omRequest.getAddAclRequest().getObj().getResType();
            if (OzoneManagerProtocolProtos.OzoneObj.ObjectType.VOLUME == type) {
                return new OMVolumeAddAclRequest(omRequest);
            }
            if (OzoneManagerProtocolProtos.OzoneObj.ObjectType.BUCKET == type) {
                return new OMBucketAddAclRequest(omRequest);
            }
            if (OzoneManagerProtocolProtos.OzoneObj.ObjectType.KEY == type) {
                OMKeyAddAclRequest aclReq = new OMKeyAddAclRequest(omRequest, ozoneManager);
                if (aclReq.getBucketLayout().isFileSystemOptimized()) {
                    return new OMKeyAddAclRequestWithFSO(omRequest, aclReq.getBucketLayout());
                }
                return aclReq;
            }
            return new OMPrefixAddAclRequest(omRequest);
        }
        if (OzoneManagerProtocolProtos.Type.RemoveAcl == cmdType) {
            OzoneManagerProtocolProtos.OzoneObj.ObjectType type = omRequest.getRemoveAclRequest().getObj().getResType();
            if (OzoneManagerProtocolProtos.OzoneObj.ObjectType.VOLUME == type) {
                return new OMVolumeRemoveAclRequest(omRequest);
            }
            if (OzoneManagerProtocolProtos.OzoneObj.ObjectType.BUCKET == type) {
                return new OMBucketRemoveAclRequest(omRequest);
            }
            if (OzoneManagerProtocolProtos.OzoneObj.ObjectType.KEY == type) {
                OMKeyRemoveAclRequest aclReq = new OMKeyRemoveAclRequest(omRequest, ozoneManager);
                if (aclReq.getBucketLayout().isFileSystemOptimized()) {
                    return new OMKeyRemoveAclRequestWithFSO(omRequest, aclReq.getBucketLayout());
                }
                return aclReq;
            }
            return new OMPrefixRemoveAclRequest(omRequest);
        }
        OzoneManagerProtocolProtos.OzoneObj.ObjectType type = omRequest.getSetAclRequest().getObj().getResType();
        if (OzoneManagerProtocolProtos.OzoneObj.ObjectType.VOLUME == type) {
            return new OMVolumeSetAclRequest(omRequest);
        }
        if (OzoneManagerProtocolProtos.OzoneObj.ObjectType.BUCKET == type) {
            return new OMBucketSetAclRequest(omRequest);
        }
        if (OzoneManagerProtocolProtos.OzoneObj.ObjectType.KEY == type) {
            OMKeySetAclRequest aclReq = new OMKeySetAclRequest(omRequest, ozoneManager);
            if (aclReq.getBucketLayout().isFileSystemOptimized()) {
                return new OMKeySetAclRequestWithFSO(omRequest, aclReq.getBucketLayout());
            }
            return aclReq;
        }
        return new OMPrefixSetAclRequest(omRequest);
    }

    public static OzoneManagerProtocolProtos.Status exceptionToResponseStatus(Exception exception) {
        if (exception instanceof OMException) {
            return OzoneManagerProtocolProtos.Status.values()[((OMException)((Object)exception)).getResult().ordinal()];
        }
        if (exception instanceof InvalidPathException) {
            return OzoneManagerProtocolProtos.Status.INVALID_PATH;
        }
        if (exception.getCause() != null && exception.getCause() instanceof RocksDBException) {
            return OzoneManagerProtocolProtos.Status.METADATA_ERROR;
        }
        return OzoneManagerProtocolProtos.Status.INTERNAL_ERROR;
    }

    public static TransactionInfo getTrxnInfoFromCheckpoint(OzoneConfiguration conf, Path dbPath) throws Exception {
        return HAUtils.getTrxnInfoFromCheckpoint((OzoneConfiguration)conf, (Path)dbPath, (DBDefinition)OMDBDefinition.get());
    }

    public static boolean verifyTransactionInfo(TransactionInfo transactionInfo, long lastAppliedIndex, String leaderId, Path newDBlocation) {
        return HAUtils.verifyTransactionInfo((TransactionInfo)transactionInfo, (long)lastAppliedIndex, (String)leaderId, (Path)newDBlocation, (Logger)OzoneManager.LOG);
    }

    public static String getOMRatisDirectory(ConfigurationSource conf) {
        String storageDir = conf.get("ozone.om.ratis.storage.dir");
        if (Strings.isNullOrEmpty((String)storageDir)) {
            storageDir = ServerUtils.getDefaultRatisDirectory((ConfigurationSource)conf);
        }
        return storageDir;
    }

    public static String getOMRatisSnapshotDirectory(ConfigurationSource conf) {
        String snapshotDir = conf.get("ozone.om.ratis.snapshot.dir");
        if (Strings.isNullOrEmpty((String)snapshotDir)) {
            LOG.warn("{} is not configured. Falling back to {} config", (Object)"ozone.om.ratis.snapshot.dir", (Object)"ozone.metadata.dirs");
            File metaDirPath = ServerUtils.getOzoneMetaDirPath((ConfigurationSource)conf);
            snapshotDir = Paths.get(metaDirPath.getPath(), "snapshot").toString();
        }
        return snapshotDir;
    }

    public static void checkLeaderStatus(OzoneManager ozoneManager) throws ServiceException {
        try {
            ozoneManager.checkLeaderStatus();
        }
        catch (OMLeaderNotReadyException | OMNotLeaderException e) {
            LOG.debug(e.getMessage());
            throw new ServiceException(e);
        }
    }

    public static GrpcTlsConfig createServerTlsConfig(SecurityConfig conf, CertificateClient caClient) throws IOException {
        if (conf.isSecurityEnabled() && conf.isGrpcTlsEnabled()) {
            return new GrpcTlsConfig((KeyManager)caClient.getKeyManager(), (TrustManager)caClient.getTrustManager(), true);
        }
        return null;
    }

    public static OzoneManagerProtocolProtos.OMResponse submitRequest(OzoneManager om, OzoneManagerProtocolProtos.OMRequest omRequest, ClientId clientId, long callId) throws ServiceException {
        return om.getOmRatisServer().submitRequest(omRequest, clientId, callId);
    }
}

