/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.helpers;

import com.google.common.base.Preconditions;
import com.google.protobuf.MessageLite;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.hadoop.hdds.utils.db.Codec;
import org.apache.hadoop.hdds.utils.db.CopyObject;
import org.apache.hadoop.hdds.utils.db.DelegatedCodec;
import org.apache.hadoop.hdds.utils.db.Proto2Codec;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.om.helpers.KeyValueUtil;
import org.apache.hadoop.ozone.om.helpers.OzoneAclStorageUtil;
import org.apache.hadoop.ozone.om.helpers.OzoneAclUtil;
import org.apache.hadoop.ozone.om.helpers.WithObjectID;
import org.apache.hadoop.ozone.storage.proto.OzoneManagerStorageProtos;

public final class OmPrefixInfo
extends WithObjectID
implements CopyObject<OmPrefixInfo> {
    private static final Codec<OmPrefixInfo> CODEC = new DelegatedCodec(Proto2Codec.get((MessageLite)OzoneManagerStorageProtos.PersistedPrefixInfo.getDefaultInstance()), OmPrefixInfo::getFromProtobuf, OmPrefixInfo::getProtobuf, OmPrefixInfo.class);
    private final String name;
    private final CopyOnWriteArrayList<OzoneAcl> acls;

    private OmPrefixInfo(Builder b) {
        super((WithObjectID.Builder)b);
        this.name = b.name;
        this.acls = new CopyOnWriteArrayList(b.acls);
    }

    public static Codec<OmPrefixInfo> getCodec() {
        return CODEC;
    }

    public List<OzoneAcl> getAcls() {
        return this.acls;
    }

    public boolean addAcl(OzoneAcl acl) {
        return OzoneAclUtil.addAcl(this.acls, (OzoneAcl)acl);
    }

    public boolean removeAcl(OzoneAcl acl) {
        return OzoneAclUtil.removeAcl(this.acls, (OzoneAcl)acl);
    }

    public boolean setAcls(List<OzoneAcl> newAcls) {
        return OzoneAclUtil.setAcl(this.acls, newAcls);
    }

    public String getName() {
        return this.name;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public OzoneManagerStorageProtos.PersistedPrefixInfo getProtobuf() {
        OzoneManagerStorageProtos.PersistedPrefixInfo.Builder pib = OzoneManagerStorageProtos.PersistedPrefixInfo.newBuilder().setName(this.name).addAllMetadata(KeyValueUtil.toProtobuf((Map)this.getMetadata())).setObjectID(this.getObjectID()).setUpdateID(this.getUpdateID());
        if (this.acls != null) {
            pib.addAllAcls(OzoneAclStorageUtil.toProtobuf(this.acls));
        }
        return pib.build();
    }

    public static OmPrefixInfo getFromProtobuf(OzoneManagerStorageProtos.PersistedPrefixInfo prefixInfo) {
        Builder opib = OmPrefixInfo.newBuilder().setName(prefixInfo.getName());
        if (prefixInfo.getMetadataList() != null) {
            opib.addAllMetadata((Map<String, String>)KeyValueUtil.getFromProtobuf(prefixInfo.getMetadataList()));
        }
        if (prefixInfo.getAclsList() != null) {
            opib.setAcls(OzoneAclStorageUtil.fromProtobuf(prefixInfo.getAclsList()));
        }
        if (prefixInfo.hasObjectID()) {
            opib.setObjectID(prefixInfo.getObjectID());
        }
        if (prefixInfo.hasUpdateID()) {
            opib.setUpdateID(prefixInfo.getUpdateID());
        }
        return opib.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        OmPrefixInfo that = (OmPrefixInfo)((Object)o);
        return this.name.equals(that.name) && Objects.equals(this.acls, that.acls) && Objects.equals(this.getMetadata(), that.getMetadata()) && this.getObjectID() == that.getObjectID() && this.getUpdateID() == that.getUpdateID();
    }

    public int hashCode() {
        return Objects.hash(this.name, this.acls, this.getMetadata(), this.getObjectID(), this.getUpdateID());
    }

    public String toString() {
        return "OmPrefixInfo{name='" + this.name + '\'' + ", acls=" + this.acls + ", metadata=" + this.getMetadata() + ", objectID=" + this.getObjectID() + ", updateID=" + this.getUpdateID() + '}';
    }

    public OmPrefixInfo copyObject() {
        return this.toBuilder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder
    extends WithObjectID.Builder {
        private String name;
        private final List<OzoneAcl> acls;

        public Builder() {
            this.acls = new LinkedList<OzoneAcl>();
        }

        public Builder(OmPrefixInfo obj) {
            super((WithObjectID)obj);
            this.setName(obj.name);
            this.acls = new ArrayList<OzoneAcl>(obj.getAcls());
        }

        public Builder setAcls(List<OzoneAcl> listOfAcls) {
            if (listOfAcls != null) {
                this.acls.addAll(listOfAcls);
            }
            return this;
        }

        public Builder setName(String n) {
            this.name = n;
            return this;
        }

        public Builder addMetadata(String key, String value) {
            super.addMetadata(key, value);
            return this;
        }

        public Builder addAllMetadata(Map<String, String> additionalMetadata) {
            super.addAllMetadata(additionalMetadata);
            return this;
        }

        public Builder setObjectID(long obId) {
            super.setObjectID(obId);
            return this;
        }

        public Builder setUpdateID(long id) {
            super.setUpdateID(id);
            return this;
        }

        public OmPrefixInfo build() {
            Preconditions.checkNotNull((Object)this.name);
            return new OmPrefixInfo(this);
        }
    }
}

