/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.lock;

import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;

final class OzoneManagerLockUtil {
    private OzoneManagerLockUtil() {
    }

    public static String generateResourceLockName(OzoneManagerLock.Resource resource, String resourceName) {
        if (resource == OzoneManagerLock.Resource.S3_BUCKET_LOCK) {
            return "S3:" + resourceName;
        }
        if (resource == OzoneManagerLock.Resource.VOLUME_LOCK) {
            return "/" + resourceName;
        }
        if (resource == OzoneManagerLock.Resource.USER_LOCK) {
            return "$" + resourceName;
        }
        if (resource == OzoneManagerLock.Resource.S3_SECRET_LOCK) {
            return "S3Secret:" + resourceName;
        }
        if (resource == OzoneManagerLock.Resource.PREFIX_LOCK) {
            return "Prefix:" + resourceName;
        }
        throw new IllegalArgumentException("Bucket resource type is passed, to get BucketResourceLockName, use generateBucketLockName method");
    }

    public static String generateBucketLockName(String volumeName, String bucketName) {
        return "/" + volumeName + "/" + bucketName;
    }

    public static String generateSnapshotLockName(String volumeName, String bucketName, String snapshotName) {
        return OzoneManagerLockUtil.generateBucketLockName(volumeName, bucketName) + "/" + ".snapshot" + "/" + snapshotName;
    }

    public static String generateKeyPathLockName(String volumeName, String bucketName, String keyName) {
        return "/" + volumeName + "/" + bucketName + "/" + keyName;
    }
}

