/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.ozone.om.S3Batcher;
import org.apache.hadoop.ozone.om.S3SecretCache;
import org.apache.hadoop.ozone.om.S3SecretFunction;
import org.apache.hadoop.ozone.om.S3SecretManager;
import org.apache.hadoop.ozone.om.helpers.S3SecretValue;
import org.apache.hadoop.ozone.om.lock.IOzoneManagerLock;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;

public class S3SecretLockedManager
implements S3SecretManager {
    private final S3SecretManager secretManager;
    private final IOzoneManagerLock lock;

    public S3SecretLockedManager(S3SecretManager secretManager, IOzoneManagerLock lock) {
        this.secretManager = secretManager;
        this.lock = lock;
    }

    @Override
    public S3SecretValue getSecret(String kerberosID) throws IOException {
        S3SecretValue s3SecretValue;
        this.lock.acquireWriteLock(OzoneManagerLock.Resource.S3_SECRET_LOCK, kerberosID);
        try {
            s3SecretValue = this.secretManager.getSecret(kerberosID);
        }
        catch (Throwable throwable) {
            this.lock.releaseWriteLock(OzoneManagerLock.Resource.S3_SECRET_LOCK, kerberosID);
            throw throwable;
        }
        this.lock.releaseWriteLock(OzoneManagerLock.Resource.S3_SECRET_LOCK, kerberosID);
        return s3SecretValue;
    }

    @Override
    public String getSecretString(String awsAccessKey) throws IOException {
        String string;
        this.lock.acquireReadLock(OzoneManagerLock.Resource.S3_SECRET_LOCK, awsAccessKey);
        try {
            string = this.secretManager.getSecretString(awsAccessKey);
        }
        catch (Throwable throwable) {
            this.lock.releaseReadLock(OzoneManagerLock.Resource.S3_SECRET_LOCK, awsAccessKey);
            throw throwable;
        }
        this.lock.releaseReadLock(OzoneManagerLock.Resource.S3_SECRET_LOCK, awsAccessKey);
        return string;
    }

    @Override
    public void storeSecret(String kerberosId, S3SecretValue secretValue) throws IOException {
        this.lock.acquireWriteLock(OzoneManagerLock.Resource.S3_SECRET_LOCK, kerberosId);
        try {
            this.secretManager.storeSecret(kerberosId, secretValue);
        }
        catch (Throwable throwable) {
            this.lock.releaseWriteLock(OzoneManagerLock.Resource.S3_SECRET_LOCK, kerberosId);
            throw throwable;
        }
        this.lock.releaseWriteLock(OzoneManagerLock.Resource.S3_SECRET_LOCK, kerberosId);
    }

    @Override
    public void revokeSecret(String kerberosId) throws IOException {
        this.lock.acquireWriteLock(OzoneManagerLock.Resource.S3_SECRET_LOCK, kerberosId);
        try {
            this.secretManager.revokeSecret(kerberosId);
        }
        catch (Throwable throwable) {
            this.lock.releaseWriteLock(OzoneManagerLock.Resource.S3_SECRET_LOCK, kerberosId);
            throw throwable;
        }
        this.lock.releaseWriteLock(OzoneManagerLock.Resource.S3_SECRET_LOCK, kerberosId);
    }

    @Override
    public void clearS3Cache(List<Long> epochs) {
        this.lock.acquireWriteLock(OzoneManagerLock.Resource.S3_SECRET_LOCK, "cache");
        try {
            this.secretManager.clearS3Cache(epochs);
        }
        catch (Throwable throwable) {
            this.lock.releaseWriteLock(OzoneManagerLock.Resource.S3_SECRET_LOCK, "cache");
            throw throwable;
        }
        this.lock.releaseWriteLock(OzoneManagerLock.Resource.S3_SECRET_LOCK, "cache");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T doUnderLock(String lockId, S3SecretFunction<T> action) throws IOException {
        T t;
        this.lock.acquireWriteLock(OzoneManagerLock.Resource.S3_SECRET_LOCK, lockId);
        try {
            t = action.accept(this.secretManager);
        }
        catch (Throwable throwable) {
            this.lock.releaseWriteLock(OzoneManagerLock.Resource.S3_SECRET_LOCK, lockId);
            throw throwable;
        }
        this.lock.releaseWriteLock(OzoneManagerLock.Resource.S3_SECRET_LOCK, lockId);
        return t;
    }

    @Override
    public S3Batcher batcher() {
        return this.secretManager.batcher();
    }

    @Override
    public S3SecretCache cache() {
        return this.secretManager.cache();
    }
}

