/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shell.snapshot;

import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.shell.Handler;
import org.apache.hadoop.ozone.shell.ListOptions;
import org.apache.hadoop.ozone.shell.OzoneAddress;
import org.apache.hadoop.ozone.shell.bucket.BucketUri;
import picocli.CommandLine;

@CommandLine.Command(name="list", aliases={"ls"}, description={"List snapshots for the buckets."})
public class ListSnapshotHandler
extends Handler {
    @CommandLine.Mixin
    private BucketUri snapshotPath;
    @CommandLine.Mixin
    private ListOptions listOptions;

    @Override
    protected OzoneAddress getAddress() {
        return this.snapshotPath.getValue();
    }

    @Override
    protected void execute(OzoneClient client, OzoneAddress address) throws IOException {
        String volumeName = this.snapshotPath.getValue().getVolumeName();
        String bucketName = this.snapshotPath.getValue().getBucketName();
        Iterator snapshotInfos = client.getObjectStore().listSnapshot(volumeName, bucketName, this.listOptions.getPrefix(), this.listOptions.getStartItem());
        int counter = this.printAsJsonArray(snapshotInfos, this.listOptions.getLimit());
        if (this.isVerbose()) {
            this.err().printf("Found : %d snapshots for o3://%s/%s %n", counter, volumeName, bucketName);
        }
    }
}

