/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shell.keys;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.OzoneKeyDetails;
import org.apache.hadoop.ozone.client.OzoneVolume;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.OzoneFSUtils;
import org.apache.hadoop.ozone.shell.OzoneAddress;
import org.apache.hadoop.ozone.shell.keys.KeyHandler;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Time;
import picocli.CommandLine;

@CommandLine.Command(name="delete", description={"deletes an existing key"})
public class DeleteKeyHandler
extends KeyHandler {
    private static final Path CURRENT = new Path("Current");

    @Override
    protected void execute(OzoneClient client, OzoneAddress address) throws IOException {
        String volumeName = address.getVolumeName();
        String bucketName = address.getBucketName();
        OzoneVolume vol = client.getObjectStore().getVolume(volumeName);
        OzoneBucket bucket = vol.getBucket(bucketName);
        String keyName = address.getKeyName();
        try {
            OmUtils.verifyKeyNameWithSnapshotReservedWordForDeletion((String)keyName);
        }
        catch (OMException omException) {
            this.out().printf("Operation not permitted: %s %n", omException.getMessage());
            return;
        }
        if (bucket.getBucketLayout().isLegacy() && keyName.endsWith("/") && this.getConf().getBoolean("ozone.om.enable.filesystem.paths", false)) {
            this.out().printf("Use FS(ofs/o3fs) interface to delete legacy bucket directory %n", new Object[0]);
            return;
        }
        if (bucket.getBucketLayout().isFileSystemOptimized()) {
            this.deleteFSOKey(bucket, keyName);
        } else {
            bucket.deleteKey(keyName);
        }
    }

    private void deleteFSOKey(OzoneBucket bucket, String keyName) throws IOException {
        float hadoopTrashInterval = this.getConf().getFloat("fs.trash.interval", 0.0f);
        long trashInterval = (long)(this.getConf().getFloat("ozone.fs.trash.interval", hadoopTrashInterval) * 10000.0f);
        if (trashInterval > 0L && !keyName.contains(".Trash")) {
            List ozoneFileStatusList;
            if (!this.isKeyExist(bucket, keyName = OzoneFSUtils.removeTrailingSlashIfNeeded((String)keyName))) {
                this.out().printf("Key not found %s %n", keyName);
                return;
            }
            if (bucket.getFileStatus(keyName).isDirectory() && (ozoneFileStatusList = bucket.listStatus(keyName, false, "", 1L)) != null && !ozoneFileStatusList.isEmpty()) {
                this.out().printf("Directory is not empty %n", new Object[0]);
                return;
            }
            String username = UserGroupInformation.getCurrentUser().getShortUserName();
            Path trashRoot = new Path("/", ".Trash");
            Path userTrash = new Path(trashRoot, username);
            Path userTrashCurrent = new Path(userTrash, CURRENT);
            String trashDirectory = (keyName.contains("/") ? new Path(userTrashCurrent, keyName.substring(0, keyName.lastIndexOf("/"))) : userTrashCurrent).toUri().getPath();
            String toKeyName = new Path(userTrashCurrent, keyName).toUri().getPath();
            if (this.isKeyExist(bucket, toKeyName)) {
                if (bucket.getFileStatus(toKeyName).isDirectory()) {
                    bucket.deleteKey(keyName);
                    return;
                }
                toKeyName = toKeyName + Time.now();
            }
            if (!this.isKeyExist(bucket, trashDirectory)) {
                bucket.createDirectory(trashDirectory);
            }
            bucket.renameKey(keyName, toKeyName);
            this.out().printf("Key moved inside Trash: %s %n", toKeyName);
        } else if (trashInterval > 0L && keyName.contains(".Trash")) {
            this.out().printf("Use fs command to delete key from Trash %n", new Object[0]);
        } else {
            bucket.deleteKey(keyName);
        }
    }

    private boolean isKeyExist(OzoneBucket bucket, String keyName) {
        OzoneKeyDetails keyDetails;
        try {
            keyDetails = bucket.getKey(keyName);
        }
        catch (IOException e) {
            return false;
        }
        return keyDetails != null;
    }
}

