/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.server;

import java.util.Map;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.server.SCMMXBean;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.Interns;

@InterfaceAudience.Private
@Metrics(about="SCM Container Manager Metrics", context="ozone")
public class SCMContainerMetrics
implements MetricsSource {
    private final SCMMXBean scmmxBean;
    private static final String SOURCE = SCMContainerMetrics.class.getSimpleName();

    public SCMContainerMetrics(SCMMXBean scmmxBean) {
        this.scmmxBean = scmmxBean;
    }

    public static SCMContainerMetrics create(SCMMXBean scmmxBean) {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        return (SCMContainerMetrics)ms.register(SOURCE, "Storage Container Manager Metrics", (Object)new SCMContainerMetrics(scmmxBean));
    }

    public void unRegister() {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        ms.unregisterSource(SOURCE);
    }

    public void getMetrics(MetricsCollector collector, boolean all) {
        Map<String, Integer> stateCount = this.scmmxBean.getContainerStateCount();
        int totalContainers = 0;
        for (HddsProtos.LifeCycleState state : HddsProtos.LifeCycleState.values()) {
            totalContainers += stateCount.get(state.toString()).intValue();
        }
        collector.addRecord(SOURCE).addGauge(Interns.info((String)"OpenContainers", (String)"Number of open containers"), stateCount.get(HddsProtos.LifeCycleState.OPEN.toString()).intValue()).addGauge(Interns.info((String)"ClosingContainers", (String)"Number of containers in closing state"), stateCount.get(HddsProtos.LifeCycleState.CLOSING.toString()).intValue()).addGauge(Interns.info((String)"QuasiClosedContainers", (String)"Number of containers in quasi closed state"), stateCount.get(HddsProtos.LifeCycleState.QUASI_CLOSED.toString()).intValue()).addGauge(Interns.info((String)"ClosedContainers", (String)"Number of containers in closed state"), stateCount.get(HddsProtos.LifeCycleState.CLOSED.toString()).intValue()).addGauge(Interns.info((String)"DeletingContainers", (String)"Number of containers in deleting state"), stateCount.get(HddsProtos.LifeCycleState.DELETING.toString()).intValue()).addGauge(Interns.info((String)"DeletedContainers", (String)"Number of containers in deleted state"), stateCount.get(HddsProtos.LifeCycleState.DELETED.toString()).intValue()).addGauge(Interns.info((String)"TotalContainers", (String)"Number of all containers"), totalContainers);
    }
}

