/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.replication;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.protobuf.ByteString;
import com.google.protobuf.Proto2Utils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.hdds.client.ECReplicationConfig;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.StorageUnit;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.ContainerPlacementStatus;
import org.apache.hadoop.hdds.scm.PlacementPolicy;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerReplica;
import org.apache.hadoop.hdds.scm.container.replication.CommandTargetOverloadedException;
import org.apache.hadoop.hdds.scm.container.replication.ContainerHealthResult;
import org.apache.hadoop.hdds.scm.container.replication.ContainerReplicaOp;
import org.apache.hadoop.hdds.scm.container.replication.ECContainerReplicaCount;
import org.apache.hadoop.hdds.scm.container.replication.ReplicationManager;
import org.apache.hadoop.hdds.scm.container.replication.ReplicationManagerMetrics;
import org.apache.hadoop.hdds.scm.container.replication.ReplicationManagerUtil;
import org.apache.hadoop.hdds.scm.container.replication.UnhealthyReplicationHandler;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.apache.hadoop.hdds.scm.node.NodeStatus;
import org.apache.hadoop.hdds.scm.node.states.NodeNotFoundException;
import org.apache.hadoop.hdds.scm.pipeline.InsufficientDatanodesException;
import org.apache.hadoop.ozone.protocol.commands.ReconstructECContainersCommand;
import org.apache.hadoop.ozone.protocol.commands.ReplicateContainerCommand;
import org.apache.hadoop.ozone.protocol.commands.SCMCommand;
import org.apache.ratis.protocol.exceptions.NotLeaderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ECUnderReplicationHandler
implements UnhealthyReplicationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ECUnderReplicationHandler.class);
    private final PlacementPolicy containerPlacement;
    private final long currentContainerSize;
    private final ReplicationManager replicationManager;
    private final ReplicationManagerMetrics metrics;

    ECUnderReplicationHandler(PlacementPolicy containerPlacement, ConfigurationSource conf, ReplicationManager replicationManager) {
        this.containerPlacement = containerPlacement;
        this.currentContainerSize = (long)conf.getStorageSize("ozone.scm.container.size", "5GB", StorageUnit.BYTES);
        this.replicationManager = replicationManager;
        this.metrics = replicationManager.getMetrics();
    }

    private ContainerPlacementStatus validatePlacement(ContainerInfo container, List<DatanodeDetails> replicaNodes, List<DatanodeDetails> selectedNodes) {
        LOG.trace("Validating placement policy for container {}. Available replica nodes: {}. Selected target nodes: {}.", new Object[]{container.containerID(), replicaNodes, selectedNodes});
        ArrayList<DatanodeDetails> nodes = new ArrayList<DatanodeDetails>(replicaNodes);
        nodes.addAll(selectedNodes);
        return this.containerPlacement.validateContainerPlacement(nodes, nodes.size());
    }

    @Override
    public int processAndSendCommands(Set<ContainerReplica> replicas, List<ContainerReplicaOp> pendingOps, ContainerHealthResult result, int remainingMaintenanceRedundancy) throws IOException {
        ContainerInfo container = result.getContainerInfo();
        LOG.debug("Handling under-replicated container: {}", (Object)container);
        ECContainerReplicaCount replicaCount = new ECContainerReplicaCount(container, replicas, pendingOps, remainingMaintenanceRedundancy);
        if (replicaCount.isSufficientlyReplicated()) {
            LOG.info("The container {} state changed and it's not in under replication any more.", (Object)container.getContainerID());
            return 0;
        }
        if (replicaCount.isSufficientlyReplicated(true)) {
            LOG.info("The container {} with replicas {} will be sufficiently replicated after pending replicas are created", (Object)container.getContainerID(), replicaCount.getReplicas());
            return 0;
        }
        LOG.debug("Under-replicated container {} currently has replicas: {}.", (Object)container.containerID(), replicas);
        ReplicationManagerUtil.ExcludedAndUsedNodes excludedAndUsedNodes = ReplicationManagerUtil.getExcludedAndUsedNodes(container, new ArrayList<ContainerReplica>(replicas), Collections.emptySet(), pendingOps, this.replicationManager);
        List<DatanodeDetails> excludedNodes = excludedAndUsedNodes.getExcludedNodes();
        List<DatanodeDetails> usedNodes = excludedAndUsedNodes.getUsedNodes();
        ContainerID id = container.containerID();
        int commandsSent = 0;
        ArrayList<DatanodeDetails> deletionInFlight = new ArrayList<DatanodeDetails>();
        for (ContainerReplicaOp op : pendingOps) {
            if (op.getOpType() != ContainerReplicaOp.PendingOpType.DELETE) continue;
            deletionInFlight.add(op.getTarget());
        }
        Map<Integer, Pair<ContainerReplica, NodeStatus>> sources = this.filterSources(replicas, deletionInFlight);
        List<DatanodeDetails> availableSourceNodes = sources.values().stream().map(Pair::getLeft).map(ContainerReplica::getDatanodeDetails).filter(datanodeDetails -> datanodeDetails.getPersistedOpState() == HddsProtos.NodeOperationalState.IN_SERVICE).collect(Collectors.toList());
        try {
            IOException firstException;
            block16: {
                block15: {
                    firstException = null;
                    try {
                        commandsSent += this.processMissingIndexes(replicaCount, sources, availableSourceNodes, excludedNodes, usedNodes);
                    }
                    catch (CommandTargetOverloadedException | InsufficientDatanodesException e) {
                        firstException = e;
                    }
                    excludedNodes.addAll(this.replicationManager.getExcludedNodes());
                    try {
                        commandsSent += this.processDecommissioningIndexes(replicaCount, sources, availableSourceNodes, excludedNodes, usedNodes);
                    }
                    catch (CommandTargetOverloadedException | InsufficientDatanodesException e) {
                        if (firstException != null) break block15;
                        firstException = e;
                    }
                }
                try {
                    commandsSent += this.processMaintenanceOnlyIndexes(replicaCount, sources, excludedNodes, usedNodes);
                }
                catch (CommandTargetOverloadedException | InsufficientDatanodesException e) {
                    if (firstException != null) break block16;
                    firstException = e;
                }
            }
            if (firstException != null) {
                throw firstException;
            }
        }
        catch (SCMException e) {
            SCMException.ResultCodes code = e.getResult();
            if (code != SCMException.ResultCodes.FAILED_TO_FIND_SUITABLE_NODE) {
                throw e;
            }
            if (replicaCount.isOverReplicated()) {
                LOG.debug("Container {} is both under and over replicated. Cannot find enough target nodes, so handing off to the OverReplication handler", (Object)container);
                this.replicationManager.processOverReplicatedContainer(result);
            }
            this.checkAndRemoveUnhealthyReplica(replicaCount, deletionInFlight);
            throw e;
        }
        if (commandsSent == 0) {
            LOG.warn("Container {} is under replicated, but no commands were created to correct it", (Object)id);
        }
        return commandsSent;
    }

    private Map<Integer, Pair<ContainerReplica, NodeStatus>> filterSources(Set<ContainerReplica> replicas, List<DatanodeDetails> deletionInFlight) {
        return replicas.stream().filter(r -> r.getState() == StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.CLOSED).filter(r -> !deletionInFlight.contains(r.getDatanodeDetails())).map(r -> {
            try {
                return Pair.of((Object)r, (Object)this.replicationManager.getNodeStatus(r.getDatanodeDetails()));
            }
            catch (NodeNotFoundException e) {
                throw new IllegalStateException("Unable to find NodeStatus for " + r.getDatanodeDetails(), e);
            }
        }).filter(pair -> ((NodeStatus)pair.getRight()).isHealthy()).collect(Collectors.toMap(pair -> ((ContainerReplica)pair.getLeft()).getReplicaIndex(), pair -> pair, (p1, p2) -> {
            if (((NodeStatus)p1.getRight()).getOperationalState() == HddsProtos.NodeOperationalState.IN_SERVICE) {
                return p1;
            }
            return p2;
        }));
    }

    private int processMissingIndexes(ECContainerReplicaCount replicaCount, Map<Integer, Pair<ContainerReplica, NodeStatus>> sources, List<DatanodeDetails> availableSourceNodes, List<DatanodeDetails> excludedNodes, List<DatanodeDetails> usedNodes) throws IOException {
        boolean recoveryIsCritical;
        ContainerInfo container = replicaCount.getContainer();
        ECReplicationConfig repConfig = (ECReplicationConfig)container.getReplicationConfig();
        List<Integer> missingIndexes = replicaCount.unavailableIndexes(true);
        LOG.debug("Processing missing indexes {} for container {}.", missingIndexes, (Object)container.containerID());
        int expectedTargetCount = missingIndexes.size();
        boolean bl = recoveryIsCritical = expectedTargetCount == repConfig.getParity();
        if (expectedTargetCount == 0) {
            return 0;
        }
        int commandsSent = 0;
        if (sources.size() >= repConfig.getData()) {
            ContainerPlacementStatus placementStatusWithSelectedTargets;
            List<DatanodeDetails> targetsMaybeOverloaded;
            Set<DatanodeDetails> excludedDueToLoad = this.replicationManager.getExcludedNodes();
            boolean hasOverloaded = !excludedDueToLoad.isEmpty();
            ArrayList<DatanodeDetails> excludedOrOverloadedNodes = hasOverloaded ? new ArrayList<DatanodeDetails>((Collection<DatanodeDetails>)ImmutableSet.builder().addAll((Iterable)excludedNodes).addAll(excludedDueToLoad).build()) : excludedNodes;
            List<DatanodeDetails> selectedDatanodes = this.getTargetDatanodes(container, expectedTargetCount, usedNodes, (List<DatanodeDetails>)excludedOrOverloadedNodes);
            int targetCount = selectedDatanodes.size();
            if (hasOverloaded && 0 < targetCount && targetCount < expectedTargetCount && !recoveryIsCritical && (targetsMaybeOverloaded = this.getTargetDatanodes(container, expectedTargetCount, usedNodes, excludedNodes)).size() == expectedTargetCount) {
                int overloadedCount = expectedTargetCount - targetCount;
                LOG.info("Deferring reconstruction of container {}, which requires {} target nodes to be fully reconstructed, but {} selected nodes are currently overloaded.", new Object[]{container.getContainerID(), expectedTargetCount, overloadedCount});
                this.metrics.incrECPartialReconstructionSkippedTotal();
                throw new InsufficientDatanodesException(expectedTargetCount, targetCount);
            }
            if (targetCount < expectedTargetCount) {
                missingIndexes.subList(targetCount, expectedTargetCount).clear();
            }
            if (!(placementStatusWithSelectedTargets = this.validatePlacement(container, availableSourceNodes, selectedDatanodes)).isPolicySatisfied()) {
                LOG.debug("Target nodes + existing nodes for EC container {} will not satisfy placement policy {}. Reason: {}. Selected nodes: {}. Available source nodes: {}. Resuming reconstruction regardless.", new Object[]{container.containerID(), this.containerPlacement.getClass().getName(), placementStatusWithSelectedTargets.misReplicatedReason(), selectedDatanodes, availableSourceNodes});
            }
            if (0 < targetCount) {
                usedNodes.addAll(selectedDatanodes);
                availableSourceNodes.addAll(selectedDatanodes);
                ArrayList<ReconstructECContainersCommand.DatanodeDetailsAndReplicaIndex> sourceDatanodesWithIndex = new ArrayList<ReconstructECContainersCommand.DatanodeDetailsAndReplicaIndex>();
                for (Pair<ContainerReplica, NodeStatus> src : sources.values()) {
                    sourceDatanodesWithIndex.add(new ReconstructECContainersCommand.DatanodeDetailsAndReplicaIndex(((ContainerReplica)src.getLeft()).getDatanodeDetails(), ((ContainerReplica)src.getLeft()).getReplicaIndex()));
                }
                ReconstructECContainersCommand reconstructionCommand = new ReconstructECContainersCommand(container.getContainerID(), sourceDatanodesWithIndex, selectedDatanodes, ECUnderReplicationHandler.integers2ByteString(missingIndexes), repConfig);
                this.replicationManager.sendThrottledReconstructionCommand(container, reconstructionCommand);
                for (int i = 0; i < missingIndexes.size(); ++i) {
                    this.adjustPendingOps(replicaCount, selectedDatanodes.get(i), missingIndexes.get(i));
                }
                ++commandsSent;
            }
            if (targetCount != expectedTargetCount) {
                LOG.debug("Insufficient nodes were returned from the placement policy to fully reconstruct container {}. Requested {} received {}", new Object[]{container.getContainerID(), expectedTargetCount, targetCount});
                if (hasOverloaded && recoveryIsCritical) {
                    this.metrics.incrECPartialReconstructionCriticalTotal();
                } else {
                    this.metrics.incrEcPartialReconstructionNoneOverloadedTotal();
                }
                throw new InsufficientDatanodesException(expectedTargetCount, targetCount);
            }
        } else {
            LOG.warn("Cannot proceed for EC container reconstruction for {}, due to insufficient source replicas found. Number of source replicas needed: {}. Number of available source replicas are: {}. Available sources are: {}", new Object[]{container.containerID(), repConfig.getData(), sources.size(), sources});
        }
        LOG.trace("Sent {} commands for container {}.", (Object)commandsSent, (Object)container.containerID());
        return commandsSent;
    }

    private List<DatanodeDetails> getTargetDatanodes(ContainerInfo container, int requiredNodes, List<DatanodeDetails> usedNodes, List<DatanodeDetails> excludedNodes) throws SCMException {
        return ReplicationManagerUtil.getTargetDatanodes(this.containerPlacement, requiredNodes, usedNodes, excludedNodes, this.currentContainerSize, container);
    }

    private int processDecommissioningIndexes(ECContainerReplicaCount replicaCount, Map<Integer, Pair<ContainerReplica, NodeStatus>> sources, List<DatanodeDetails> availableSourceNodes, List<DatanodeDetails> excludedNodes, List<DatanodeDetails> usedNodes) throws IOException {
        ContainerInfo container = replicaCount.getContainer();
        Set<Integer> decomIndexes = replicaCount.decommissioningOnlyIndexes(true);
        int commandsSent = 0;
        if (!decomIndexes.isEmpty()) {
            LOG.debug("Processing decommissioning indexes {} for container {}.", decomIndexes, (Object)container.containerID());
            List<DatanodeDetails> selectedDatanodes = this.getTargetDatanodes(container, decomIndexes.size(), usedNodes, excludedNodes);
            ContainerPlacementStatus placementStatusWithSelectedTargets = this.validatePlacement(container, availableSourceNodes, selectedDatanodes);
            if (!placementStatusWithSelectedTargets.isPolicySatisfied()) {
                LOG.debug("Target nodes + existing nodes for EC container {} will not satisfy placement policy {}. Reason: {}. Selected nodes: {}. Available source nodes: {}. Resuming recovery regardless.", new Object[]{container.containerID(), this.containerPlacement.getClass().getName(), placementStatusWithSelectedTargets.misReplicatedReason(), selectedDatanodes, availableSourceNodes});
            }
            usedNodes.addAll(selectedDatanodes);
            Iterator<DatanodeDetails> iterator = selectedDatanodes.iterator();
            CommandTargetOverloadedException overloadedException = null;
            for (Integer decomIndex : decomIndexes) {
                Pair<ContainerReplica, NodeStatus> source = sources.get(decomIndex);
                if (source == null) {
                    LOG.warn("Cannot find source replica for decommissioning index {} in container {}", (Object)decomIndex, (Object)container.containerID());
                    continue;
                }
                ContainerReplica sourceReplica = (ContainerReplica)source.getLeft();
                if (!iterator.hasNext()) {
                    LOG.warn("Couldn't find enough targets. Available source nodes: {}, the target nodes: {}, excluded nodes: {}, usedNodes: {}, and the decommission indexes: {}", new Object[]{sources.values().stream().map(Pair::getLeft).collect(Collectors.toSet()), selectedDatanodes, excludedNodes, usedNodes, decomIndexes});
                    break;
                }
                try {
                    this.createReplicateCommand(container, iterator, sourceReplica, replicaCount);
                    ++commandsSent;
                }
                catch (CommandTargetOverloadedException e) {
                    LOG.debug("Unable to send Replicate command for container {} index {} because the source node {} is overloaded.", new Object[]{container.getContainerID(), sourceReplica.getReplicaIndex(), sourceReplica.getDatanodeDetails()});
                    overloadedException = e;
                }
            }
            if (overloadedException != null) {
                throw overloadedException;
            }
            if (selectedDatanodes.size() != decomIndexes.size()) {
                LOG.debug("Insufficient nodes were returned from the placement policy to fully replicate the decommission indexes for container {}. Requested {} received {}", new Object[]{container.getContainerID(), decomIndexes.size(), selectedDatanodes.size()});
                this.metrics.incrEcPartialReplicationForOutOfServiceReplicasTotal();
                throw new InsufficientDatanodesException(decomIndexes.size(), selectedDatanodes.size());
            }
        }
        LOG.trace("Sent {} commands for container {}.", (Object)commandsSent, (Object)container.containerID());
        return commandsSent;
    }

    private int processMaintenanceOnlyIndexes(ECContainerReplicaCount replicaCount, Map<Integer, Pair<ContainerReplica, NodeStatus>> sources, List<DatanodeDetails> excludedNodes, List<DatanodeDetails> usedNodes) throws IOException {
        Set<Integer> maintIndexes = replicaCount.maintenanceOnlyIndexes(true);
        if (maintIndexes.isEmpty()) {
            return 0;
        }
        ContainerInfo container = replicaCount.getContainer();
        LOG.debug("Processing maintenance indexes {} for container {}.", maintIndexes, (Object)container.containerID());
        int additionalMaintenanceCopiesNeeded = replicaCount.additionalMaintenanceCopiesNeeded(true);
        if (additionalMaintenanceCopiesNeeded == 0) {
            return 0;
        }
        LOG.debug("Number of maintenance replicas of container {} that need additional copies: {}.", (Object)container.containerID(), (Object)additionalMaintenanceCopiesNeeded);
        List<DatanodeDetails> targets = this.getTargetDatanodes(container, maintIndexes.size(), usedNodes, excludedNodes);
        usedNodes.addAll(targets);
        Iterator<DatanodeDetails> iterator = targets.iterator();
        int commandsSent = 0;
        CommandTargetOverloadedException overloadedException = null;
        for (Integer maintIndex : maintIndexes) {
            if (additionalMaintenanceCopiesNeeded <= 0) break;
            Pair<ContainerReplica, NodeStatus> source = sources.get(maintIndex);
            if (source == null) {
                LOG.warn("Cannot find source replica for maintenance index {} in container {}", (Object)maintIndex, (Object)container.containerID());
                continue;
            }
            ContainerReplica sourceReplica = (ContainerReplica)source.getLeft();
            if (!iterator.hasNext()) {
                LOG.warn("Couldn't find enough targets. Available source nodes: {}, target nodes: {}, excluded nodes: {}, usedNodes: {} and maintenance indexes: {}", new Object[]{sources.values().stream().map(Pair::getLeft).collect(Collectors.toSet()), targets, excludedNodes, usedNodes, maintIndexes});
                break;
            }
            try {
                this.createReplicateCommand(container, iterator, sourceReplica, replicaCount);
                ++commandsSent;
                --additionalMaintenanceCopiesNeeded;
            }
            catch (CommandTargetOverloadedException e) {
                LOG.debug("Unable to send Replicate command for container {} index {} because the source node {} is overloaded.", new Object[]{container.getContainerID(), sourceReplica.getReplicaIndex(), sourceReplica.getDatanodeDetails()});
                overloadedException = e;
            }
        }
        if (overloadedException != null) {
            throw overloadedException;
        }
        if (targets.size() != maintIndexes.size()) {
            LOG.debug("Insufficient nodes were returned from the placement policy to fully replicate the maintenance indexes for container {}. Requested {} received {}", new Object[]{container.getContainerID(), maintIndexes.size(), targets.size()});
            this.metrics.incrEcPartialReplicationForOutOfServiceReplicasTotal();
            throw new InsufficientDatanodesException(maintIndexes.size(), targets.size());
        }
        LOG.trace("Sent {} commands for container {}.", (Object)commandsSent, (Object)container.containerID());
        return commandsSent;
    }

    private void createReplicateCommand(ContainerInfo container, Iterator<DatanodeDetails> iterator, ContainerReplica replica, ECContainerReplicaCount replicaCount) throws CommandTargetOverloadedException, NotLeaderException {
        boolean push = this.replicationManager.getConfig().isPush();
        DatanodeDetails source = replica.getDatanodeDetails();
        DatanodeDetails target = iterator.next();
        long containerID = container.getContainerID();
        if (push) {
            this.replicationManager.sendThrottledReplicationCommand(container, Collections.singletonList(source), target, replica.getReplicaIndex());
        } else {
            ReplicateContainerCommand replicateCommand = ReplicateContainerCommand.fromSources((long)containerID, (List)ImmutableList.of((Object)source));
            replicateCommand.setReplicaIndex(replica.getReplicaIndex());
            this.replicationManager.sendDatanodeCommand((SCMCommand<?>)replicateCommand, container, target);
        }
        this.adjustPendingOps(replicaCount, target, replica.getReplicaIndex());
    }

    private void adjustPendingOps(ECContainerReplicaCount replicaCount, DatanodeDetails target, int replicaIndex) {
        replicaCount.addPendingOp(new ContainerReplicaOp(ContainerReplicaOp.PendingOpType.ADD, target, replicaIndex, null, Long.MAX_VALUE));
    }

    static ByteString integers2ByteString(List<Integer> src) {
        byte[] dst = new byte[src.size()];
        for (int i = 0; i < src.size(); ++i) {
            dst[i] = src.get(i).byteValue();
        }
        return Proto2Utils.unsafeByteString((byte[])dst);
    }

    private void checkAndRemoveUnhealthyReplica(ECContainerReplicaCount replicaCount, List<DatanodeDetails> deletionInFlight) {
        LOG.debug("Finding an UNHEALTHY replica of container {} to delete so its host datanode can be available for replication/reconstruction.", (Object)replicaCount.getContainer());
        if (!deletionInFlight.isEmpty()) {
            LOG.debug("There are {} pending deletes. Completing them could free up nodes to fix under replication. Not deleting UNHEALTHY replicas in this iteration.", (Object)deletionInFlight.size());
            return;
        }
        ContainerInfo container = replicaCount.getContainer();
        if (replicaCount.isUnrecoverable()) {
            LOG.warn("Cannot recover container {}.", (Object)container);
            return;
        }
        HashSet<Integer> closedReplicas = new HashSet<Integer>();
        HashSet<ContainerReplica> unhealthyReplicas = new HashSet<ContainerReplica>();
        for (ContainerReplica replica : replicaCount.getReplicas()) {
            block14: {
                try {
                    NodeStatus nodeStatus = this.replicationManager.getNodeStatus(replica.getDatanodeDetails());
                    if (!nodeStatus.isHealthy()) continue;
                    if (!nodeStatus.isInService()) {
                    }
                    break block14;
                }
                catch (NodeNotFoundException e) {
                    LOG.debug("Skipping replica {} when trying to unblock under replication handling.", (Object)replica, (Object)e);
                }
                continue;
            }
            if (replica.getState().equals((Object)StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.CLOSED)) {
                closedReplicas.add(replica.getReplicaIndex());
                continue;
            }
            if (!replica.getState().equals((Object)StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.UNHEALTHY)) continue;
            unhealthyReplicas.add(replica);
        }
        if (unhealthyReplicas.isEmpty()) {
            LOG.debug("Container {} does not have any UNHEALTHY replicas.", (Object)container.containerID());
            return;
        }
        for (ContainerReplica unhealthyReplica : unhealthyReplicas) {
            if (!closedReplicas.contains(unhealthyReplica.getReplicaIndex())) continue;
            try {
                this.replicationManager.sendThrottledDeleteCommand(replicaCount.getContainer(), unhealthyReplica.getReplicaIndex(), unhealthyReplica.getDatanodeDetails(), true);
                return;
            }
            catch (CommandTargetOverloadedException | NotLeaderException e) {
                LOG.debug("Skipping sending a delete command for replica {} to Datanode {}.", (Object)unhealthyReplica, (Object)unhealthyReplica.getDatanodeDetails());
            }
        }
        for (ContainerReplica unhealthyReplica : unhealthyReplicas) {
            try {
                this.replicationManager.sendThrottledDeleteCommand(replicaCount.getContainer(), unhealthyReplica.getReplicaIndex(), unhealthyReplica.getDatanodeDetails(), true);
                return;
            }
            catch (CommandTargetOverloadedException | NotLeaderException e) {
                LOG.debug("Skipping sending a delete command for replica {} to Datanode {}.", (Object)unhealthyReplica, (Object)unhealthyReplica.getDatanodeDetails());
            }
        }
    }
}

